/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.misc.impl;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.jdesktop.jdic.misc.Alerter;

public class WinAlerter
extends Alerter {
    private boolean isLoaded;
    private static Timer loop;

    public WinAlerter() throws SecurityException, UnsatisfiedLinkError {
        if (!this.isLoaded) {
            System.loadLibrary("jawt");
            System.loadLibrary("jdic_misc");
            this.isLoaded = true;
        }
    }

    public void alert(Frame frame) {
        if (!frame.isActive()) {
            if (loop != null) {
                ActionListener[] actionListenerArray = loop.getActionListeners();
                for (int i = 0; i < actionListenerArray.length; ++i) {
                    AlerterListener alerterListener;
                    if (!(actionListenerArray[i] instanceof AlerterListener) || !(alerterListener = (AlerterListener)actionListenerArray[i]).internalFrame.equals(frame)) continue;
                    return;
                }
                loop.addActionListener(new AlerterListener(frame));
                if (!loop.isRunning()) {
                    loop.start();
                }
            } else {
                int n = (int)this.getBlinkRate();
                loop = new Timer(n, new AlerterListener(frame));
                loop.start();
            }
        }
    }

    private native void alertWindows(Frame var1);

    private native long getBlinkRate();

    public boolean isAlertSupported() {
        return true;
    }

    private class AlerterListener
    implements ActionListener {
        private Frame internalFrame;

        private AlerterListener(Frame frame) {
            this.internalFrame = frame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.internalFrame.isActive()) {
                WinAlerter.this.alertWindows(this.internalFrame);
            } else {
                loop.removeActionListener(this);
            }
            if (loop.getActionListeners().length == 0 && loop.isRunning()) {
                loop.stop();
            }
        }
    }
}

