/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.SendStreamDesc;

class SendStreamImpl
implements SendStream {
    private boolean closed;
    public final SendStreamDesc sendStreamDesc;
    private boolean started;
    public final StreamRTPManager streamRTPManager;

    public SendStreamImpl(StreamRTPManager streamRTPManager, SendStreamDesc sendStreamDesc) {
        this.sendStreamDesc = sendStreamDesc;
        this.streamRTPManager = streamRTPManager;
    }

    public void close() {
        if (!this.closed) {
            try {
                if (this.started) {
                    this.stop();
                }
            }
            catch (IOException ioe) {
                throw new UndeclaredThrowableException(ioe);
            }
            finally {
                this.sendStreamDesc.close(this);
                this.closed = true;
            }
        }
    }

    public DataSource getDataSource() {
        return this.sendStreamDesc.sendStream.getDataSource();
    }

    public Participant getParticipant() {
        return this.sendStreamDesc.sendStream.getParticipant();
    }

    public SenderReport getSenderReport() {
        return this.sendStreamDesc.sendStream.getSenderReport();
    }

    public TransmissionStats getSourceTransmissionStats() {
        return this.sendStreamDesc.sendStream.getSourceTransmissionStats();
    }

    public long getSSRC() {
        return this.sendStreamDesc.sendStream.getSSRC();
    }

    public int setBitRate(int bitRate) {
        return 0;
    }

    public void setSourceDescription(SourceDescription[] sourceDescription) {
    }

    public void start() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot start SendStream after it has been closed.");
        }
        if (!this.started) {
            this.sendStreamDesc.start(this);
            this.started = true;
        }
    }

    public void stop() throws IOException {
        if (!this.closed && this.started) {
            this.sendStreamDesc.stop(this);
            this.started = false;
        }
    }
}

