/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.msghistory;

import com.google.common.xml.XmlEscapers;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.mock.MockBasicInstantMessaging;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockMultiUserChat;
import net.java.sip.communicator.impl.protocol.mock.MockPersistentPresenceOperationSet;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryAdvancedService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.slick.msghistory.MsgHistoryServiceLick;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class TestMsgHistoryService
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestMsgHistoryService.class);
    static final String TEST_CONTACT_NAME_1 = "Mincho_Penchev_the_fisrt";
    static final String TEST_CONTACT_NAME_2 = "Mincho_Penchev_the_second";
    static final String TEST_ROOM_NAME = "test_room";
    public static MockProvider mockProvider = null;
    public static MockPersistentPresenceOperationSet mockPresOpSet = null;
    public static MockBasicInstantMessaging mockBImOpSet = null;
    public static MockMultiUserChat mockMultiChat = null;
    private static ServiceReference msgHistoryServiceRef = null;
    public static MessageHistoryService msgHistoryService = null;
    public static HistoryService historyService = null;
    private static MockContact testContact = null;
    private static ServiceReference metaCLref = null;
    private static MetaContactListService metaClService = null;
    private static MetaContact testMetaContact = null;
    public static ServiceRegistration mockPrServiceRegistration = null;
    private static Message[] messagesToSend = null;
    private static Date controlDate1 = null;
    private static Date controlDate2 = null;
    private static Object lock = new Object();

    public TestMsgHistoryService(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestMsgHistoryService("readRecords"));
        suite.addTest((Test)new TestMsgHistoryService("specialChars"));
        suite.addTest((Test)new TestMsgHistoryService("insertRecords"));
        return suite;
    }

    protected void setUp() throws Exception {
        this.setupContact();
        msgHistoryService.eraseLocallyStoredHistory();
        historyService.purgeLocallyCachedHistories();
        this.writeRecords();
    }

    protected void tearDown() throws Exception {
        metaClService.purgeLocallyStoredContactListCopy();
    }

    public void setupContact() {
        System.setProperty("HistoryServiceDirectory", "test-msghistory");
        mockProvider = new MockProvider("MessageHistoryMockUser");
        Map supportedOperationSets = mockProvider.getSupportedOperationSets();
        mockPresOpSet = (MockPersistentPresenceOperationSet)supportedOperationSets.get(OperationSetPersistentPresence.class.getName());
        mockBImOpSet = (MockBasicInstantMessaging)supportedOperationSets.get(OperationSetBasicInstantMessaging.class.getName());
        mockMultiChat = (MockMultiUserChat)supportedOperationSets.get(OperationSetMultiUserChat.class.getName());
        msgHistoryServiceRef = MsgHistoryServiceLick.bc.getServiceReference(MessageHistoryService.class.getName());
        msgHistoryService = (MessageHistoryService)MsgHistoryServiceLick.bc.getService(msgHistoryServiceRef);
        ServiceReference historyServiceRef = MsgHistoryServiceLick.bc.getServiceReference(HistoryService.class.getName());
        historyService = (HistoryService)MsgHistoryServiceLick.bc.getService(historyServiceRef);
        MockContactGroup root = (MockContactGroup)mockPresOpSet.getServerStoredContactListRoot();
        testContact = new MockContact(TEST_CONTACT_NAME_1, mockProvider);
        root.addContact(testContact);
        metaCLref = MsgHistoryServiceLick.bc.getServiceReference(MetaContactListService.class.getName());
        metaClService = (MetaContactListService)MsgHistoryServiceLick.bc.getService(metaCLref);
        System.setProperty("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        Hashtable<String, String> mockProvProperties = new Hashtable<String, String>();
        mockProvProperties.put("PROTOCOL_NAME", mockProvider.getProtocolName());
        mockProvProperties.put("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        mockPrServiceRegistration = MsgHistoryServiceLick.bc.registerService(ProtocolProviderService.class.getName(), (Object)mockProvider, mockProvProperties);
        logger.debug((Object)"Registered a mock protocol provider! ");
        testMetaContact = metaClService.getRoot().getMetaContact((ProtocolProviderService)mockProvider, TEST_CONTACT_NAME_1);
        metaClService.addNewContactToMetaContact((ProtocolProviderService)mockProvider, testMetaContact, TEST_CONTACT_NAME_2);
        messagesToSend = new Message[]{mockBImOpSet.createMessage("test message word1-" + Math.random()), mockBImOpSet.createMessage("test message word2" + Math.random()), mockBImOpSet.createMessage("test message word3" + Math.random()), mockBImOpSet.createMessage("test message word4" + Math.random()), mockBImOpSet.createMessage("test message word5" + Math.random()), mockBImOpSet.createMessage("Hello \u0002World\u0002!"), mockBImOpSet.createMessage("less than < this, greater than > and an ampersand &")};
    }

    public void writeRecords() {
        logger.info((Object)"write records ");
        TestMsgHistoryService.assertNotNull((String)"No metacontact", (Object)testMetaContact);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[0]);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_2, messagesToSend[0]);
        TestMsgHistoryService.waitWrite(100L);
        controlDate1 = new Date();
        logger.info((Object)("controlDate1:" + controlDate1.getTime()));
        TestMsgHistoryService.waitWrite(100L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[1]);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_2, messagesToSend[2]);
        TestMsgHistoryService.waitWrite(100L);
        controlDate2 = new Date();
        logger.info((Object)("controlDate2:" + controlDate2.getTime()));
        TestMsgHistoryService.waitWrite(100L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[3]);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_2, messagesToSend[4]);
    }

    public void readRecords() {
        Collection rs = msgHistoryService.findByKeyword(testMetaContact, "test");
        TestMsgHistoryService.assertTrue((String)"Nothing found findByKeyword ", (!rs.isEmpty() ? 1 : 0) != 0);
        List<String> msgs = this.getMessages(rs);
        TestMsgHistoryService.assertTrue((String)"Messages too few - findByKeyword", (msgs.size() >= 3 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeyword(testMetaContact, "Test", false);
        TestMsgHistoryService.assertTrue((String)"Nothing found findByKeyword caseINsensitive search", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertTrue((String)"Messages too few - findByKeyword", (msgs.size() >= 3 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeyword(testMetaContact, "Test", true);
        TestMsgHistoryService.assertFalse((String)"Something found by findByKeyword casesensitive search", (!rs.isEmpty() ? 1 : 0) != 0);
        rs = msgHistoryService.findByEndDate(testMetaContact, controlDate2);
        TestMsgHistoryService.assertTrue((String)"Nothing found findByEndDate", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertTrue((String)"Messages too few - findByEndDate", (msgs.size() >= 3 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeywords(testMetaContact, new String[]{"test", "word2"});
        TestMsgHistoryService.assertTrue((String)"Nothing found findByKeywords", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertTrue((String)"Messages too few - findByKeywords", (msgs.size() >= 1 ? 1 : 0) != 0);
        rs = msgHistoryService.findByKeywords(testMetaContact, new String[]{"test1", "word2"});
        TestMsgHistoryService.assertFalse((String)"Something found findByKeywords", (!rs.isEmpty() ? 1 : 0) != 0);
        rs = msgHistoryService.findByPeriod(testMetaContact, controlDate1, controlDate2);
        TestMsgHistoryService.assertFalse((String)"Nothing found findByPeriod", (boolean)rs.isEmpty());
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Messages must be 2", (int)2, (int)msgs.size());
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        rs = msgHistoryService.findByPeriod(testMetaContact, controlDate1, controlDate2, new String[]{"word2"});
        TestMsgHistoryService.assertTrue((String)"Nothing found findByPeriod", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Messages must be 1", (int)1, (int)msgs.size());
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        rs = msgHistoryService.findByStartDate(testMetaContact, controlDate2);
        TestMsgHistoryService.assertTrue((String)"Nothing found findByStartDate", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Messages must be 2", (int)2, (int)msgs.size());
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[4].getContent()));
        rs = msgHistoryService.findLast(testMetaContact, 3);
        TestMsgHistoryService.assertTrue((String)"Nothing found 8", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Messages must be 3", (int)3, (int)msgs.size());
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[4].getContent()));
        rs = msgHistoryService.findFirstMessagesAfter(testMetaContact, controlDate1, 3);
        TestMsgHistoryService.assertTrue((String)"Nothing found 9", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Messages must be 3", (int)3, (int)msgs.size());
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        rs = msgHistoryService.findLastMessagesBefore(testMetaContact, controlDate2, 3);
        TestMsgHistoryService.assertTrue((String)"Nothing found 10", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Messages must be 3", (int)3, (int)msgs.size());
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[0].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        TestMsgHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
    }

    public void specialChars() {
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[5]);
        TestMsgHistoryService.waitWrite(500L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[6]);
        TestMsgHistoryService.waitWrite(500L);
        Collection rs = msgHistoryService.findLast(testMetaContact, 2);
        List<String> msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Sent messages must be available", (int)2, (int)msgs.size());
        TestMsgHistoryService.assertTrue((String)("Message " + messagesToSend[5].getContent() + " not found"), (boolean)msgs.contains(XmlEscapers.xmlContentEscaper().escape(messagesToSend[5].getContent())));
        TestMsgHistoryService.assertTrue((String)("Message " + messagesToSend[6].getContent() + " not found"), (boolean)msgs.contains(messagesToSend[6].getContent()));
    }

    public void insertRecords() {
        if (!(msgHistoryService instanceof MessageHistoryAdvancedService)) {
            return;
        }
        ((MessageHistoryAdvancedService)msgHistoryService).insertMessage("out", null, (Contact)testContact, messagesToSend[1], new Date(controlDate1.getTime() + 50L), false);
        Collection rs = msgHistoryService.findByPeriod(testMetaContact, controlDate1, controlDate2);
        List<String> msgs = this.getMessages(rs);
        TestMsgHistoryService.assertEquals((String)"Messages must be found", (int)3, (int)msgs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitWrite(long timeout) {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private List<String> getMessages(Collection<EventObject> rs) {
        Vector<String> result = new Vector<String>();
        for (EventObject item : rs) {
            if (item instanceof MessageDeliveredEvent) {
                result.add(((MessageDeliveredEvent)item).getSourceMessage().getContent());
                continue;
            }
            if (!(item instanceof MessageReceivedEvent)) continue;
            result.add(((MessageReceivedEvent)item).getSourceMessage().getContent());
        }
        return result;
    }

    private List<String> getChatMessages(Collection<EventObject> rs) {
        Vector<String> result = new Vector<String>();
        for (EventObject item : rs) {
            if (item instanceof ChatRoomMessageDeliveredEvent) {
                result.add(((ChatRoomMessageDeliveredEvent)item).getMessage().getContent());
                continue;
            }
            if (!(item instanceof ChatRoomMessageReceivedEvent)) continue;
            result.add(((ChatRoomMessageReceivedEvent)item).getMessage().getContent());
        }
        return result;
    }
}

