/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.core.ServerLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Properties;
import javax.sip.SipStack;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class SipLogger
implements StackLogger,
ServerLogger {
    private static final Logger logger = Logger.getLogger(SipLogger.class);
    private SipStack sipStack;

    public void logStackTrace() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"JAIN-SIP stack trace", new Throwable());
        }
    }

    public void logStackTrace(int traceLevel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"JAIN-SIP stack trace", new Throwable());
        }
    }

    public int getLineCount() {
        return 0;
    }

    public void logException(Throwable ex) {
        logger.warn((Object)("Exception in the JAIN-SIP stack: " + ex.getMessage()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)"JAIN-SIP exception stack trace is", ex);
        }
    }

    public void logDebug(String message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Debug output from the JAIN-SIP stack: " + message));
        }
    }

    public void logFatalError(String message) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Fatal error from the JAIN-SIP stack: " + message));
        }
    }

    public void logError(String message) {
        logger.error((Object)("Error from the JAIN-SIP stack: " + message));
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public boolean isLoggingEnabled(int logLevel) {
        if (logLevel == 32) {
            return logger.isDebugEnabled();
        }
        if (logLevel == 16) {
            return true;
        }
        return logLevel != 0;
    }

    public void logError(String message, Exception ex) {
        logger.error((Object)("Error from the JAIN-SIP stack: " + message), (Throwable)ex);
    }

    public void logWarning(String string) {
        logger.warn((Object)("Warning from the JAIN-SIP stack" + string));
    }

    public void logInfo(String string) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Info from the JAIN-SIP stack: " + string));
        }
    }

    public void disableLogging() {
    }

    public void enableLogging() {
    }

    public void setBuildTimeStamp(String buildTimeStamp) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("JAIN-SIP RI build " + buildTimeStamp));
        }
    }

    public void setStackProperties(Properties stackProperties) {
    }

    public void closeLogFile() {
    }

    public void logMessage(SIPMessage message, String from, String to, boolean sender, long time) {
        this.logMessage(message, from, to, null, sender, time);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender, long time) {
        try {
            this.logPacket(message, sender);
        }
        catch (Throwable e) {
            logger.error((Object)"Error logging packet", e);
        }
    }

    private void logPacket(SIPMessage message, boolean sender) {
        try {
            int len;
            SIPRequest req;
            byte[] dstAddr;
            int dstPort;
            byte[] srcAddr;
            int srcPort;
            PacketLoggingService packetLogging = SipActivator.getPacketLogging();
            if (packetLogging == null || !packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.SIP) || message.getTopmostVia() == null) {
                return;
            }
            String transport = message.getTopmostVia().getTransport();
            boolean isTransportUDP = transport.equalsIgnoreCase("UDP");
            if (sender) {
                if (!isTransportUDP) {
                    InetSocketAddress localAddress = this.getLocalAddressForDestination(message.getRemoteAddress(), message.getRemotePort(), message.getLocalAddress(), transport);
                    if (localAddress != null) {
                        srcPort = localAddress.getPort();
                        srcAddr = localAddress.getAddress().getAddress();
                    } else {
                        logger.warn((Object)"Could not obtain source address for  packet. Writing source as 0.0.0.0:0");
                        srcPort = 0;
                        srcAddr = new byte[]{0, 0, 0, 0};
                    }
                } else {
                    srcPort = message.getLocalPort();
                    srcAddr = message.getLocalAddress() != null ? message.getLocalAddress().getAddress() : (message.getRemoteAddress() != null ? new byte[message.getRemoteAddress().getAddress().length] : new byte[4]);
                }
                dstPort = message.getRemotePort();
                dstAddr = message.getRemoteAddress() != null ? message.getRemoteAddress().getAddress() : new byte[srcAddr.length];
            } else {
                if (!isTransportUDP) {
                    InetSocketAddress dstAddress = this.getLocalAddressForDestination(message.getRemoteAddress(), message.getRemotePort(), message.getLocalAddress(), transport);
                    dstPort = dstAddress.getPort();
                    dstAddr = dstAddress.getAddress().getAddress();
                } else {
                    dstPort = message.getLocalPort();
                    dstAddr = message.getLocalAddress() != null ? message.getLocalAddress().getAddress() : (message.getRemoteAddress() != null ? new byte[message.getRemoteAddress().getAddress().length] : new byte[4]);
                }
                srcPort = message.getRemotePort();
                srcAddr = message.getRemoteAddress() != null ? message.getRemoteAddress().getAddress() : new byte[dstAddr.length];
            }
            byte[] msg = null;
            if (message instanceof SIPRequest && (req = (SIPRequest)message).getMethod().equals("MESSAGE") && message.getContentTypeHeader() != null && message.getContentTypeHeader().getContentType().equalsIgnoreCase("text") && (len = req.getContentLength().getContentLength()) > 0) {
                SIPRequest newReq = (SIPRequest)req.clone();
                byte[] newContent = new byte[len];
                Arrays.fill(newContent, (byte)46);
                newReq.setMessageContent(newContent);
                msg = newReq.toString().getBytes("UTF-8");
            }
            if (msg == null) {
                msg = message.toString().getBytes("UTF-8");
            }
            packetLogging.logPacket(PacketLoggingService.ProtocolName.SIP, srcAddr, srcPort, dstAddr, dstPort, isTransportUDP ? PacketLoggingService.TransportName.UDP : PacketLoggingService.TransportName.TCP, sender, msg);
        }
        catch (Throwable e) {
            logger.error((Object)"Cannot obtain message body", e);
        }
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        String msgHeader = sender ? "JAIN-SIP sent a message from=\"" : "JAIN-SIP received a message from=\"";
        if (logger.isInfoEnabled()) {
            logger.info((Object)(msgHeader + from + "\" to=\"" + to + "\" (status: " + status + "):\n" + message));
        }
    }

    public void logException(Exception exception) {
        logger.warn((Object)("the following exception occured in JAIN-SIP: " + exception), (Throwable)exception);
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public String getLoggerName() {
        return "Jitsi JAIN SIP logger.";
    }

    public void logTrace(String message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)message);
        }
    }

    public InetSocketAddress getLocalAddressForDestination(InetAddress dst, int dstPort, InetAddress localAddress, String transport) throws IOException {
        if ("TLS".equalsIgnoreCase(transport)) {
            return (InetSocketAddress)((SipStackImpl)this.sipStack).getLocalAddressForTlsDst(dst, dstPort, localAddress);
        }
        return (InetSocketAddress)((SipStackImpl)this.sipStack).getLocalAddressForTcpDst(dst, dstPort, localAddress, 0);
    }
}

