/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.HopImpl;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.sip.SipException;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipApplicationData;
import net.java.sip.communicator.impl.protocol.sip.net.ProxyConnection;
import net.java.sip.communicator.util.Logger;

public class ProxyRouter
implements Router {
    private static final Logger logger = Logger.getLogger(ProxyRouter.class);
    private final SipStack stack;
    private final Map<String, Router> routerCache = new HashMap<String, Router>();
    private Router defaultRouter = null;

    public ProxyRouter(SipStack stack, String defaultRoute) {
        if (stack == null) {
            throw new IllegalArgumentException("stack shouldn't be null!");
        }
        this.stack = stack;
    }

    public Hop getNextHop(Request request) throws SipException {
        return this.getRouterFor(request).getNextHop(request);
    }

    @Deprecated
    public ListIterator getNextHops(Request request) {
        return this.getRouterFor(request).getNextHops(request);
    }

    public Hop getOutboundProxy() {
        logger.fatal((Object)"If you see this then please please describe your SIP setup and send the following stack trace todev@jitsi.org", (Throwable)new Exception());
        return null;
    }

    private Router getRouterFor(Request request) {
        Object service = SipApplicationData.getApplicationData(request, "service");
        if (service instanceof ProtocolProviderServiceSipImpl) {
            ProtocolProviderServiceSipImpl sipProvider = (ProtocolProviderServiceSipImpl)((Object)service);
            final ProxyConnection connection = sipProvider.getConnection();
            final String proxy = connection.getOutboundProxyString();
            logger.trace((Object)("Router for proxy: " + proxy));
            boolean forceLooseRouting = sipProvider.getAccountID().getAccountPropertyBoolean((Object)"FORCE_PROXY_BYPASS", false);
            if (proxy == null || forceLooseRouting) {
                logger.info((Object)"Returning default SIP router, P2P/loose routing");
                return this.getDefaultRouter();
            }
            Object router = this.routerCache.get(proxy);
            if (router == null) {
                router = new DefaultRouter(this.stack, proxy){

                    public Hop getNextHop(Request request) throws SipException {
                        logger.info((Object)("Outbound proxy mode, using proxy " + proxy + " as hop instead of an address resolved by the SIP router"));
                        InetSocketAddress sa = connection.getAddress();
                        return new HopImpl(sa.getAddress().getHostAddress(), sa.getPort(), connection.getTransport());
                    }
                };
                this.routerCache.put(proxy, (Router)router);
            }
            return router;
        }
        ToHeader to = (ToHeader)request.getHeader("To");
        if (to.getTag() == null) {
            logger.error((Object)"unable to identify the service which created this out-of-dialog request");
        }
        logger.info((Object)"Returning default router");
        return this.getDefaultRouter();
    }

    private Router getDefaultRouter() {
        if (this.defaultRouter == null) {
            this.defaultRouter = new DefaultRouter(this.stack, null);
        }
        return this.defaultRouter;
    }
}

