/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.gdata.client.Service;
import com.google.gdata.util.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class VersionRegistry {
    private static VersionRegistry versionRegistry;
    private ThreadLocal<List<Version>> threadVersions = new ThreadLocal();
    private List<Version> defaultVersions = new ArrayList<Version>();

    public static synchronized VersionRegistry ensureRegistry() {
        if (versionRegistry == null) {
            versionRegistry = new VersionRegistry();
        }
        return versionRegistry;
    }

    @VisibleForTesting
    static void reset() {
        versionRegistry = null;
    }

    public static final VersionRegistry get() {
        if (versionRegistry == null) {
            throw new IllegalStateException("Uninitialized version registry");
        }
        return versionRegistry;
    }

    public static Version getVersionFromProperty(Class<? extends Service> serviceClass) {
        String propertyName = serviceClass.getName() + ".version";
        String versionProperty = System.getProperty(propertyName);
        if (versionProperty == null) {
            return null;
        }
        try {
            return new Version(serviceClass, versionProperty, new Version[0]);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalStateException("Invalid version property value: " + propertyName, iae);
        }
    }

    @VisibleForTesting
    static void mergeVersions(List<Version> target, List<Version> source) {
        for (Version checkVersion : source) {
            Version currentVersion = Version.findServiceVersion(target, checkVersion.getServiceClass());
            if (currentVersion == null) continue;
            target.remove(currentVersion);
        }
        target.addAll(source);
    }

    @VisibleForTesting
    static void mergeVersions(List<Version> target, Version source) {
        VersionRegistry.mergeVersions(target, Arrays.asList(source));
    }

    public List<Version> getDefaultVersions() {
        return this.defaultVersions;
    }

    public void addDefaultVersion(Version newDefault, boolean includeImplied) {
        ArrayList<Version> newDefaults = new ArrayList<Version>(this.defaultVersions);
        if (includeImplied) {
            VersionRegistry.mergeVersions(newDefaults, newDefault.getImpliedVersions());
        } else {
            VersionRegistry.mergeVersions(newDefaults, newDefault);
        }
        this.defaultVersions = Collections.unmodifiableList(newDefaults);
    }

    public void setThreadVersion(Version version) {
        this.threadVersions.set(Collections.unmodifiableList(version.getImpliedVersions()));
    }

    public List<Version> getThreadVersions() {
        return this.threadVersions.get();
    }

    public void resetThreadVersion() {
        if (this.threadVersions != null) {
            this.threadVersions.remove();
        }
    }

    @VisibleForTesting
    List<Version> getVersions() {
        List<Version> defaultList = this.getDefaultVersions();
        List<Version> threadList = this.getThreadVersions();
        if (threadList == null) {
            return defaultList;
        }
        ArrayList<Version> combinedList = new ArrayList<Version>(defaultList.size() + threadList.size());
        combinedList.addAll(defaultList);
        VersionRegistry.mergeVersions(combinedList, threadList);
        return combinedList;
    }

    public Version getVersion(Class<? extends Service> serviceClass) {
        Version v = null;
        List<Version> threadList = this.getThreadVersions();
        if (threadList != null) {
            v = Version.findServiceVersion(threadList, serviceClass);
        }
        if (v == null && (v = Version.findServiceVersion(this.getDefaultVersions(), serviceClass)) == null) {
            throw new IllegalStateException("Attempt to access version information for unversioned service:" + serviceClass);
        }
        return v;
    }

    @VisibleForTesting
    public synchronized void reset(List<Version> initialDefaults) {
        this.threadVersions = new ThreadLocal();
        this.defaultVersions = initialDefaults != null ? new ArrayList<Version>(initialDefaults) : new ArrayList<Version>();
    }
}

