/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.data.XmlEventSource;
import com.google.gdata.util.LogUtils;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class EventSourceParser
extends XmlParser {
    private static final Logger LOGGER = Logger.getLogger(EventSourceParser.class.getName());

    public EventSourceParser(XmlParser.ElementHandler rootHandler, String rootNamespace, String rootElementName) {
        this.rootHandler = rootHandler;
        this.rootNamespace = rootNamespace;
        this.rootElementName = rootElementName;
    }

    public void parse(XmlEventSource source) throws ParseException, IOException {
        try {
            source.parse(this);
        }
        catch (SAXException e) {
            Exception rootException = e.getException();
            if (rootException instanceof ParseException) {
                this.throwParseException((ParseException)rootException);
            }
            if (rootException instanceof IOException) {
                LogUtils.logException(LOGGER, Level.WARNING, null, e);
                throw (IOException)rootException;
            }
            LogUtils.logException(LOGGER, Level.FINE, null, e);
            throw new ParseException(e);
        }
    }
}

