/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import junit.framework.Assert;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class JmDNSTest {
    private ServiceTypeListener typeListenerMock;
    private ServiceListener serviceListenerMock;
    private ServiceInfo service;
    private static final String serviceKey = "srvname";

    @Before
    public void setup() {
        Object object;
        Object object2;
        boolean bl = false;
        if (bl) {
            object2 = new ConsoleHandler();
            ((Handler)object2).setLevel(Level.FINEST);
            object = LogManager.getLogManager().getLoggerNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Logger logger = Logger.getLogger(string);
                logger.addHandler((Handler)object2);
                logger.setLevel(Level.FINEST);
            }
        }
        object2 = "Test hypothetical web server";
        object = new HashMap<String, byte[]>();
        object.put(serviceKey, ((String)object2).getBytes());
        this.service = ServiceInfo.create("_html._tcp.local.", "apache-someuniqueid", 80, 0, 0, true, object);
        this.typeListenerMock = (ServiceTypeListener)EasyMock.createMock(ServiceTypeListener.class);
        this.serviceListenerMock = (ServiceListener)EasyMock.createNiceMock((String)"ServiceListener", ServiceListener.class);
    }

    @Test
    public void testCreate() throws IOException {
        System.out.println("Unit Test: testCreate()");
        JmDNS jmDNS = JmDNS.create();
        jmDNS.close();
    }

    @Test
    public void testCreateINet() throws IOException {
        System.out.println("Unit Test: testCreateINet()");
        JmDNS jmDNS = JmDNS.create(InetAddress.getLocalHost());
        jmDNS.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterService() throws IOException {
        System.out.println("Unit Test: testRegisterService()");
        JmDNS jmDNS = null;
        try {
            jmDNS = JmDNS.create();
            jmDNS.registerService(this.service);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryMyService() throws IOException {
        System.out.println("Unit Test: testQueryMyService()");
        JmDNS jmDNS = null;
        try {
            jmDNS = JmDNS.create();
            jmDNS.registerService(this.service);
            ServiceInfo serviceInfo = jmDNS.getServiceInfo(this.service.getType(), this.service.getName());
            Assert.assertEquals((Object)this.service, (Object)serviceInfo);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListMyService() throws IOException {
        System.out.println("Unit Test: testListMyService()");
        JmDNS jmDNS = null;
        try {
            jmDNS = JmDNS.create();
            jmDNS.registerService(this.service);
            ServiceInfo[] serviceInfoArray = jmDNS.list(this.service.getType());
            Assert.assertEquals((String)"We should see the service we just registered: ", (int)1, (int)serviceInfoArray.length);
            Assert.assertEquals((Object)this.service, (Object)serviceInfoArray[0]);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenForMyService() throws IOException {
        System.out.println("Unit Test: testListenForMyService()");
        JmDNS jmDNS = null;
        try {
            Capture capture = new Capture();
            Capture capture2 = new Capture();
            this.serviceListenerMock.serviceAdded((ServiceEvent)EasyMock.capture((Capture)capture));
            this.serviceListenerMock.serviceResolved((ServiceEvent)EasyMock.capture((Capture)capture2));
            EasyMock.replay((Object[])new Object[]{this.serviceListenerMock});
            jmDNS = JmDNS.create();
            jmDNS.addServiceListener(this.service.getType(), this.serviceListenerMock);
            jmDNS.registerService(this.service);
            Assert.assertTrue((String)"We did not get the service added event.", (boolean)capture.hasCaptured());
            ServiceInfo serviceInfo = ((ServiceEvent)capture.getValue()).getInfo();
            Assert.assertEquals((String)"We did not get the right name for the added service:", (String)this.service.getName(), (String)serviceInfo.getName());
            Assert.assertEquals((String)"We did not get the right type for the added service:", (String)this.service.getType(), (String)serviceInfo.getType());
            Assert.assertEquals((String)"We did not get the right fully qualified name for the added service:", (String)this.service.getQualifiedName(), (String)serviceInfo.getQualifiedName());
            jmDNS.requestServiceInfo(this.service.getType(), this.service.getName());
            Assert.assertTrue((String)"We did not get the service resolved event.", (boolean)capture2.hasCaptured());
            EasyMock.verify((Object[])new Object[]{this.serviceListenerMock});
            ServiceInfo serviceInfo2 = ((ServiceEvent)capture2.getValue()).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)serviceInfo2);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenForMyServiceAndList() throws IOException {
        System.out.println("Unit Test: testListenForMyServiceAndList()");
        JmDNS jmDNS = null;
        try {
            Capture capture = new Capture();
            Capture capture2 = new Capture();
            this.serviceListenerMock.serviceAdded((ServiceEvent)EasyMock.capture((Capture)capture));
            this.serviceListenerMock.serviceResolved((ServiceEvent)EasyMock.capture((Capture)capture2));
            EasyMock.replay((Object[])new Object[]{this.serviceListenerMock});
            jmDNS = JmDNS.create();
            jmDNS.addServiceListener(this.service.getType(), this.serviceListenerMock);
            jmDNS.registerService(this.service);
            Assert.assertTrue((String)"We did not get the service added event.", (boolean)capture.hasCaptured());
            ServiceInfo serviceInfo = ((ServiceEvent)capture.getValue()).getInfo();
            Assert.assertEquals((String)"We did not get the right name for the resolved service:", (String)this.service.getName(), (String)serviceInfo.getName());
            Assert.assertEquals((String)"We did not get the right type for the resolved service:", (String)this.service.getType(), (String)serviceInfo.getType());
            ServiceInfo[] serviceInfoArray = jmDNS.list(serviceInfo.getType());
            Assert.assertEquals((String)"We did not get the expected number of services: ", (int)1, (int)serviceInfoArray.length);
            Assert.assertEquals((String)"The service returned was not the one expected", (Object)this.service, (Object)serviceInfoArray[0]);
            Assert.assertTrue((String)"We did not get the service resolved event.", (boolean)capture2.hasCaptured());
            EasyMock.verify((Object[])new Object[]{this.serviceListenerMock});
            ServiceInfo serviceInfo2 = ((ServiceEvent)capture2.getValue()).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)serviceInfo2);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenForServiceOnOtherRegistry() throws IOException {
        System.out.println("Unit Test: testListenForServiceOnOtherRegistry()");
        JmDNS jmDNS = null;
        JmDNS jmDNS2 = null;
        try {
            Capture capture = new Capture();
            Capture capture2 = new Capture();
            this.serviceListenerMock.serviceAdded((ServiceEvent)EasyMock.capture((Capture)capture));
            this.serviceListenerMock.serviceResolved((ServiceEvent)EasyMock.capture((Capture)capture2));
            EasyMock.replay((Object[])new Object[]{this.serviceListenerMock});
            jmDNS = JmDNS.create();
            jmDNS.addServiceListener(this.service.getType(), this.serviceListenerMock);
            jmDNS2 = JmDNS.create();
            jmDNS2.registerService(this.service);
            Assert.assertTrue((String)"We did not get the service added event.", (boolean)capture.hasCaptured());
            ServiceInfo serviceInfo = ((ServiceEvent)capture.getValue()).getInfo();
            Assert.assertEquals((String)"We did not get the right name for the resolved service:", (String)this.service.getName(), (String)serviceInfo.getName());
            Assert.assertEquals((String)"We did not get the right type for the resolved service:", (String)this.service.getType(), (String)serviceInfo.getType());
            Assert.assertTrue((String)"We did not get the service resolved event.", (boolean)capture2.hasCaptured());
            EasyMock.verify((Object[])new Object[]{this.serviceListenerMock});
            ServiceInfo serviceInfo2 = ((ServiceEvent)capture2.getValue()).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)serviceInfo2);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
            if (jmDNS2 != null) {
                jmDNS2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWaitAndQueryForServiceOnOtherRegistry() throws IOException {
        System.out.println("Unit Test: testWaitAndQueryForServiceOnOtherRegistry()");
        JmDNS jmDNS = null;
        JmDNS jmDNS2 = null;
        try {
            jmDNS2 = JmDNS.create();
            jmDNS = JmDNS.create();
            jmDNS.registerService(this.service);
            ServiceInfo serviceInfo = jmDNS2.getServiceInfo(this.service.getType(), this.service.getName());
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)serviceInfo);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
            if (jmDNS2 != null) {
                jmDNS2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterAndListServiceOnOtherRegistry() throws IOException, InterruptedException {
        System.out.println("Unit Test: testRegisterAndListServiceOnOtherRegistry()");
        JmDNS jmDNS = null;
        JmDNS jmDNS2 = null;
        try {
            jmDNS = JmDNS.create("Registry");
            jmDNS.registerService(this.service);
            jmDNS2 = JmDNS.create("Listener");
            Thread.sleep(6000L);
            ServiceInfo[] serviceInfoArray = jmDNS2.list(this.service.getType());
            Assert.assertEquals((String)"Did not get the expected services listed:", (int)1, (int)serviceInfoArray.length);
            Assert.assertEquals((String)"Did not get the expected service type:", (String)this.service.getType(), (String)serviceInfoArray[0].getType());
            Assert.assertEquals((String)"Did not get the expected service name:", (String)this.service.getName(), (String)serviceInfoArray[0].getName());
            Assert.assertEquals((String)"Did not get the expected service fully qualified name:", (String)this.service.getQualifiedName(), (String)serviceInfoArray[0].getQualifiedName());
            jmDNS2.getServiceInfo(this.service.getType(), this.service.getName());
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)serviceInfoArray[0]);
            jmDNS.close();
            jmDNS = null;
            serviceInfoArray = jmDNS2.list(this.service.getType());
            Assert.assertEquals((String)"The service was not cancelled after the close:", (int)0, (int)serviceInfoArray.length);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
            if (jmDNS2 != null) {
                jmDNS2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoMulticastPortsAtOnce() throws UnknownHostException, IOException {
        System.out.println("Unit Test: testTwoMulticastPortsAtOnce()");
        DatagramSocket datagramSocket = null;
        DatagramSocket datagramSocket2 = null;
        try {
            String string = "ping";
            String string2 = "pong";
            InetAddress inetAddress = InetAddress.getByName("224.0.0.252");
            datagramSocket = new MulticastSocket(8053);
            datagramSocket2 = new MulticastSocket(8053);
            ((MulticastSocket)datagramSocket).joinGroup(inetAddress);
            ((MulticastSocket)datagramSocket2).joinGroup(inetAddress);
            DatagramPacket datagramPacket = new DatagramPacket(string.getBytes("UTF-8"), string.length(), inetAddress, 8053);
            DatagramPacket datagramPacket2 = new DatagramPacket(string.getBytes("UTF-8"), string.length(), inetAddress, 8053);
            DatagramPacket datagramPacket3 = new DatagramPacket(string.getBytes("UTF-8"), string.length(), inetAddress, 8053);
            Receive receive = new Receive((MulticastSocket)datagramSocket2, datagramPacket3);
            receive.start();
            Receive receive2 = new Receive((MulticastSocket)datagramSocket, datagramPacket3);
            receive2.start();
            datagramSocket.send(datagramPacket);
            if (receive.waitForReceive()) {
                Assert.fail((String)"We did not receive the data in the second socket");
            }
            String string3 = new String(datagramPacket3.getData(), "UTF-8");
            Assert.assertEquals((String)"Expected the second socket to recieve the same message the first socket sent", (String)string, (String)string3);
            if (receive.waitForReceive()) {
                Assert.fail((String)"We did not receive the data in the first socket");
            }
            datagramPacket = new DatagramPacket(string2.getBytes("UTF-8"), string2.length(), inetAddress, 8053);
            datagramPacket2 = new DatagramPacket(string2.getBytes("UTF-8"), string2.length(), inetAddress, 8053);
            receive2 = new Receive((MulticastSocket)datagramSocket, datagramPacket3);
            receive2.start();
            datagramSocket2.send(datagramPacket);
            if (receive2.waitForReceive()) {
                Assert.fail((String)"We did not receive the data in the first socket");
            }
            String string4 = new String(datagramPacket2.getData(), "UTF-8");
            Assert.assertEquals((String)"Expected the first socket to recieve the same message the second socket sent", (String)string2, (String)string4);
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (datagramSocket2 != null) {
                datagramSocket2.close();
            }
        }
    }

    public static final class Receive
    extends Thread {
        MulticastSocket _socket;
        DatagramPacket _in;

        public Receive(MulticastSocket multicastSocket, DatagramPacket datagramPacket) {
            super("Test Receive Multicast");
            this._socket = multicastSocket;
            this._in = datagramPacket;
        }

        public void run() {
            try {
                this._socket.receive(this._in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean waitForReceive() {
            try {
                this.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.isAlive();
        }
    }
}

