/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globalshortcut;

import net.java.sip.communicator.impl.globalshortcut.NativeKeyboardHookDelegate;
import net.java.sip.communicator.util.Logger;

public class NativeKeyboardHook {
    private static final Logger logger = Logger.getLogger(NativeKeyboardHook.class);
    private boolean isStarted = false;
    private static long ptr = 0L;
    private boolean specialKeydetection = false;

    public synchronized void start() {
        if (!this.isStarted && ptr != 0L) {
            this.isStarted = true;
            NativeKeyboardHook.start(ptr);
        }
    }

    public synchronized void stop() {
        if (this.isStarted && ptr != 0L) {
            this.isStarted = false;
            NativeKeyboardHook.stop(ptr);
        }
    }

    public synchronized void setDelegate(NativeKeyboardHookDelegate delegate) {
        if (ptr != 0L) {
            NativeKeyboardHook.setDelegate(ptr, delegate);
        }
    }

    public synchronized boolean registerShortcut(int keycode, int modifiers, boolean isOnKeyRelease) {
        if (ptr != 0L) {
            return NativeKeyboardHook.registerShortcut(ptr, keycode, modifiers, isOnKeyRelease);
        }
        return false;
    }

    public synchronized void unregisterShortcut(int keycode, int modifiers) {
        if (ptr != 0L) {
            NativeKeyboardHook.unregisterShortcut(ptr, keycode, modifiers);
        }
    }

    public synchronized boolean registerSpecial(int keycode, boolean isOnKeyRelease) {
        if (ptr != 0L) {
            return NativeKeyboardHook.registerSpecial(ptr, keycode, isOnKeyRelease);
        }
        return false;
    }

    public synchronized void unregisterSpecial(int keycode) {
        if (ptr != 0L) {
            NativeKeyboardHook.unregisterSpecial(ptr, keycode);
        }
    }

    public synchronized void detectSpecialKeyPress(boolean enable) {
        if (ptr != 0L) {
            NativeKeyboardHook.detectSpecialKeyPress(ptr, enable);
            this.specialKeydetection = enable;
        }
    }

    public boolean isSpecialKeyDetection() {
        return this.specialKeydetection;
    }

    private static native long init();

    private static native void start(long var0);

    private static native void stop(long var0);

    private static native void setDelegate(long var0, NativeKeyboardHookDelegate var2);

    private static native boolean registerShortcut(long var0, int var2, int var3, boolean var4);

    private static native void unregisterShortcut(long var0, int var2, int var3);

    private static native boolean registerSpecial(long var0, int var2, boolean var3);

    private static native void unregisterSpecial(long var0, int var2);

    private static native void detectSpecialKeyPress(long var0, boolean var2);

    static {
        try {
            System.loadLibrary("globalshortcut");
            ptr = NativeKeyboardHook.init();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to load globalshortcut", (Throwable)e);
            ptr = 0L;
        }
    }
}

