/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.AbstractRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.snaccmd.icbm.SendIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.TlvTools;

public class SendRvIcbm
extends AbstractRvIcbm
implements SendIcbm {
    private final String sn;

    protected SendRvIcbm(SnacPacket packet) {
        super(6, packet);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock channelData = this.getChannelData();
        StringBlock snInfo = OscarTools.readScreenname(channelData);
        this.sn = snInfo.getString();
        ByteBlock tlvBlock = channelData.subBlock(snInfo.getTotalSize());
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.processRvTlvs(chain);
    }

    public SendRvIcbm(String sn, long icbmMessageId, int status, long rvSessionId, CapabilityBlock cap, LiveWritable rvDataWriter) {
        super(6, icbmMessageId, status, rvSessionId, cap, rvDataWriter);
        DefensiveTools.checkNull(sn, "sn");
        this.sn = sn;
    }

    public SendRvIcbm(String sn, long icbmMessageId, long rvSessionId, RvCommand command) {
        super(6, icbmMessageId, rvSessionId, command);
        DefensiveTools.checkNull(sn, "sn");
        this.sn = sn;
    }

    public final String getScreenname() {
        return this.sn;
    }

    protected final void writeChannelData(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.sn);
        this.writeRvTlvs(out);
    }

    public String toString() {
        return "SendRvIcbm to " + this.sn + ": <" + this.getCapability() + ">, status=" + this.getRvStatus() + ", sessid=" + this.getRvSessionId() + " -- " + super.toString();
    }
}

