/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.httpauth;

import com.lti.utils.StringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.utility.LoggerSingleton;

public class DataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    private URLConnection conn;
    private boolean connected = false;
    private String contentTypeStr;
    private ContentDescriptor contentType;
    protected URLSourceStream[] sources;

    public DataSource() {
    }

    public DataSource(URL url) {
        this.setLocator(new MediaLocator(url));
    }

    @Override
    public void connect() throws IOException {
        String remainder = this.getLocator().getRemainder();
        int atIndex = remainder.indexOf(64);
        if (atIndex < 0) {
            throw new IOException("Invalid httpauth url: expected: @");
        }
        int colonIndex = remainder.indexOf(58);
        if (colonIndex < 0 || colonIndex > atIndex) {
            throw new IOException("Invalid httpaut url: expected: :");
        }
        String user = remainder.substring(0, colonIndex);
        String pass = remainder.substring(colonIndex + 1, atIndex);
        String realUrlStr = "http:" + this.getLocator().getRemainder().substring(atIndex + 1);
        this.conn = new URL(realUrlStr).openConnection();
        if (this.conn instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)this.conn;
            if (user != null && !user.equals("")) {
                huc.setRequestProperty("Authorization", "Basic " + StringUtils.byteArrayToBase64String((user + ":" + pass).getBytes()));
            }
            huc.connect();
            int code = huc.getResponseCode();
            if (code < 200 || code >= 300) {
                huc.disconnect();
                throw new IOException("HTTP response code: " + code);
            }
            this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.stripTrailer(this.conn.getContentType()));
        } else {
            this.conn.connect();
            this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.conn.getContentType());
        }
        this.contentType = new ContentDescriptor(this.contentTypeStr);
        this.sources = new URLSourceStream[1];
        this.sources[0] = new URLSourceStream();
        this.connected = true;
    }

    @Override
    public javax.media.protocol.DataSource createClone() {
        DataSource d;
        try {
            d = new DataSource(this.getLocator().getURL());
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        if (this.connected) {
            try {
                d.connect();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                return null;
            }
        }
        return d;
    }

    @Override
    public void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.conn != null && this.conn instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)this.conn;
            huc.disconnect();
        }
        this.connected = false;
    }

    @Override
    public String getContentType() {
        return this.contentTypeStr;
    }

    @Override
    public Object getControl(String controlName) {
        return null;
    }

    @Override
    public Object[] getControls() {
        return new Object[0];
    }

    @Override
    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    @Override
    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void stop() throws IOException {
    }

    private String stripTrailer(String contentType) {
        int index = contentType.indexOf(";");
        if (index < 0) {
            return contentType;
        }
        String result = contentType.substring(0, index);
        return result;
    }

    class URLSourceStream
    implements PullSourceStream {
        private boolean endOfStream = false;

        URLSourceStream() {
        }

        @Override
        public boolean endOfStream() {
            return this.endOfStream;
        }

        @Override
        public ContentDescriptor getContentDescriptor() {
            return DataSource.this.contentType;
        }

        @Override
        public long getContentLength() {
            return DataSource.this.conn.getContentLength();
        }

        @Override
        public Object getControl(String controlType) {
            return null;
        }

        @Override
        public Object[] getControls() {
            return new Object[0];
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int result = DataSource.this.conn.getInputStream().read(buffer, offset, length);
            if (result == -1) {
                this.endOfStream = true;
            }
            return result;
        }

        @Override
        public boolean willReadBlock() {
            try {
                return DataSource.this.conn.getInputStream().available() <= 0;
            }
            catch (IOException e) {
                return true;
            }
        }
    }
}

