/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.domain.messages;

import com.ircclouds.irc.api.domain.IRCServer;
import com.ircclouds.irc.api.domain.messages.interfaces.IHasNumericCode;
import com.ircclouds.irc.api.domain.messages.interfaces.IHasText;
import com.ircclouds.irc.api.domain.messages.interfaces.IServerMessage;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ServerNumericMessage
implements IServerMessage,
IHasText,
IHasNumericCode {
    private static final NumberFormat FORMATTER = new DecimalFormat("000");
    private int numericCode;
    private String text;
    private IRCServer server;
    private String target;

    public ServerNumericMessage(Integer aNumericCode, String aTarget, String aText, IRCServer aServer) {
        this.numericCode = aNumericCode;
        this.target = aTarget;
        this.text = aText;
        this.server = aServer;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Integer getNumericCode() {
        return this.numericCode;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public IRCServer getSource() {
        return this.server;
    }

    @Override
    public String asRaw() {
        return new StringBuffer().append(":").append(this.server.getHostname()).append(" ").append(FORMATTER.format(this.numericCode)).append(" ").append(this.target).append(" ").append(this.text).toString();
    }
}

