/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.DTMFReceivedEvent;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.DynamicPayloadTypeRegistry;
import net.java.sip.communicator.service.protocol.media.DynamicRTPExtensionsRegistry;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallConference;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import net.java.sip.communicator.service.protocol.media.SrtpControls;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.DTMFTone;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.CsrcAudioLevelListener;
import org.jitsi.service.neomedia.event.DTMFListener;
import org.jitsi.service.neomedia.event.DTMFToneEvent;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.event.SrtpListener;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;
import org.jitsi.util.event.VideoNotifierSupport;

public class MediaHandler
extends PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(MediaHandler.class);
    private AudioMediaStream audioStream;
    private final CsrcAudioLevelListener csrcAudioLevelListener = new CsrcAudioLevelListener(){

        public void audioLevelsReceived(long[] audioLevels) {
            MediaHandler.this.audioLevelsReceived(audioLevels);
        }
    };
    private final Object csrcAudioLevelListenerLock = new Object();
    private List<CsrcAudioLevelListener> csrcAudioLevelListeners = Collections.emptyList();
    private KeyFrameControl keyFrameControl;
    private final KeyFrameControl.KeyFrameRequester keyFrameRequester = new KeyFrameControl.KeyFrameRequester(){

        public boolean requestKeyFrame() {
            return MediaHandler.this.requestKeyFrame();
        }
    };
    private final List<KeyFrameControl.KeyFrameRequester> keyFrameRequesters = new LinkedList<KeyFrameControl.KeyFrameRequester>();
    private final long[] localSSRCs;
    private final SimpleAudioLevelListener localUserAudioLevelListener = new SimpleAudioLevelListener(){

        public void audioLevelChanged(int level) {
            MediaHandler.this.audioLevelChanged(MediaHandler.this.localUserAudioLevelListenerLock, MediaHandler.this.localUserAudioLevelListeners, level);
        }
    };
    private final Object localUserAudioLevelListenerLock = new Object();
    private List<SimpleAudioLevelListener> localUserAudioLevelListeners = Collections.emptyList();
    private final long[] remoteSSRCs;
    private final SrtpControls srtpControls = new SrtpControls();
    private final SrtpListener srtpListener = new SrtpListener(){

        public void securityMessageReceived(String message, String i18nMessage, int severity) {
            for (SrtpListener listener : MediaHandler.this.getSrtpListeners()) {
                listener.securityMessageReceived(message, i18nMessage, severity);
            }
        }

        public void securityNegotiationStarted(MediaType mediaType, SrtpControl sender) {
            for (SrtpListener listener : MediaHandler.this.getSrtpListeners()) {
                listener.securityNegotiationStarted(mediaType, sender);
            }
        }

        public void securityTimeout(MediaType mediaType) {
            for (SrtpListener listener : MediaHandler.this.getSrtpListeners()) {
                listener.securityTimeout(mediaType);
            }
        }

        public void securityTurnedOff(MediaType mediaType) {
            for (SrtpListener listener : MediaHandler.this.getSrtpListeners()) {
                listener.securityTurnedOff(mediaType);
            }
        }

        public void securityTurnedOn(MediaType mediaType, String cipher, SrtpControl sender) {
            for (SrtpListener listener : MediaHandler.this.getSrtpListeners()) {
                listener.securityTurnedOn(mediaType, cipher, sender);
            }
        }
    };
    private final List<SrtpListener> srtpListeners = new LinkedList<SrtpListener>();
    private final Set<net.java.sip.communicator.service.protocol.event.DTMFListener> dtmfListeners = new HashSet<net.java.sip.communicator.service.protocol.event.DTMFListener>();
    private final MyDTMFListener dtmfListener = new MyDTMFListener();
    private final SimpleAudioLevelListener streamAudioLevelListener = new SimpleAudioLevelListener(){

        public void audioLevelChanged(int level) {
            MediaHandler.this.audioLevelChanged(MediaHandler.this.streamAudioLevelListenerLock, MediaHandler.this.streamAudioLevelListeners, level);
        }
    };
    private final Object streamAudioLevelListenerLock = new Object();
    private List<SimpleAudioLevelListener> streamAudioLevelListeners = Collections.emptyList();
    private final PropertyChangeListener streamPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("localSSRCAvailable".equals(propertyName)) {
                Object source = evt.getSource();
                if (source == MediaHandler.this.audioStream) {
                    MediaHandler.this.setLocalSSRC(MediaType.AUDIO, MediaHandler.this.audioStream.getLocalSourceID());
                } else if (source == MediaHandler.this.videoStream) {
                    MediaHandler.this.setLocalSSRC(MediaType.VIDEO, MediaHandler.this.videoStream.getLocalSourceID());
                }
            } else if ("remoteSSRCAvailable".equals(propertyName)) {
                Object source = evt.getSource();
                if (source == MediaHandler.this.audioStream) {
                    MediaHandler.this.setRemoteSSRC(MediaType.AUDIO, MediaHandler.this.audioStream.getRemoteSourceID());
                } else if (source == MediaHandler.this.videoStream) {
                    MediaHandler.this.setRemoteSSRC(MediaType.VIDEO, MediaHandler.this.videoStream.getRemoteSourceID());
                }
            }
        }
    };
    private final int[] streamReferenceCounts;
    private final VideoNotifierSupport videoNotifierSupport = new VideoNotifierSupport((Object)this, true);
    private VideoMediaStream videoStream;
    private final VideoListener videoStreamVideoListener = new VideoListener(){

        public void videoAdded(VideoEvent event) {
            VideoEvent clone = event.clone((Object)MediaHandler.this);
            MediaHandler.this.fireVideoEvent(clone);
            if (clone.isConsumed()) {
                event.consume();
            }
        }

        public void videoRemoved(VideoEvent event) {
            this.videoAdded(event);
        }

        public void videoUpdate(VideoEvent event) {
            this.videoAdded(event);
        }
    };

    public MediaHandler() {
        int mediaTypeValueCount = MediaType.values().length;
        this.localSSRCs = new long[mediaTypeValueCount];
        Arrays.fill(this.localSSRCs, -1L);
        this.remoteSSRCs = new long[mediaTypeValueCount];
        Arrays.fill(this.remoteSSRCs, -1L);
        this.streamReferenceCounts = new int[mediaTypeValueCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCsrcAudioLevelListener(CsrcAudioLevelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.csrcAudioLevelListenerLock;
        synchronized (object) {
            if (!this.csrcAudioLevelListeners.contains(listener)) {
                AudioMediaStream audioStream;
                this.csrcAudioLevelListeners = new ArrayList<CsrcAudioLevelListener>(this.csrcAudioLevelListeners);
                if (this.csrcAudioLevelListeners.add(listener) && this.csrcAudioLevelListeners.size() == 1 && (audioStream = this.audioStream) != null) {
                    audioStream.setCsrcAudioLevelListener(this.csrcAudioLevelListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addKeyFrameRequester(int index, KeyFrameControl.KeyFrameRequester keyFrameRequester) {
        if (keyFrameRequester == null) {
            throw new NullPointerException("keyFrameRequester");
        }
        List<KeyFrameControl.KeyFrameRequester> list = this.keyFrameRequesters;
        synchronized (list) {
            if (this.keyFrameRequesters.contains(keyFrameRequester)) {
                return false;
            }
            this.keyFrameRequesters.add(index == -1 ? this.keyFrameRequesters.size() : index, keyFrameRequester);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLocalUserAudioLevelListener(SimpleAudioLevelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.localUserAudioLevelListenerLock;
        synchronized (object) {
            if (!this.localUserAudioLevelListeners.contains(listener)) {
                AudioMediaStream audioStream;
                this.localUserAudioLevelListeners = new ArrayList<SimpleAudioLevelListener>(this.localUserAudioLevelListeners);
                if (this.localUserAudioLevelListeners.add(listener) && this.localUserAudioLevelListeners.size() == 1 && (audioStream = this.audioStream) != null) {
                    audioStream.setLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSrtpListener(SrtpListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<SrtpListener> list = this.srtpListeners;
        synchronized (list) {
            if (!this.srtpListeners.contains(listener)) {
                this.srtpListeners.add(listener);
            }
        }
    }

    void addDtmfListener(net.java.sip.communicator.service.protocol.event.DTMFListener listener) {
        if (listener != null) {
            this.dtmfListeners.add(listener);
        }
    }

    void removeDtmfListener(net.java.sip.communicator.service.protocol.event.DTMFListener listener) {
        this.dtmfListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamAudioLevelListener(SimpleAudioLevelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.streamAudioLevelListenerLock;
        synchronized (object) {
            if (!this.streamAudioLevelListeners.contains(listener)) {
                AudioMediaStream audioStream;
                this.streamAudioLevelListeners = new ArrayList<SimpleAudioLevelListener>(this.streamAudioLevelListeners);
                if (this.streamAudioLevelListeners.add(listener) && this.streamAudioLevelListeners.size() == 1 && (audioStream = this.audioStream) != null) {
                    audioStream.setStreamAudioLevelListener(this.streamAudioLevelListener);
                }
            }
        }
    }

    void addVideoListener(VideoListener listener) {
        this.videoNotifierSupport.addVideoListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void audioLevelChanged(Object lock, List<SimpleAudioLevelListener> listeners, int level) {
        List<SimpleAudioLevelListener> ls;
        Object object = lock;
        synchronized (object) {
            if (listeners.isEmpty()) {
                return;
            }
            ls = listeners;
        }
        int count = ls.size();
        for (int i = 0; i < count; ++i) {
            ls.get(i).audioLevelChanged(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void audioLevelsReceived(long[] audioLevels) {
        List<CsrcAudioLevelListener> listeners;
        Object object = this.csrcAudioLevelListenerLock;
        synchronized (object) {
            if (this.csrcAudioLevelListeners.isEmpty()) {
                return;
            }
            listeners = this.csrcAudioLevelListeners;
        }
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            listeners.get(i).audioLevelsReceived(audioLevels);
        }
    }

    protected void closeStream(CallPeerMediaHandler<?> callPeerMediaHandler, MediaType mediaType) {
        int index = mediaType.ordinal();
        int streamReferenceCount = this.streamReferenceCounts[index];
        if (streamReferenceCount <= 0) {
            return;
        }
        this.streamReferenceCounts[index] = --streamReferenceCount;
        if (streamReferenceCount > 0) {
            return;
        }
        switch (mediaType) {
            case AUDIO: {
                this.setAudioStream(null);
                break;
            }
            case VIDEO: {
                this.setVideoStream(null);
            }
        }
        callPeerMediaHandler.removeAndCleanupOtherSrtpControls(mediaType, null);
    }

    protected MediaStream configureStream(CallPeerMediaHandler<?> callPeerMediaHandler, MediaDevice device, MediaFormat format, MediaStreamTarget target, MediaDirection direction, List<RTPExtension> rtpExtensions, MediaStream stream, boolean masterStream) throws OperationFailedException {
        this.registerDynamicPTsWithStream(callPeerMediaHandler, stream);
        this.registerRTPExtensionsWithStream(callPeerMediaHandler, rtpExtensions, stream);
        stream.setDevice(device);
        stream.setTarget(target);
        stream.setDirection(direction);
        stream.setFormat(format);
        Object call = ((MediaAwareCallPeer)((Object)callPeerMediaHandler.getPeer())).getCall();
        MediaType mediaType = stream instanceof AudioMediaStream ? MediaType.AUDIO : MediaType.VIDEO;
        stream.setRTPTranslator(((MediaAwareCall)call).getRTPTranslator(mediaType));
        switch (mediaType) {
            case AUDIO: {
                AudioMediaStream audioStream = (AudioMediaStream)stream;
                this.setOutputVolumeControl(audioStream, (MediaAwareCall<?, ?, ?>)call);
                this.setAudioStream(audioStream);
                break;
            }
            case VIDEO: {
                this.setVideoStream((VideoMediaStream)stream);
            }
        }
        if (call.isDefaultEncrypted()) {
            SrtpControl srtpControl = stream.getSrtpControl();
            srtpControl.setMasterSession(masterStream);
            srtpControl.setSrtpListener(this.srtpListener);
            srtpControl.start(mediaType);
        }
        if (stream != callPeerMediaHandler.getStream(mediaType)) {
            int n = mediaType.ordinal();
            this.streamReferenceCounts[n] = this.streamReferenceCounts[n] + 1;
        }
        return stream;
    }

    protected boolean fireVideoEvent(int type, Component visualComponent, int origin) {
        return this.videoNotifierSupport.fireVideoEvent(type, visualComponent, origin, true);
    }

    protected void fireVideoEvent(VideoEvent event) {
        this.videoNotifierSupport.fireVideoEvent(event, true);
    }

    SrtpControl getEncryptionMethod(CallPeerMediaHandler<?> callPeerMediaHandler, MediaType mediaType) {
        for (SrtpControlType srtpControlType : SrtpControlType.values()) {
            SrtpControl srtpControl = this.getSrtpControls(callPeerMediaHandler).get(mediaType, srtpControlType);
            if (srtpControl == null || !srtpControl.getSecureCommunicationStatus()) continue;
            return srtpControl;
        }
        return null;
    }

    long getRemoteSSRC(CallPeerMediaHandler<?> callPeerMediaHandler, MediaType mediaType) {
        return this.remoteSSRCs[mediaType.ordinal()];
    }

    SrtpControls getSrtpControls(CallPeerMediaHandler<?> callPeerMediaHandler) {
        return this.srtpControls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SrtpListener[] getSrtpListeners() {
        List<SrtpListener> list = this.srtpListeners;
        synchronized (list) {
            return this.srtpListeners.toArray(new SrtpListener[this.srtpListeners.size()]);
        }
    }

    MediaStream getStream(CallPeerMediaHandler<?> callPeerMediaHandler, MediaType mediaType) {
        switch (mediaType) {
            case AUDIO: {
                return this.audioStream;
            }
            case VIDEO: {
                return this.videoStream;
            }
        }
        throw new IllegalArgumentException("mediaType");
    }

    MediaStream initStream(CallPeerMediaHandler<?> callPeerMediaHandler, StreamConnector connector, MediaDevice device, MediaFormat format, MediaStreamTarget target, MediaDirection direction, List<RTPExtension> rtpExtensions, boolean masterStream) throws OperationFailedException {
        MediaType mediaType = device.getMediaType();
        MediaStream stream = this.getStream(callPeerMediaHandler, mediaType);
        if (stream == null) {
            if (logger.isTraceEnabled() && mediaType != format.getMediaType()) {
                logger.trace((Object)"The media types of device and format differ.");
            }
            MediaService mediaService = ProtocolMediaActivator.getMediaService();
            SrtpControl srtpControl = this.srtpControls.findFirst(mediaType);
            if (srtpControl == null) {
                stream = mediaService.createMediaStream(connector, device);
                srtpControl = stream.getSrtpControl();
                if (srtpControl != null) {
                    this.srtpControls.set(mediaType, srtpControl);
                }
            } else {
                stream = mediaService.createMediaStream(connector, device, srtpControl);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reinitializing stream: " + stream));
        }
        return this.configureStream(callPeerMediaHandler, device, format, target, direction, rtpExtensions, stream, masterStream);
    }

    boolean processKeyFrameRequest(CallPeerMediaHandler<?> callPeerMediaHandler) {
        KeyFrameControl keyFrameControl = this.keyFrameControl;
        return keyFrameControl == null ? null : Boolean.valueOf(keyFrameControl.keyFrameRequest());
    }

    private void registerDynamicPTsWithStream(CallPeerMediaHandler<?> callPeerMediaHandler, MediaStream stream) {
        DynamicPayloadTypeRegistry dynamicPayloadTypes = callPeerMediaHandler.getDynamicPayloadTypes();
        StringBuffer dbgMessage = new StringBuffer("Dynamic PT map: ");
        for (Map.Entry<MediaFormat, Byte> entry : dynamicPayloadTypes.getMappings().entrySet()) {
            byte pt = entry.getValue();
            MediaFormat fmt = entry.getKey();
            dbgMessage.append(pt).append("=").append(fmt).append("; ");
            stream.addDynamicRTPPayloadType(pt, fmt);
        }
        logger.info((Object)dbgMessage);
        dbgMessage = new StringBuffer("PT overrides [");
        for (Map.Entry<Object, Byte> entry : dynamicPayloadTypes.getMappingOverrides().entrySet()) {
            byte originalPt = (Byte)entry.getKey();
            byte overridePt = entry.getValue();
            dbgMessage.append(originalPt).append("->").append(overridePt).append(" ");
            stream.addDynamicRTPPayloadTypeOverride(originalPt, overridePt);
        }
        dbgMessage.append("]");
        logger.info((Object)dbgMessage);
    }

    private void registerRTPExtensionsWithStream(CallPeerMediaHandler<?> callPeerMediaHandler, List<RTPExtension> rtpExtensions, MediaStream stream) {
        DynamicRTPExtensionsRegistry rtpExtensionsRegistry = callPeerMediaHandler.getRtpExtensionsRegistry();
        for (RTPExtension rtpExtension : rtpExtensions) {
            byte extensionID = rtpExtensionsRegistry.getExtensionMapping(rtpExtension);
            stream.addRTPExtension(extensionID, rtpExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCsrcAudioLevelListener(CsrcAudioLevelListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.csrcAudioLevelListenerLock;
        synchronized (object) {
            if (this.csrcAudioLevelListeners.contains(listener)) {
                AudioMediaStream audioStream;
                this.csrcAudioLevelListeners = new ArrayList<CsrcAudioLevelListener>(this.csrcAudioLevelListeners);
                if (this.csrcAudioLevelListeners.remove(listener) && this.csrcAudioLevelListeners.isEmpty() && (audioStream = this.audioStream) != null) {
                    audioStream.setCsrcAudioLevelListener(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeKeyFrameRequester(KeyFrameControl.KeyFrameRequester keyFrameRequester) {
        if (keyFrameRequester == null) {
            return false;
        }
        List<KeyFrameControl.KeyFrameRequester> list = this.keyFrameRequesters;
        synchronized (list) {
            return this.keyFrameRequesters.remove(keyFrameRequester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalUserAudioLevelListener(SimpleAudioLevelListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.localUserAudioLevelListenerLock;
        synchronized (object) {
            if (this.localUserAudioLevelListeners.contains(listener)) {
                AudioMediaStream audioStream;
                this.localUserAudioLevelListeners = new ArrayList<SimpleAudioLevelListener>(this.localUserAudioLevelListeners);
                if (this.localUserAudioLevelListeners.remove(listener) && this.localUserAudioLevelListeners.isEmpty() && (audioStream = this.audioStream) != null) {
                    audioStream.setLocalUserAudioLevelListener(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSrtpListener(SrtpListener listener) {
        if (listener != null) {
            List<SrtpListener> list = this.srtpListeners;
            synchronized (list) {
                this.srtpListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStreamAudioLevelListener(SimpleAudioLevelListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.streamAudioLevelListenerLock;
        synchronized (object) {
            if (this.streamAudioLevelListeners.contains(listener)) {
                AudioMediaStream audioStream;
                this.streamAudioLevelListeners = new ArrayList<SimpleAudioLevelListener>(this.streamAudioLevelListeners);
                if (this.streamAudioLevelListeners.remove(listener) && this.streamAudioLevelListeners.isEmpty() && (audioStream = this.audioStream) != null) {
                    audioStream.setStreamAudioLevelListener(null);
                }
            }
        }
    }

    void removeVideoListener(VideoListener listener) {
        this.videoNotifierSupport.removeVideoListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requestKeyFrame() {
        KeyFrameControl.KeyFrameRequester[] keyFrameRequesterArray = this.keyFrameRequesters;
        synchronized (this.keyFrameRequesters) {
            KeyFrameControl.KeyFrameRequester[] keyFrameRequesters = this.keyFrameRequesters.toArray(new KeyFrameControl.KeyFrameRequester[this.keyFrameRequesters.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (KeyFrameControl.KeyFrameRequester keyFrameRequester : keyFrameRequesters) {
                if (!keyFrameRequester.requestKeyFrame()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAudioStream(AudioMediaStream audioStream) {
        if (this.audioStream != audioStream) {
            long audioRemoteSSRC;
            long audioLocalSSRC;
            if (this.audioStream != null) {
                Object object = this.csrcAudioLevelListenerLock;
                synchronized (object) {
                    if (!this.csrcAudioLevelListeners.isEmpty()) {
                        this.audioStream.setCsrcAudioLevelListener(null);
                    }
                }
                object = this.localUserAudioLevelListenerLock;
                synchronized (object) {
                    if (!this.localUserAudioLevelListeners.isEmpty()) {
                        this.audioStream.setLocalUserAudioLevelListener(null);
                    }
                }
                object = this.streamAudioLevelListenerLock;
                synchronized (object) {
                    if (!this.streamAudioLevelListeners.isEmpty()) {
                        this.audioStream.setStreamAudioLevelListener(null);
                    }
                }
                this.audioStream.removePropertyChangeListener(this.streamPropertyChangeListener);
                this.audioStream.removeDTMFListener((DTMFListener)this.dtmfListener);
                this.audioStream.close();
            }
            this.audioStream = audioStream;
            if (this.audioStream != null) {
                this.audioStream.addPropertyChangeListener(this.streamPropertyChangeListener);
                audioLocalSSRC = this.audioStream.getLocalSourceID();
                audioRemoteSSRC = this.audioStream.getRemoteSourceID();
                Object object = this.csrcAudioLevelListenerLock;
                synchronized (object) {
                    if (!this.csrcAudioLevelListeners.isEmpty()) {
                        this.audioStream.setCsrcAudioLevelListener(this.csrcAudioLevelListener);
                    }
                }
                object = this.localUserAudioLevelListenerLock;
                synchronized (object) {
                    if (!this.localUserAudioLevelListeners.isEmpty()) {
                        this.audioStream.setLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                    }
                }
                object = this.streamAudioLevelListenerLock;
                synchronized (object) {
                    if (!this.streamAudioLevelListeners.isEmpty()) {
                        this.audioStream.setStreamAudioLevelListener(this.streamAudioLevelListener);
                    }
                }
                this.audioStream.addDTMFListener((DTMFListener)this.dtmfListener);
            } else {
                audioRemoteSSRC = -1L;
                audioLocalSSRC = -1L;
            }
            this.setLocalSSRC(MediaType.AUDIO, audioLocalSSRC);
            this.setRemoteSSRC(MediaType.AUDIO, audioRemoteSSRC);
        }
    }

    private void setKeyFrameControlFromVideoStream(VideoMediaStream videoStream) {
        KeyFrameControl keyFrameControl;
        KeyFrameControl keyFrameControl2 = keyFrameControl = videoStream == null ? null : videoStream.getKeyFrameControl();
        if (this.keyFrameControl != keyFrameControl) {
            if (this.keyFrameControl != null) {
                this.keyFrameControl.removeKeyFrameRequester(this.keyFrameRequester);
            }
            this.keyFrameControl = keyFrameControl;
            if (this.keyFrameControl != null) {
                this.keyFrameControl.addKeyFrameRequester(-1, this.keyFrameRequester);
            }
        }
    }

    private void setLocalSSRC(MediaType mediaType, long localSSRC) {
        int index = mediaType.ordinal();
        long oldValue = this.localSSRCs[index];
        if (oldValue != localSSRC) {
            String property;
            this.localSSRCs[index] = localSSRC;
            switch (mediaType) {
                case AUDIO: {
                    property = "AUDIO_LOCAL_SSRC";
                    break;
                }
                case VIDEO: {
                    property = "VIDEO_LOCAL_SSRC";
                    break;
                }
                default: {
                    property = null;
                }
            }
            if (property != null) {
                this.firePropertyChange(property, oldValue, localSSRC);
            }
        }
    }

    private void setOutputVolumeControl(AudioMediaStream audioStream, MediaAwareCall<?, ?, ?> call) {
        VolumeControl outputVolumeControl;
        MediaAwareCallConference conference = call.getConference();
        if (conference != null && (outputVolumeControl = conference.getOutputVolumeControl()) != null) {
            audioStream.setOutputVolumeControl(outputVolumeControl);
        }
    }

    private void setRemoteSSRC(MediaType mediaType, long remoteSSRC) {
        int index = mediaType.ordinal();
        long oldValue = this.remoteSSRCs[index];
        if (oldValue != remoteSSRC) {
            String property;
            this.remoteSSRCs[index] = remoteSSRC;
            switch (mediaType) {
                case AUDIO: {
                    property = "AUDIO_REMOTE_SSRC";
                    break;
                }
                case VIDEO: {
                    property = "VIDEO_REMOTE_SSRC";
                    break;
                }
                default: {
                    property = null;
                }
            }
            if (property != null) {
                this.firePropertyChange(property, oldValue, remoteSSRC);
            }
        }
    }

    private void setVideoStream(VideoMediaStream videoStream) {
        if (this.videoStream != videoStream) {
            long videoRemoteSSRC;
            long videoLocalSSRC;
            List oldVisualComponents = null;
            if (this.videoStream != null) {
                this.videoStream.removePropertyChangeListener(this.streamPropertyChangeListener);
                this.videoStream.removeVideoListener(this.videoStreamVideoListener);
                oldVisualComponents = this.videoStream.getVisualComponents();
                this.setKeyFrameControlFromVideoStream(null);
                this.videoStream.close();
            }
            this.videoStream = videoStream;
            this.setKeyFrameControlFromVideoStream(this.videoStream);
            List newVisualComponents = null;
            if (this.videoStream != null) {
                this.videoStream.addPropertyChangeListener(this.streamPropertyChangeListener);
                videoLocalSSRC = this.videoStream.getLocalSourceID();
                videoRemoteSSRC = this.videoStream.getRemoteSourceID();
                this.videoStream.addVideoListener(this.videoStreamVideoListener);
                newVisualComponents = this.videoStream.getVisualComponents();
            } else {
                videoRemoteSSRC = -1L;
                videoLocalSSRC = -1L;
            }
            this.setLocalSSRC(MediaType.VIDEO, videoLocalSSRC);
            this.setRemoteSSRC(MediaType.VIDEO, videoRemoteSSRC);
            if (oldVisualComponents != null && !oldVisualComponents.isEmpty()) {
                if (newVisualComponents == null) {
                    newVisualComponents = Collections.emptyList();
                }
                for (Component oldVisualComponent : oldVisualComponents) {
                    if (newVisualComponents.remove(oldVisualComponent)) continue;
                    this.fireVideoEvent(2, oldVisualComponent, 2);
                }
            }
            if (newVisualComponents != null && !newVisualComponents.isEmpty()) {
                for (Component newVisualComponent : newVisualComponents) {
                    this.fireVideoEvent(1, newVisualComponent, 2);
                }
            }
        }
    }

    private class MyDTMFListener
    implements DTMFListener {
        private MyDTMFListener() {
        }

        public void dtmfToneReceptionStarted(DTMFToneEvent dtmfToneEvent) {
            this.fireEvent(new DTMFReceivedEvent((Object)this, DTMFTone.getDTMFTone((String)dtmfToneEvent.getDtmfTone().getValue()), true));
        }

        public void dtmfToneReceptionEnded(DTMFToneEvent dtmfToneEvent) {
            this.fireEvent(new DTMFReceivedEvent((Object)this, DTMFTone.getDTMFTone((String)dtmfToneEvent.getDtmfTone().getValue()), false));
        }

        private void fireEvent(DTMFReceivedEvent event) {
            for (net.java.sip.communicator.service.protocol.event.DTMFListener listener : MediaHandler.this.dtmfListeners) {
                listener.toneReceived(event);
            }
        }
    }
}

