/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountCreationFormService;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberServerChooserDialog;
import net.java.sip.communicator.plugin.jabberaccregwizz.NewAccount;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class JabberAccountCreationForm
extends TransparentPanel
implements JabberAccountCreationFormService {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(JabberAccountCreationForm.class);
    private JabberServerChooserDialog jabberServerChooserDialog;
    private JPanel userIDPassPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private JPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private JPanel serverPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JLabel serverLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.CSERVER"));
    private JLabel userIDLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.USERNAME"));
    private JLabel passLabel = new JLabel(Resources.getString("service.gui.PASSWORD"));
    private JLabel pass2Label = new JLabel(Resources.getString("plugin.jabberaccregwizz.PASSWORD_CONFIRM"));
    private JLabel portLabel = new JLabel(Resources.getString("service.gui.PORT"));
    private JTextField serverField = new JTextField();
    private JTextField userIDField = new JTextField();
    private JPasswordField passField = new JPasswordField();
    private JPasswordField pass2Field = new JPasswordField();
    private JTextField portField = new JTextField("5222");
    private JButton chooseButton = new JButton();
    private Connection xmppConnection = null;
    private AccountManager accountManager = null;
    private final JTextPane errorPane = new JTextPane();

    public JabberAccountCreationForm() {
        this.initErrorArea();
        this.labelsPanel.add(this.serverLabel);
        this.labelsPanel.add(this.userIDLabel);
        this.labelsPanel.add(this.passLabel);
        this.labelsPanel.add(this.pass2Label);
        this.labelsPanel.add(this.portLabel);
        this.userIDField.setColumns(30);
        this.serverPanel.add((Component)this.serverField, "Center");
        this.serverPanel.add((Component)this.chooseButton, "East");
        this.valuesPanel.add(this.serverPanel);
        this.valuesPanel.add(this.userIDField);
        this.valuesPanel.add(this.passField);
        this.valuesPanel.add(this.pass2Field);
        this.valuesPanel.add(this.portField);
        this.userIDPassPanel.add((Component)this.labelsPanel, "West");
        this.userIDPassPanel.add((Component)this.valuesPanel, "Center");
        this.chooseButton.setText(Resources.getString("plugin.jabberaccregwizz.CHOOSE"));
        this.chooseButton.setMnemonic(Resources.getMnemonic("plugin.jabberaccregwizz.CHOOSE"));
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JabberAccountCreationForm.this.jabberServerChooserDialog = new JabberServerChooserDialog();
                if (((JabberAccountCreationForm)JabberAccountCreationForm.this).jabberServerChooserDialog.isOK) {
                    JabberAccountCreationForm.this.serverField.setText(((JabberAccountCreationForm)JabberAccountCreationForm.this).jabberServerChooserDialog.serverSelected);
                }
            }
        });
        this.add(this.userIDPassPanel, "Center");
    }

    private boolean createJabberAccount(String server, int port, String username, String password) {
        try {
            ConnectionConfiguration config = new ConnectionConfiguration(server, port);
            this.xmppConnection = new XMPPConnection(config);
            this.xmppConnection.connect();
            this.accountManager = new AccountManager(this.xmppConnection);
            this.accountManager.createAccount(username, password);
            return true;
        }
        catch (XMPPException exc) {
            logger.error((Object)exc);
            if (exc.getXMPPError() != null && exc.getXMPPError().getCode() == 409) {
                this.showErrorMessage(Resources.getString("plugin.jabberaccregwizz.USER_EXISTS_ERROR"));
                logger.error((Object)"Error when created a new Jabber account : user already exist");
            } else {
                this.showErrorMessage(Resources.getResources().getI18NString("plugin.jabberaccregwizz.UNKNOWN_XMPP_ERROR", new String[]{exc.getMessage()}));
            }
            return false;
        }
    }

    @Override
    public NewAccount createAccount() {
        String userID = this.userIDField.getText();
        char[] password = this.passField.getPassword();
        char[] password2 = this.pass2Field.getPassword();
        String server = this.serverField.getText();
        int port = 5222;
        try {
            port = Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (new String(password).equals(new String(password2))) {
            boolean result = this.createJabberAccount(server, port, userID, new String(password));
            if (result) {
                return new NewAccount(this.getCompleteUserID(userID, server), password, server, String.valueOf(port));
            }
        } else {
            this.showErrorMessage(Resources.getString("plugin.jabberaccregwizz.NOT_SAME_PASSWORD"));
        }
        return null;
    }

    @Override
    public Component getForm() {
        return this;
    }

    @Override
    public void clear() {
        this.userIDField.setText("");
        this.passField.setText("");
        this.pass2Field.setText("");
        this.serverField.setText(Resources.getSettingsString("plugin.jabberaccregwizz.NEW_ACCOUNT_DEFAULT_SERVER"));
        this.errorPane.setText("");
        this.userIDPassPanel.remove(this.errorPane);
    }

    private void initErrorArea() {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 2);
        StyleConstants.setFontFamily(attribs, this.errorPane.getFont().getFamily());
        StyleConstants.setForeground(attribs, Color.RED);
        this.errorPane.setParagraphAttributes(attribs, true);
        this.errorPane.setPreferredSize(new Dimension(100, 50));
        this.errorPane.setMinimumSize(new Dimension(100, 50));
        this.errorPane.setOpaque(false);
    }

    private void showErrorMessage(String text) {
        Window ancestor;
        this.errorPane.setText(text);
        if (this.errorPane.getParent() == null) {
            this.userIDPassPanel.add((Component)this.errorPane, "North");
        }
        if ((ancestor = SwingUtilities.getWindowAncestor((Component)((Object)this))) != null) {
            ancestor.pack();
        }
    }

    private String getCompleteUserID(String userID, String server) {
        if (userID.indexOf("@") < 0 && server != null && server.length() > 0) {
            return userID + "@" + server;
        }
        return userID;
    }
}

