/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;

abstract class AbstractConnection
extends Connection {
    private static final Logger LOGGER = Logger.getLogger(AbstractConnection.class.getName());
    protected String connectionID = null;
    private String user = null;
    protected boolean connected = false;
    private boolean authenticated = false;
    private boolean wasAuthenticated = false;
    private boolean anonymous = false;
    protected PacketWriter packetWriter;
    protected PacketReader packetReader;
    private Roster roster = null;

    protected AbstractConnection(ConnectionConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void connect() throws XMPPException {
        this.connectUsingConfiguration(this.config);
        this.initConnection();
        if (this.connected && this.wasAuthenticated) {
            try {
                if (this.isAnonymous()) {
                    this.loginAnonymously();
                } else {
                    this.login(this.config.getUsername(), this.config.getPassword(), this.config.getResource());
                }
                this.packetReader.notifyReconnection();
            }
            catch (XMPPException e) {
                LOGGER.log(Level.SEVERE, "Error login", e);
            }
        }
    }

    protected abstract void connectUsingConfiguration(ConnectionConfiguration var1) throws XMPPException;

    protected void initConnection() throws XMPPException {
        boolean isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        this.initReaderAndWriter();
        try {
            if (isFirstInitialization) {
                this.packetWriter = this.createPacketWriter();
                this.packetReader = this.createPacketReader();
                if (this.config.isDebuggerEnabled()) {
                    this.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.packetWriter.startKeepAliveProcess();
            if (isFirstInitialization) {
                for (ConnectionCreationListener listener : AbstractConnection.getConnectionCreationListeners()) {
                    listener.connectionCreated(this);
                }
            } else if (!this.wasAuthenticated) {
                this.packetReader.notifyReconnection();
            }
        }
        catch (XMPPException ex) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.writer = null;
            }
            this.initConnectionFailed(ex);
            this.setWasAuthenticated(this.authenticated);
            this.authenticated = false;
            this.connected = false;
            throw ex;
        }
    }

    protected void initReaderAndWriter() throws XMPPException {
        this.initDebugger();
    }

    protected abstract void initConnectionFailed(XMPPException var1);

    protected abstract PacketReader createPacketReader();

    protected abstract PacketWriter createPacketWriter();

    protected abstract void onSuccessReceived() throws IOException;

    @Override
    public synchronized void login(String username, String password, String resource) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        username = username.toLowerCase().trim();
        String response = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? (password != null ? this.saslAuthentication.authenticate(username, password, resource) : this.saslAuthentication.authenticate(username, resource, this.config.getCallbackHandler())) : new NonSASLAuthentication(this).authenticate(username, password, resource);
        if (response != null) {
            this.user = response;
            this.config.setServiceName(StringUtils.parseServer(response));
        } else {
            this.user = username + "@" + this.getServiceName();
            if (resource != null) {
                this.user = this.user + "/" + resource;
            }
        }
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.authenticated = true;
        this.anonymous = false;
        if (this.roster == null) {
            this.roster = new Roster(this);
        }
        if (this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (this.config.isSendPresence()) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        }
        this.config.setLoginInfo(username, password, resource);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    @Override
    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String response = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = response;
        this.config.setServiceName(StringUtils.parseServer(response));
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Roster getRoster() {
        Object object = this;
        synchronized (object) {
            if (!this.isAuthenticated() || this.isAnonymous()) {
                if (this.roster == null) {
                    this.roster = new Roster(this);
                }
                return this.roster;
            }
        }
        if (!this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (!this.roster.rosterInitialized) {
            try {
                object = this.roster;
                synchronized (object) {
                    long now;
                    long start = System.currentTimeMillis();
                    for (long waitTime = (long)SmackConfiguration.getPacketReplyTimeout(); !this.roster.rosterInitialized && waitTime > 0L; waitTime -= now - start) {
                        this.roster.wait(waitTime);
                        now = System.currentTimeMillis();
                        start = now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    protected abstract boolean useCompression();

    @Override
    public synchronized void disconnect(Presence unavailablePresence) {
        if (this.packetReader == null || this.packetWriter == null) {
            return;
        }
        this.shutdown(unavailablePresence);
        if (this.roster != null) {
            this.roster.cleanup();
            this.roster = null;
        }
        this.wasAuthenticated = false;
        this.packetWriter.cleanup();
        this.packetWriter = null;
        this.packetReader.cleanup();
        this.packetReader = null;
    }

    @Override
    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        this.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.removePacketInterceptor(packetInterceptor);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        this.addPacketSendingListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.removePacketSendingListener(packetListener);
    }

    public void shutdown(Presence unavailablePresence) {
        this.packetWriter.sendPacket(unavailablePresence);
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        this.connected = false;
        this.packetReader.shutdown();
        this.packetWriter.shutdown();
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        this.saslAuthentication.init();
    }

    private void setWasAuthenticated(boolean wasAuthenticated) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = wasAuthenticated;
        }
    }

    @Override
    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    @Override
    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }
}

