/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.MiscTools;
import net.kano.joscar.rvcmd.SegmentedFilename;
import net.kano.joscar.rvproto.ft.FileTransferHeader;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Checksummer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FailureEventException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingFileTransferPlumber;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingFileTransferPlumberImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferProblemException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFile;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.Transferrer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ChecksummingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.CorruptTransferEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.FileCompleteEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ResumeChecksumFailedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferringFileEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferringFileInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.TransferSucceededInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendFileController
extends TransferController {
    private static final Logger LOGGER = Logger.getLogger(SendFileController.class.getName());
    private OutgoingFileTransferPlumber plumber;
    private EventPost eventPost;
    private RvSessionConnectionInfo rvConnectionInfo;
    private OutgoingFileTransfer transfer;

    public void setPlumber(OutgoingFileTransferPlumber plumber) {
        this.plumber = plumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transferInThread(RvConnection connection) throws IOException, FailureEventException {
        this.transfer = (OutgoingFileTransfer)connection;
        this.rvConnectionInfo = connection.getRvSessionInfo();
        this.eventPost = this.transfer.getEventPost();
        this.initializePlumber();
        List<TransferredFile> fileHandles = this.plumber.getFilesToTransfer();
        try {
            int fileCount;
            long totalSize = SendFileController.getTotalSize(fileHandles);
            int filesRemaining = fileCount = fileHandles.size();
            try {
                for (TransferredFile currentFile : fileHandles) {
                    this.sendFile(currentFile, filesRemaining, fileCount, totalSize);
                    --filesRemaining;
                }
                this.fireSucceeded(new TransferSucceededInfo(fileHandles));
            }
            catch (TransferProblemException e) {
                this.fireFailed(new UnknownErrorEvent());
            }
        }
        finally {
            this.close(fileHandles);
        }
    }

    private void sendFile(TransferredFile currentFile, int filesRemaining, int fileCount, long totalSize) throws IOException, TransferProblemException {
        long fileChecksum = this.computeChecksum(currentFile);
        long fileSize = currentFile.getSize();
        FileTransferHeader initialHeader = this.createInitialHeaderForFile(currentFile, fileChecksum, filesRemaining, fileCount, fileSize, totalSize);
        this.plumber.sendHeader(initialHeader);
        long resumePosition = this.readInitialResponse(currentFile, initialHeader, fileChecksum);
        TransferringFileInfo info = new TransferringFileInfo(currentFile, resumePosition);
        long transferred = this.transferFile(info);
        currentFile.close();
        this.checkSentCorrectData(resumePosition, fileSize, transferred);
        this.readReceivedResponse(info, fileChecksum);
    }

    private long readInitialResponse(TransferredFile currentFile, FileTransferHeader ourInitialHeader, long fileChecksum) throws IOException, TransferProblemException {
        FileTransferHeader ack = this.plumber.readHeader();
        this.checkAcknowledgement(ack);
        this.setConnected();
        return this.getResumePosition(currentFile, ourInitialHeader, ack, fileChecksum);
    }

    private void readReceivedResponse(TransferringFileInfo info, long fileChecksum) throws IOException, TransferProblemException {
        FileTransferHeader receivedHeader = this.plumber.readHeader();
        if (receivedHeader == null) {
            throw new TransferProblemException();
        }
        if (receivedHeader.getBytesReceived() != info.getFileSize() || receivedHeader.getChecksum() != fileChecksum) {
            this.fireFailed(new CorruptTransferEvent(info));
            throw new TransferProblemException();
        }
        this.eventPost.fireEvent(new FileCompleteEvent(info));
    }

    private void checkSentCorrectData(long resumePosition, long fileSize, long transferred) throws TransferProblemException {
        long toSend = fileSize - resumePosition;
        if (transferred != toSend) {
            LOGGER.warning("Expected to send " + toSend + ", but only sent " + transferred + ": I don't know why");
            throw new TransferProblemException();
        }
    }

    private long getResumePosition(TransferredFile currentFile, FileTransferHeader ourInitialHeader, FileTransferHeader response, long fileChecksum) throws IOException, TransferProblemException {
        long resumePosition;
        int headerType = response.getHeaderType();
        if (headerType == 517) {
            resumePosition = this.getResumePositionFromResumePacket(currentFile, ourInitialHeader, response, fileChecksum);
        } else if (headerType == 514) {
            resumePosition = 0L;
        } else {
            return this.throwUnknownHeaderException(currentFile, headerType, "in response to initial header");
        }
        return resumePosition;
    }

    private long throwUnknownHeaderException(TransferredFile currentFile, int headerType, String note) throws TransferProblemException {
        String headerTypeName = MiscTools.findEqualField(FileTransferHeader.class, headerType, "HEADERTYPE_.*");
        LOGGER.warning("Got unknown header type (" + note + ") for " + currentFile.getTransferredName() + ": " + headerTypeName);
        throw new TransferProblemException();
    }

    private long transferFile(TransferringFileInfo info) throws IOException {
        Transferrer sender = this.plumber.createTransferrer(info.getFile(), info.getResumePosition(), info.getFileSize());
        assert (sender != null) : this.plumber;
        this.eventPost.fireEvent(new TransferringFileEvent(info, sender));
        long sent = sender.transfer();
        return sent;
    }

    private long getResumePositionFromResumePacket(TransferredFile currentFile, FileTransferHeader initialHeader, FileTransferHeader ack, long fileChecksum) throws IOException, TransferProblemException {
        long respondStartAt = this.getActualResumePosition(ack, currentFile);
        this.sendResumeHeader(initialHeader, respondStartAt, fileChecksum);
        FileTransferHeader resumeAck = this.plumber.readHeader();
        if (resumeAck.getHeaderType() != 519) {
            this.throwUnknownHeaderException(currentFile, resumeAck.getHeaderType(), "in response to resume header");
        }
        long startAt = resumeAck.getBytesReceived();
        return startAt;
    }

    private void initializePlumber() {
        if (this.plumber == null) {
            this.plumber = new OutgoingFileTransferPlumberImpl(this.transfer, this);
        }
    }

    private void close(List<TransferredFile> rafs) {
        for (TransferredFile file : rafs) {
            try {
                file.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Couldn't close " + file.getTransferredName() + ": " + e.getMessage(), e);
            }
        }
    }

    private void sendResumeHeader(FileTransferHeader sendheader, long resumePosition, long fileChecksum) throws IOException {
        FileTransferHeader resumeSend = new FileTransferHeader(sendheader);
        resumeSend.setBytesReceived(resumePosition);
        resumeSend.setChecksum(fileChecksum);
        resumeSend.setHeaderType(262);
        this.plumber.sendHeader(resumeSend);
    }

    private long getActualResumePosition(FileTransferHeader acknowledgement, TransferredFile currentFile) throws IOException {
        long respondStartAt;
        long attemptStartAt = acknowledgement.getBytesReceived();
        long attemptChecksum = acknowledgement.getReceivedChecksum();
        long oursum = this.checksumFilePart(currentFile, attemptStartAt);
        if (oursum != attemptChecksum) {
            this.eventPost.fireEvent(new ResumeChecksumFailedEvent(currentFile));
            respondStartAt = 0L;
        } else {
            respondStartAt = attemptStartAt;
        }
        return respondStartAt;
    }

    private long checksumFilePart(TransferredFile currentFile, long partLength) throws IOException {
        Checksummer rsummer = this.plumber.getChecksummer(currentFile, partLength);
        this.eventPost.fireEvent(new ChecksummingEvent(currentFile, rsummer));
        return rsummer.compute();
    }

    private long computeChecksum(TransferredFile mfile) throws IOException {
        this.pauseTimeout();
        long fileChecksum = this.transfer.getChecksummer().getChecksum(mfile);
        this.resumeTimeout();
        return fileChecksum;
    }

    private FileTransferHeader createInitialHeaderForFile(TransferredFile mfile, long fileChecksum, int filesLeft, int fileCount, long fileSize, long totalSize) {
        FileTransferHeader sendheader = new FileTransferHeader();
        sendheader.setDefaults();
        sendheader.setFilename(SegmentedFilename.fromNativeFilename(mfile.getTransferredName()));
        sendheader.setHeaderType(257);
        sendheader.setChecksum(fileChecksum);
        sendheader.setReceivedChecksum(0xFFFF0000L);
        sendheader.setFileCount(fileCount);
        sendheader.setFileSize(fileSize);
        sendheader.setFilesLeft(filesLeft);
        sendheader.setLastmod(mfile.getLastModifiedMillis() / 1000L);
        sendheader.setPartCount(1);
        sendheader.setPartsLeft(1);
        sendheader.setMacFileInfo(mfile.getMacFileInfo());
        sendheader.setResForkChecksum(0xFFFF0000L);
        sendheader.setResForkReceivedChecksum(0xFFFF0000L);
        sendheader.setListNameOffset(28);
        sendheader.setListSizeOffset(17);
        sendheader.setTotalFileSize(totalSize);
        long rvSessionId = this.rvConnectionInfo.getRvSession().getRvSessionId();
        if (this.rvConnectionInfo.getInitiator() == Initiator.BUDDY) {
            sendheader.setIcbmMessageId(rvSessionId);
        }
        return sendheader;
    }

    private void checkAcknowledgement(FileTransferHeader ack) throws TransferProblemException {
        long rvSessionId = this.rvConnectionInfo.getRvSession().getRvSessionId();
        if (ack == null) {
            LOGGER.warning("Couldn't read file transfer header, closing");
            throw new TransferProblemException();
        }
        if (this.rvConnectionInfo.getInitiator() == Initiator.ME && ack.getIcbmMessageId() != rvSessionId) {
            LOGGER.warning("Buddy sent wrong ICBM message ID: " + ack.getIcbmMessageId() + " should have been " + rvSessionId);
            throw new TransferProblemException();
        }
    }

    private static long getTotalSize(Collection<TransferredFile> files) {
        long totalSize = 0L;
        for (TransferredFile file : files) {
            totalSize += file.getSize();
        }
        return totalSize;
    }
}

