/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.WarningLevel;
import org.jetbrains.annotations.Nullable;

public class ParamInfo
implements Writable {
    public static final int MAXCHAN_DEFAULT = 0;
    public static final long FLAG_CHANMSGS_ALLOWED = 1L;
    public static final long FLAG_MISSEDCALLS_ALLOWED = 2L;
    public static final long FLAG_TYPING_NOTIFICATION = 8L;
    private final int maxChannel;
    private final long flags;
    private final int maxMsgLen;
    private final WarningLevel maxSenderWarning;
    private final WarningLevel maxReceiverWarning;
    private final long minMsgInterval;

    @Nullable
    protected static ParamInfo readParamInfo(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() < 16) {
            return null;
        }
        int maxchan = BinaryTools.getUShort(block, 0);
        long flags = BinaryTools.getUInt(block, 2);
        int maxmsglen = BinaryTools.getUShort(block, 6);
        WarningLevel maxsendwarn = WarningLevel.getInstanceFromX10(BinaryTools.getUShort(block, 8));
        WarningLevel maxrecvwarn = WarningLevel.getInstanceFromX10(BinaryTools.getUShort(block, 10));
        long minint = BinaryTools.getUInt(block, 12);
        return new ParamInfo(maxchan, flags, maxmsglen, maxsendwarn, maxrecvwarn, minint);
    }

    public ParamInfo(long flags, int maxMsgLen, WarningLevel maxSenderWarning, WarningLevel maxReceiverWarning, long minMsgInterval) {
        this(0, flags, maxMsgLen, maxSenderWarning, maxReceiverWarning, minMsgInterval);
    }

    public ParamInfo(int maxChannel, long flags, int maxMsgLen, WarningLevel maxSenderWarning, WarningLevel maxReceiverWarning, long minMsgInterval) {
        DefensiveTools.checkRange(maxChannel, "maxChannel", 0);
        DefensiveTools.checkRange(flags, "flags", 0L);
        DefensiveTools.checkRange(maxMsgLen, "maxMsgLen", 0);
        DefensiveTools.checkNull(maxSenderWarning, "maxSenderWarning");
        DefensiveTools.checkNull(maxReceiverWarning, "maxReceiverWarning");
        DefensiveTools.checkRange(minMsgInterval, "minMsgInterval", 0L);
        this.maxChannel = maxChannel;
        this.flags = flags;
        this.maxMsgLen = maxMsgLen;
        this.maxSenderWarning = maxSenderWarning;
        this.maxReceiverWarning = maxReceiverWarning;
        this.minMsgInterval = minMsgInterval;
    }

    public final int getMaxChannel() {
        return this.maxChannel;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final int getMaxMsgLen() {
        return this.maxMsgLen;
    }

    public final WarningLevel getMaxSenderWarning() {
        return this.maxSenderWarning;
    }

    public final WarningLevel getMaxReceiverWarning() {
        return this.maxReceiverWarning;
    }

    public final long getMinMsgInterval() {
        return this.minMsgInterval;
    }

    public long getWritableLength() {
        return 16L;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.maxChannel);
        BinaryTools.writeUInt(out, this.flags);
        BinaryTools.writeUShort(out, this.maxMsgLen);
        BinaryTools.writeUShort(out, this.maxSenderWarning.getX10Value());
        BinaryTools.writeUShort(out, this.maxReceiverWarning.getX10Value());
        BinaryTools.writeUInt(out, this.minMsgInterval);
    }

    public String toString() {
        return "ParamInfo: maxChannel=" + this.maxChannel + ", flags=0x" + Long.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(ParamInfo.class, this.flags, "FLAG_.*") + ")" + ", maxMsgLen=" + this.maxMsgLen + ", maxSenderWarning=" + this.maxSenderWarning + ", maxReceiverWarning=" + this.maxReceiverWarning + ", minMsgInterval=" + this.minMsgInterval;
    }
}

