/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification;

import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.MailThreadInfo;
import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.MailboxIQ;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

public class MailboxIQProvider
implements IQProvider {
    private static final Logger logger = Logger.getLogger(MailboxIQProvider.class);

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        String totalEstimateStr;
        String totalMatchedStr;
        MailboxIQ mailboxIQ = new MailboxIQ();
        String resultTimeStr = parser.getAttributeValue("", "result-time");
        if (resultTimeStr != null) {
            mailboxIQ.setResultTime(Long.parseLong(resultTimeStr));
        }
        if ((totalMatchedStr = parser.getAttributeValue("", "total-matched")) != null) {
            mailboxIQ.setTotalMatched(Integer.parseInt(totalMatchedStr));
        }
        if ((totalEstimateStr = parser.getAttributeValue("", "total-estimate")) != null) {
            mailboxIQ.setTotalEstimate("1".equals(totalEstimateStr));
        }
        mailboxIQ.setUrl(parser.getAttributeValue("", "url"));
        int eventType = parser.next();
        while (eventType != 3) {
            if (eventType == 2) {
                String name = parser.getName();
                if ("mail-thread-info".equals(name)) {
                    MailThreadInfo thread = MailThreadInfo.parse(parser);
                    mailboxIQ.addThread(thread);
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("xml parser returned eventType=" + eventType));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("parser=" + parser.getText()));
                }
            }
            eventType = parser.next();
        }
        return mailboxIQ;
    }
}

