/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.runner;

import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;
import junit.runner.Version;
import net.java.sip.communicator.slick.runner.XmlFormatter;
import net.java.sip.communicator.util.Logger;

public class ScTestRunner
extends BaseTestRunner {
    private Logger logger = Logger.getLogger((String)ScTestRunner.class.getName());
    private static XmlFormatter testPrinter;

    public ScTestRunner(XmlFormatter printer) {
        testPrinter = printer;
    }

    public static void run(Class<? extends Test> testClass, XmlFormatter fmtr) {
        ScTestRunner.run((Test)new TestSuite(testClass), fmtr);
    }

    public static TestResult run(Test test, XmlFormatter printer) {
        ScTestRunner runner = new ScTestRunner(printer);
        return runner.doRun(test);
    }

    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    public void testFailed(int status, Test test, Throwable t) {
        this.logger.debug((Object)("test " + test.toString() + " failed."));
    }

    public void testStarted(String testName) {
        this.logger.debug((Object)("started testName" + testName));
    }

    public void testEnded(String testName) {
        this.logger.debug((Object)("ended testName" + testName));
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    public TestResult doRun(Test test) {
        return this.doRun(test, false);
    }

    public TestResult doRun(Test suite, boolean wait) {
        TestResult result = new TestResult();
        result.addListener((TestListener)testPrinter);
        testPrinter.startTestSuite(suite, System.getProperties());
        long startTime = System.currentTimeMillis();
        suite.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        testPrinter.endTestSuite(suite, result.errorCount(), result.failureCount(), runTime);
        return result;
    }

    protected void pause(boolean wait) {
        if (!wait) {
            return;
        }
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TestResult start(String[] args) throws Exception {
        String testCase = "";
        boolean wait = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-wait")) {
                wait = true;
                continue;
            }
            if (args[i].equals("-c")) {
                testCase = this.extractClassName(args[++i]);
                continue;
            }
            if (args[i].equals("-v")) {
                System.err.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
                continue;
            }
            testCase = args[i];
        }
        if (testCase.equals("")) {
            throw new Exception("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
        }
        try {
            Test suite = this.getTest(testCase);
            return this.doRun(suite, wait);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    protected void runFailed(String message) {
        System.err.println(message);
        System.exit(1);
    }
}

