/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.StyledHTMLEditorPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;

public class ErrorDialog
extends SIPCommDialog
implements ActionListener,
HyperlinkListener,
Skinnable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ErrorDialog.class);
    private JButton okButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.OK"));
    private JLabel iconLabel = new JLabel(new ImageIcon(DesktopUtilActivator.getImage("service.gui.icons.ERROR_ICON")));
    private StyledHTMLEditorPane htmlMsgEditorPane = new StyledHTMLEditorPane();
    private JTextArea stackTraceTextArea = new JTextArea();
    private JScrollPane stackTraceScrollPane = new JScrollPane();
    private TransparentPanel buttonsPanel = new TransparentPanel(new FlowLayout(1));
    private TransparentPanel infoMessagePanel = new TransparentPanel();
    private TransparentPanel messagePanel = new TransparentPanel(new BorderLayout());
    private TransparentPanel mainPanel = new TransparentPanel(new BorderLayout(10, 10));
    private static String showStackTraceDefaultProp = DesktopUtilActivator.getResources().getSettingsString("net.java.sip.communicator.SHOW_STACK_TRACE");
    private static final boolean showStackTrace = showStackTraceDefaultProp != null ? Boolean.parseBoolean(showStackTraceDefaultProp) : true;
    private boolean detailsShown = true;
    public static final int WARNING = 1;
    private int type = 0;
    private static final int MAX_MSG_PANE_WIDTH = 340;
    private static final int MAX_MSG_PANE_HEIGHT = 800;

    public ErrorDialog(Frame owner, String title, String message) {
        super(owner, false);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 10, 20));
        if (showStackTrace) {
            this.stackTraceScrollPane.setBorder(BorderFactory.createLineBorder(this.iconLabel.getForeground()));
            this.stackTraceScrollPane.setHorizontalScrollBarPolicy(32);
        }
        this.setTitle(title);
        this.infoMessagePanel.setLayout(new BorderLayout());
        JEditorPane messageArea = new JEditorPane();
        messageArea.putClientProperty("JEditorPane.honorDisplayProperties", true);
        messageArea.setOpaque(false);
        messageArea.setEditable(false);
        messageArea.setContentType("text/html");
        messageArea.setText("<html><body><p align=\"left\" >" + message + "</p></body></html>");
        messageArea.setSize(new Dimension(340, 800));
        messageArea.setPreferredSize(new Dimension(340, messageArea.getPreferredSize().height));
        this.infoMessagePanel.add(messageArea, "Center");
        this.init();
    }

    public ErrorDialog(Frame owner, String title, String message, Throwable e) {
        this(owner, title, message);
        if (showStackTrace && e != null) {
            this.setTitle(title);
            this.htmlMsgEditorPane.setEditable(false);
            this.htmlMsgEditorPane.setOpaque(false);
            this.htmlMsgEditorPane.addHyperlinkListener(this);
            this.showOrHideDetails();
            this.infoMessagePanel.add(this.htmlMsgEditorPane, "South");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            String stackTrace = sw.toString();
            try {
                sw.close();
            }
            catch (IOException ex) {
                logger.error((Object)"Failed to close a StringWriter. ", (Throwable)ex);
            }
            this.stackTraceTextArea.setText(stackTrace);
        }
    }

    public ErrorDialog(Frame owner, String title, String message, int type) {
        this(owner, title, message);
        if (type == 1) {
            this.iconLabel.setIcon(new ImageIcon(DesktopUtilActivator.getImage("service.gui.icons.WARNING_ICON")));
            this.type = type;
        }
    }

    private void init() {
        this.getRootPane().setDefaultButton(this.okButton);
        this.stackTraceScrollPane.getViewport().add(this.stackTraceTextArea);
        this.stackTraceScrollPane.setPreferredSize(new Dimension(this.getWidth(), 100));
        this.buttonsPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.mainPanel.add(this.iconLabel, "West");
        this.messagePanel.add((Component)((Object)this.infoMessagePanel), "North");
        this.mainPanel.add((Component)((Object)this.messagePanel), "Center");
        this.mainPanel.add((Component)((Object)this.buttonsPanel), "South");
        this.getContentPane().add((Component)((Object)this.mainPanel));
    }

    public void showOrHideDetails() {
        String msgString;
        String startDivTag = "<div id=\"message\">";
        String endDivTag = "</div>";
        boolean bl = this.detailsShown = !this.detailsShown;
        if (this.detailsShown) {
            msgString = startDivTag + " <p align=\"right\"><a href=\"\">&lt;&lt; Hide info</a></p>" + endDivTag;
            this.messagePanel.add(this.stackTraceScrollPane, "Center");
        } else {
            msgString = startDivTag + " <p align=\"right\"><a href=\"\">More info &gt;&gt;</a></p>" + endDivTag;
            this.messagePanel.remove(this.stackTraceScrollPane);
        }
        this.htmlMsgEditorPane.setText(msgString);
        this.messagePanel.revalidate();
        this.messagePanel.repaint();
        this.setPreferredSize(null);
        this.pack();
    }

    public void showDialog() {
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
        this.toFront();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        if (button.equals(this.okButton)) {
            this.dispose();
        }
    }

    @Override
    protected void close(boolean isEscaped) {
        this.okButton.doClick();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showOrHideDetails();
        }
    }

    public void loadSkin() {
        String icon = this.type == 1 ? "service.gui.icons.WARNING_ICON" : "service.gui.icons.ERROR_ICON";
        this.iconLabel.setIcon(new ImageIcon(DesktopUtilActivator.getImage(icon)));
    }
}

