/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.AccountManagerUtils;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountUninstallation
extends TestCase {
    private JabberSlickFixture fixture = new JabberSlickFixture();

    public TestAccountUninstallation(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestAccountUninstallation("testInstallationPersistency"));
        suite.addTest((Test)new TestAccountUninstallation("testUninstallAccount"));
        return suite;
    }

    public void testInstallationPersistency() throws Exception {
        Bundle providerBundle;
        JabberSlickFixture.providerBundle = providerBundle = this.fixture.findProtocolProviderBundle(this.fixture.provider1);
        TestAccountUninstallation.assertNotNull((String)"Couldn't find a bundle for the tested provider", (Object)providerBundle);
        providerBundle.stop();
        TestAccountUninstallation.assertTrue((String)("Couldn't stop the protocol provider bundle. State was " + providerBundle.getState()), (32 != providerBundle.getState() && 16 != providerBundle.getState() ? 1 : 0) != 0);
        providerBundle.uninstall();
        TestAccountUninstallation.assertEquals((String)"Couldn't stop the protocol provider bundle.", (int)1, (int)providerBundle.getState());
        ServiceReference[] jabberProviderRefs = null;
        try {
            jabberProviderRefs = JabberSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=Jabber)(USER_ID=" + this.fixture.userID1 + "))");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong: " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was still regged as an osgi service for Jabber URI:" + this.fixture.userID1 + "After it was explicitly uninstalled"), (jabberProviderRefs == null || jabberProviderRefs.length == 0 ? 1 : 0) != 0);
        TestAccountUninstallation.assertTrue((String)("The Jabber provider factory kept a reference to the provider we just uninstalled (uri=" + this.fixture.userID1 + ")"), (this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()) == null ? 1 : 0) != 0);
        JabberSlickFixture.providerBundle = providerBundle = JabberSlickFixture.bc.installBundle(providerBundle.getLocation());
        TestAccountUninstallation.assertEquals((String)"Couldn't re-install protocol provider bundle.", (int)2, (int)providerBundle.getState());
        AccountManagerUtils.startBundleAndWaitStoredAccountsLoaded((BundleContext)JabberSlickFixture.bc, (Bundle)providerBundle, (String)"Jabber");
        TestAccountUninstallation.assertEquals((String)"Couldn't re-start protocol provider bundle.", (int)32, (int)providerBundle.getState());
        try {
            jabberProviderRefs = JabberSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=Jabber)(USER_ID=" + this.fixture.userID1 + "))");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was not restored after beingreinstalled. Jabber URI:" + this.fixture.userID1), (jabberProviderRefs != null && jabberProviderRefs.length > 0 ? 1 : 0) != 0);
        ServiceReference[] jabberFactoryRefs = null;
        try {
            jabberFactoryRefs = JabberSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), "(PROTOCOL_NAME=Jabber)");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        this.fixture.providerFactory = (ProtocolProviderFactory)JabberSlickFixture.bc.getService(jabberFactoryRefs[0]);
        this.fixture.provider1 = (ProtocolProviderService)JabberSlickFixture.bc.getService(jabberProviderRefs[0]);
        TestAccountUninstallation.assertTrue((String)("The Jabber provider did not restore its own reference to the provider that we just reinstalled (URI=" + this.fixture.userID1 + ")"), (!this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()) != null ? 1 : 0) != 0);
    }

    public void testUninstallAccount() {
        TestAccountUninstallation.assertFalse((String)"No installed accounts found", (boolean)this.fixture.providerFactory.getRegisteredAccounts().isEmpty());
        TestAccountUninstallation.assertNotNull((String)("Found no provider corresponding to URI " + this.fixture.userID1), (Object)this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()));
        TestAccountUninstallation.assertTrue((String)("Failed to remove a provider corresponding to URI " + this.fixture.userID1), (boolean)this.fixture.providerFactory.uninstallAccount(this.fixture.provider1.getAccountID()));
        TestAccountUninstallation.assertTrue((String)("Failed to remove a provider corresponding to URI " + this.fixture.userID2), (boolean)this.fixture.providerFactory.uninstallAccount(this.fixture.provider2.getAccountID()));
        TestAccountUninstallation.assertTrue((String)("Failed to remove a provider corresponding to URI " + this.fixture.userID3), (boolean)this.fixture.providerFactory.uninstallAccount(this.fixture.provider3.getAccountID()));
        ServiceReference[] jabberProviderRefs = null;
        try {
            jabberProviderRefs = JabberSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(PROTOCOL_NAME=Jabber)");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was still regged as an osgi service for Jabber URI:" + this.fixture.userID1 + "After it was explicitly uninstalled"), (jabberProviderRefs == null || jabberProviderRefs.length == 0 ? 1 : 0) != 0);
        TestAccountUninstallation.assertTrue((String)("The Jabber provider factory kept a reference to the provider we just uninstalled (uri=" + this.fixture.userID1 + ")"), (this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()) == null ? 1 : 0) != 0);
    }
}

