/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts.configform;

import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsActivator;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsConnectionImpl;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsServiceImpl;
import net.java.sip.communicator.impl.googlecontacts.configform.GoogleContactsConfigForm;
import net.java.sip.communicator.impl.googlecontacts.configform.Resources;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsConnection;

public class GoogleContactsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private final GoogleContactsServiceImpl googleService = GoogleContactsActivator.getGoogleContactsService();

    public void addAccount(GoogleContactsConnection cnx, boolean enabled, String prefix) {
        if (cnx != null) {
            GoogleContactsConnectionImpl cnxImpl = (GoogleContactsConnectionImpl)cnx;
            cnxImpl.setEnabled(enabled);
            cnxImpl.setPrefix(prefix);
            this.googleService.getAccounts().add(cnxImpl);
        }
    }

    public void removeAccount(String login) {
        Iterator<GoogleContactsConnectionImpl> it = this.googleService.getAccounts().iterator();
        while (it.hasNext()) {
            GoogleContactsConnection cnx = it.next();
            if (!cnx.getLogin().equals(login)) continue;
            it.remove();
            return;
        }
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Resources.getString("impl.googlecontacts.ENABLED");
            }
            case 1: {
                return Resources.getString("impl.googlecontacts.ACCOUNT_NAME");
            }
            case 2: {
                return Resources.getString("impl.googlecontacts.PREFIX");
            }
        }
        throw new IllegalArgumentException("column not found");
    }

    @Override
    public int getRowCount() {
        return this.googleService.getAccounts().size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return new Boolean(this.getAccountAt(row).isEnabled());
            }
            case 1: {
                return this.getAccountAt(row).getLogin();
            }
            case 2: {
                return this.getAccountAt(row).getPrefix();
            }
        }
        throw new IllegalArgumentException("column not found");
    }

    public GoogleContactsConnectionImpl getAccountAt(int row) {
        if (row < 0 || row >= this.googleService.getAccounts().size()) {
            throw new IllegalArgumentException("row not found");
        }
        return this.googleService.getAccounts().get(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0 && columnIndex != 2) {
            throw new IllegalArgumentException("non editable column!");
        }
        GoogleContactsConfigForm.RefreshContactSourceThread th = null;
        GoogleContactsConnectionImpl cnx = this.getAccountAt(rowIndex);
        if (columnIndex == 0) {
            th = cnx.isEnabled() ? new GoogleContactsConfigForm.RefreshContactSourceThread(cnx, null) : new GoogleContactsConfigForm.RefreshContactSourceThread(null, cnx);
            cnx.setEnabled(!cnx.isEnabled());
            th.start();
        } else if (columnIndex == 2) {
            cnx.setPrefix(aValue.toString());
        }
    }
}

