/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.gdata.data.ICategory;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Category
extends Element
implements ICategory {
    public static final ElementKey<Void, Category> KEY = ElementKey.of(new QName(Namespaces.atomNs, "category"), Category.class);
    public static final AttributeKey<String> SCHEME = AttributeKey.of(new QName("scheme"));
    public static final AttributeKey<String> TERM = AttributeKey.of(new QName("term"));
    public static final AttributeKey<String> LABEL = AttributeKey.of(new QName("label"));
    public static final AttributeKey<String> XML_LANG = AttributeKey.of(new QName(Namespaces.xmlNs, "lang"));
    private static final Pattern categoryPattern = Pattern.compile("(\\{([^\\}]+)\\})?(.+)");

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY).setCardinality(ElementMetadata.Cardinality.SET);
        builder.addAttribute(XML_LANG);
        builder.addAttribute(SCHEME);
        builder.addAttribute(TERM).setRequired(true);
        builder.addAttribute(LABEL);
    }

    public Category() {
        super(KEY);
    }

    protected Category(ElementKey<?, ? extends Category> key) {
        super(key);
    }

    protected Category(ElementKey<?, ? extends Category> key, Element source) {
        super(key, source);
    }

    public Category(String category) {
        this();
        Matcher m = categoryPattern.matcher(category);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid category: " + category);
        }
        if (m.group(2) != null) {
            this.setScheme(m.group(2));
        }
        this.setTerm(m.group(3));
    }

    public Category(String scheme, String term) {
        this(scheme, term, null);
    }

    public Category(String scheme, String term, String label) {
        this();
        this.setScheme(scheme);
        if (term == null) {
            throw new NullPointerException("Invalid term. Cannot be null");
        }
        this.setTerm(term);
        this.setLabel(label);
    }

    @Override
    public Category lock() {
        return (Category)super.lock();
    }

    @Override
    public String getScheme() {
        return this.getAttributeValue(SCHEME);
    }

    public void setScheme(String scheme) {
        this.setAttributeValue(SCHEME, (Object)scheme);
    }

    @Override
    public String getTerm() {
        return this.getAttributeValue(TERM);
    }

    public void setTerm(String term) {
        Preconditions.checkNotNull(term, "Null category term");
        this.setAttributeValue(TERM, (Object)term);
    }

    @Override
    public String getLabel() {
        return this.getAttributeValue(LABEL);
    }

    public void setLabel(String label) {
        this.setAttributeValue(LABEL, (Object)label);
    }

    public String getLabelLang() {
        return this.getAttributeValue(XML_LANG);
    }

    public void setLabelLang(String lang) {
        this.setAttributeValue(XML_LANG, (Object)lang);
    }

    @Override
    protected Element narrow(ElementMetadata<?, ?> meta, ValidationContext vc) {
        return this.adapt(this, meta, this.getScheme());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String scheme = this.getScheme();
        if (scheme != null) {
            sb.append("{");
            sb.append(scheme);
            sb.append("}");
        }
        sb.append(this.getTerm());
        String label = this.getLabel();
        if (label != null) {
            sb.append("(");
            sb.append(label);
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category)obj;
        String scheme = this.getScheme();
        if (scheme == null ? other.getScheme() != null : !scheme.equals(other.getScheme())) {
            return false;
        }
        String term = this.getTerm();
        if (term == null ? other.getTerm() != null : !term.equals(other.getTerm())) {
            return false;
        }
        String label = this.getLabel();
        return !(label == null ? other.getLabel() != null : !label.equals(other.getLabel()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        String scheme = this.getScheme();
        result = 37 * result + (scheme != null ? scheme.hashCode() : 0);
        String term = this.getTerm();
        result = 37 * result + (term != null ? term.hashCode() : 0);
        String label = this.getLabel();
        result = 37 * result + (label != null ? label.hashCode() : 0);
        return result;
    }
}

