/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gdata.model.AdaptationRegistry;
import com.google.gdata.model.AdaptationRegistryFactory;
import com.google.gdata.model.Attribute;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementTransform;
import com.google.gdata.model.ElementValidator;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataImpl;
import com.google.gdata.model.MetadataValidator;
import com.google.gdata.model.QName;
import com.google.gdata.model.Schema;
import com.google.gdata.model.TransformKey;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.VirtualElementHolder;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.wireformats.ContentCreationException;
import com.google.gdata.wireformats.ObjectConverter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class ElementMetadataImpl<D, E extends Element>
extends MetadataImpl<D>
implements ElementMetadata<D, E> {
    private static final ElementValidator DEFAULT_VALIDATOR = new MetadataValidator();
    private final ElementKey<D, E> elemKey;
    private final ElementKey<D, E> sourceKey;
    private final ElementMetadata.Cardinality cardinality;
    private final boolean isContentRequired;
    private final ElementValidator validator;
    private final Object properties;
    private final VirtualElementHolder virtualElementHolder;
    private final boolean isFlattened;
    private final ImmutableMap<QName, AttributeKey<?>> attributes;
    private final ImmutableMap<QName, AttributeKey<?>> renamedAttributes;
    private final ImmutableMap<QName, ElementKey<?, ?>> elements;
    private final ImmutableMap<QName, ElementKey<?, ?>> renamedElements;
    private final AdaptationRegistry adaptations;
    private Collection<XmlNamespace> referencedNamespaces = null;

    ElementMetadataImpl(Schema schema, ElementTransform transform, ElementKey<?, ?> parent, ElementKey<D, E> key, MetadataContext context) {
        super(schema, transform, parent, key, context);
        ElementKey transformSourceKey;
        this.elemKey = key;
        TransformKey transformSource = transform.getSource();
        this.sourceKey = transformSource != null ? ((transformSourceKey = ElementKey.of(transformSource.getKey().getId(), key.getDatatype(), key.getElementType())).equals(this.elemKey) ? this.elemKey : transformSourceKey) : this.elemKey;
        transform = ElementTransform.mergeSource(schema, key, transform, context);
        this.cardinality = ElementMetadataImpl.firstNonNull(transform.getCardinality(), ElementMetadata.Cardinality.SINGLE);
        this.isContentRequired = ElementMetadataImpl.firstNonNull(transform.getContentRequired(), true);
        this.validator = ElementMetadataImpl.firstNonNull(transform.getValidator(), DEFAULT_VALIDATOR);
        this.properties = transform.getProperties();
        this.virtualElementHolder = transform.getVirtualElementHolder();
        this.isFlattened = transform.isFlattened();
        this.attributes = this.getAttributes(transform.getAttributes().values());
        this.renamedAttributes = this.getRenamedAttributes();
        this.elements = this.getElements(transform.getElements().values());
        this.renamedElements = this.getRenamedElements();
        this.adaptations = transform.getAdaptations().isEmpty() ? null : AdaptationRegistryFactory.create(schema, transform);
    }

    private ImmutableMap<QName, AttributeKey<?>> getAttributes(Collection<ElementCreatorImpl.AttributeInfo> infos) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ElementCreatorImpl.AttributeInfo info : infos) {
            builder.put((Object)info.key.getId(), info.key);
        }
        return builder.build();
    }

    private ImmutableMap<QName, AttributeKey<?>> getRenamedAttributes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AttributeKey key : this.attributes.values()) {
            AttributeMetadata bound = this.bindAttribute(key);
            QName boundName = bound.getName();
            if (boundName.equals(key.getId())) continue;
            builder.put((Object)boundName, (Object)key);
        }
        return builder.build();
    }

    private ImmutableMap<QName, ElementKey<?, ?>> getElements(Collection<ElementCreatorImpl.ElementInfo> infos) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ElementCreatorImpl.ElementInfo info : infos) {
            builder.put((Object)info.key.getId(), info.key);
        }
        return builder.build();
    }

    private ImmutableMap<QName, ElementKey<?, ?>> getRenamedElements() {
        LinkedHashMap renamed = Maps.newLinkedHashMap();
        for (ElementKey key : this.elements.values()) {
            ElementTransform transform = this.schema.getTransform(this.sourceKey, key, this.context);
            QName childName = transform.getName();
            if (childName == null || childName.equals(key.getId()) || renamed.containsKey(childName)) continue;
            renamed.put(childName, key);
        }
        return ImmutableMap.copyOf((Map)renamed);
    }

    @Override
    public ElementKey<?, ?> adapt(String kind) {
        return this.adaptations != null ? this.adaptations.getAdaptation(kind) : null;
    }

    @Override
    public boolean isDeclared(AttributeKey<?> key) {
        return this.attributes.containsKey((Object)key.getId());
    }

    @Override
    public AttributeKey<?> findAttribute(QName id) {
        AttributeKey attKey;
        if (!this.renamedAttributes.isEmpty() && (attKey = (AttributeKey)this.renamedAttributes.get((Object)id)) != null) {
            return attKey;
        }
        if (!this.attributes.isEmpty()) {
            attKey = (AttributeKey)this.attributes.get((Object)id);
            if (attKey != null) {
                return attKey;
            }
            if (id.matchesAnyNamespace()) {
                for (Map.Entry attrEntry : this.attributes.entrySet()) {
                    if (!id.matches((QName)attrEntry.getKey())) continue;
                    return (AttributeKey)attrEntry.getValue();
                }
            } else if (!id.matchesAnyLocalName() && (attKey = (AttributeKey)this.attributes.get((Object)this.toWildcardLocalName(id))) != null) {
                return AttributeKey.of(id, attKey.getDatatype());
            }
        }
        if (this.adaptations != null && (attKey = this.adaptations.findAttribute(id)) != null) {
            return attKey;
        }
        return null;
    }

    @Override
    public boolean isDeclared(ElementKey<?, ?> element) {
        return this.elements.containsKey((Object)element.getId());
    }

    @Override
    public ElementKey<?, ?> findElement(QName id) {
        ElementKey childKey;
        if (!this.renamedElements.isEmpty() && (childKey = (ElementKey)this.renamedElements.get((Object)id)) != null) {
            return childKey;
        }
        if (!this.elements.isEmpty()) {
            childKey = (ElementKey)this.elements.get((Object)id);
            if (childKey != null) {
                return childKey;
            }
            if (id.matchesAnyNamespace()) {
                for (Map.Entry elemEntry : this.elements.entrySet()) {
                    if (!id.matches((QName)elemEntry.getKey())) continue;
                    return (ElementKey)elemEntry.getValue();
                }
            } else if (!id.matchesAnyLocalName() && (childKey = (ElementKey)this.elements.get((Object)this.toWildcardLocalName(id))) != null) {
                return ElementKey.of(id, childKey.getDatatype(), childKey.getElementType());
            }
        }
        if (this.adaptations != null && (childKey = this.adaptations.findElement(id)) != null) {
            return childKey;
        }
        return null;
    }

    @Override
    public ElementMetadata<D, E> bind(MetadataContext context) {
        return this.schema.bind(this.parent, this.elemKey, context);
    }

    @Override
    public ElementKey<D, E> getKey() {
        return this.elemKey;
    }

    @Override
    public ElementMetadata.Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public boolean isContentRequired() {
        return this.isContentRequired;
    }

    @Override
    public boolean isReferenced() {
        return this.isVisible();
    }

    @Override
    public boolean isSelected(Element e) {
        return this.isVisible();
    }

    @Override
    public boolean isFlattened() {
        return this.isFlattened;
    }

    @Override
    public Object getProperties() {
        return this.properties;
    }

    @Override
    public ElementValidator getValidator() {
        return this.validator;
    }

    @Override
    public void validate(ValidationContext vc, Element e) {
        if (this.validator != null) {
            this.validator.validate(vc, e, this);
        }
    }

    public Iterator<Attribute> getAttributeIterator(Element element) {
        return element.getAttributeIterator(this);
    }

    @Override
    public ImmutableCollection<AttributeKey<?>> getAttributes() {
        return this.attributes.values();
    }

    @Override
    public <K> AttributeMetadata<K> bindAttribute(AttributeKey<K> key) {
        return this.schema.bind(this.sourceKey, key, this.context);
    }

    public Iterator<Element> getElementIterator(Element element) {
        return element.getElementIterator(this);
    }

    @Override
    public ImmutableCollection<ElementKey<?, ?>> getElements() {
        return this.elements.values();
    }

    @Override
    public <K, L extends Element> ElementMetadata<K, L> bindElement(ElementKey<K, L> key) {
        return this.schema.bind(this.sourceKey, key, this.context);
    }

    @Override
    public Object generateValue(Element element, ElementMetadata<?, ?> metadata) {
        Object result = super.generateValue(element, metadata);
        if (result == null) {
            result = element.getTextValue(this.elemKey);
        }
        return result;
    }

    @Override
    public void parseValue(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
        if (!super.parse(element, metadata, value)) {
            element.setTextValue(ObjectConverter.getValue(value, this.elemKey.getDatatype()));
        }
    }

    @Override
    public ElementMetadata.SingleVirtualElement getSingleVirtualElement() {
        if (this.cardinality != ElementMetadata.Cardinality.SINGLE) {
            return null;
        }
        if (this.virtualElementHolder != null) {
            return this.virtualElementHolder.getSingleVirtualElement();
        }
        return null;
    }

    @Override
    public ElementMetadata.MultipleVirtualElement getMultipleVirtualElement() {
        if (this.cardinality == ElementMetadata.Cardinality.SINGLE) {
            return null;
        }
        if (this.virtualElementHolder != null) {
            return this.virtualElementHolder.getMultipleVirtualElement();
        }
        return null;
    }

    @Override
    public E createElement() throws ContentCreationException {
        return Element.createElement(this.elemKey);
    }

    @Override
    public XmlNamespace getDefaultNamespace() {
        return this.getName().getNs();
    }

    @Override
    public Collection<XmlNamespace> getReferencedNamespaces() {
        if (this.referencedNamespaces == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            HashSet added = Sets.newHashSet();
            ElementMetadataImpl.addReferencedNamespaces(this, (ImmutableSet.Builder<XmlNamespace>)builder, added);
            this.referencedNamespaces = builder.build();
        }
        return this.referencedNamespaces;
    }

    private static void addReferencedNamespaces(ElementMetadata<?, ?> metadata, ImmutableSet.Builder<XmlNamespace> builder, Set<ElementKey<?, ?>> added) {
        if (added.contains(metadata.getKey())) {
            return;
        }
        added.add(metadata.getKey());
        XmlNamespace elemNs = metadata.getName().getNs();
        if (elemNs != null) {
            builder.add((Object)elemNs);
        }
        for (AttributeKey<?> attributeKey : metadata.getAttributes()) {
            AttributeMetadata<?> attrMetadata = metadata.bindAttribute(attributeKey);
            XmlNamespace attrNs = attrMetadata.getName().getNs();
            if (attrNs == null) continue;
            builder.add((Object)attrNs);
        }
        for (ElementKey elementKey : metadata.getElements()) {
            ElementMetadata childMetadata = metadata.bindElement(elementKey);
            ElementMetadataImpl.addReferencedNamespaces(childMetadata, builder, added);
        }
    }

    private QName toWildcardLocalName(QName id) {
        return new QName(id.getNs(), "*");
    }
}

