/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceConfigurationException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.Attributes;

public class OpenSearchDescriptionDocument
extends ExtensionPoint {
    protected String url;
    protected String format;
    protected String shortName;
    protected String longName;
    protected String description;
    protected String tags;
    protected String image;
    protected String sampleSearch;
    protected String developer;
    protected String contact;
    protected String attribution;
    protected int syndicationRight = 0;
    protected boolean adultContent = false;

    public OpenSearchDescriptionDocument() {
    }

    public OpenSearchDescriptionDocument(OpenSearchDescriptionDocument doc) {
        this.url = doc.url;
        this.format = doc.format;
        this.shortName = doc.shortName;
        this.longName = doc.longName;
        this.description = doc.description;
        this.tags = doc.tags;
        this.image = doc.image;
        this.sampleSearch = doc.sampleSearch;
        this.developer = doc.developer;
        this.contact = doc.contact;
        this.attribution = doc.attribution;
        this.syndicationRight = doc.syndicationRight;
        this.adultContent = doc.adultContent;
    }

    public final String getUrl() {
        return this.url;
    }

    public void setUrl(String v) {
        this.url = v;
    }

    public final String getFormat() {
        return this.format;
    }

    public void setFormat(String v) {
        this.format = v;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public void setShortName(String v) {
        this.shortName = v;
    }

    public final String getLongName() {
        return this.longName;
    }

    public void setLongName(String v) {
        this.longName = v;
    }

    public final String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public final String getTags() {
        return this.tags;
    }

    public void setTags(String v) {
        this.tags = v;
    }

    public final String getImage() {
        return this.image;
    }

    public void setImage(String v) {
        this.image = v;
    }

    public final String getSampleSearch() {
        return this.sampleSearch;
    }

    public void setSampleSearch(String v) {
        this.sampleSearch = v;
    }

    public final String getDeveloper() {
        return this.developer;
    }

    public void setDeveloper(String v) {
        this.developer = v;
    }

    public final String getContact() {
        return this.contact;
    }

    public void setContact(String v) {
        this.contact = v;
    }

    public final String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String v) {
        this.attribution = v;
    }

    public final int getSyndicationRight() {
        return this.syndicationRight;
    }

    public void setSyndicationRight(int v) {
        this.syndicationRight = v;
    }

    public final boolean getAdultContent() {
        return this.adultContent;
    }

    public void setAdultContent(boolean v) {
        this.adultContent = v;
    }

    public void generate(XmlWriter w) throws IOException {
        String syndicationRightString;
        XmlNamespace openSearchDescNs = Namespaces.getOpenSearchDescNs();
        w.startElement(openSearchDescNs, "OpenSearchDescription", null, null);
        if (this.url != null) {
            w.simpleElement(openSearchDescNs, "Url", null, this.url);
        }
        if (this.format != null) {
            w.simpleElement(openSearchDescNs, "Format", null, this.format);
        }
        if (this.shortName != null) {
            w.simpleElement(openSearchDescNs, "ShortName", null, this.shortName);
        }
        if (this.longName != null) {
            w.simpleElement(openSearchDescNs, "LongName", null, this.longName);
        }
        if (this.description != null) {
            w.simpleElement(openSearchDescNs, "Description", null, this.description);
        }
        if (this.tags != null) {
            w.simpleElement(openSearchDescNs, "Tags", null, this.tags);
        }
        if (this.image != null) {
            w.simpleElement(openSearchDescNs, "Image", null, this.image);
        }
        if (this.sampleSearch != null) {
            w.simpleElement(openSearchDescNs, "SampleSearch", null, this.sampleSearch);
        }
        if (this.developer != null) {
            w.simpleElement(openSearchDescNs, "Developer", null, this.developer);
        }
        if (this.contact != null) {
            w.simpleElement(openSearchDescNs, "Contact", null, this.contact);
        }
        if (this.attribution != null) {
            w.simpleElement(openSearchDescNs, "Attribution", null, this.attribution);
        }
        switch (this.syndicationRight) {
            default: {
                syndicationRightString = "open";
                break;
            }
            case 1: {
                syndicationRightString = "limited";
                break;
            }
            case 2: {
                syndicationRightString = "private";
                break;
            }
            case 3: {
                syndicationRightString = "closed";
            }
        }
        w.simpleElement(openSearchDescNs, "SyndicationRight", null, syndicationRightString);
        if (this.adultContent) {
            w.simpleElement(openSearchDescNs, "AdultContent", null, "true");
        }
        w.endElement(openSearchDescNs, "OpenSearchDescription");
    }

    public void validateConfiguration() throws ServiceConfigurationException {
        if (this.format == null) {
            throw new ServiceConfigurationException(CoreErrorDomain.ERR.missingFormat);
        }
        if (this.shortName == null) {
            throw new ServiceConfigurationException(CoreErrorDomain.ERR.missingShortName);
        }
        if (this.description == null) {
            throw new ServiceConfigurationException(CoreErrorDomain.ERR.missingDescription);
        }
        if (this.tags == null) {
            throw new ServiceConfigurationException(CoreErrorDomain.ERR.missingTags);
        }
        if (this.contact == null) {
            throw new ServiceConfigurationException(CoreErrorDomain.ERR.missingContact);
        }
    }

    public void parse(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
        XmlNamespace openSearchDescNs = Namespaces.getOpenSearchDescNs();
        new XmlParser().parse(reader, (XmlParser.ElementHandler)new Handler(extProfile), openSearchDescNs.getUri(), "OpenSearchDescription");
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super(extProfile, OpenSearchDescriptionDocument.class);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            XmlNamespace openSearchDescNs = Namespaces.getOpenSearchDescNs();
            if (namespace.equals(openSearchDescNs.getUri())) {
                if (localName.equals("Url")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.url);
                    return new UrlHandler();
                }
                if (localName.equals("Format")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.format);
                    return new FormatHandler();
                }
                if (localName.equals("ShortName")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.shortName);
                    return new ShortNameHandler();
                }
                if (localName.equals("LongName")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.longName);
                    return new LongNameHandler();
                }
                if (localName.equals("Description")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.description);
                    return new DescriptionHandler();
                }
                if (localName.equals("Tags")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.tags);
                    return new TagsHandler();
                }
                if (localName.equals("Image")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.image);
                    return new ImageHandler();
                }
                if (localName.equals("SampleSearch")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.sampleSearch);
                    return new SampleSearchHandler();
                }
                if (localName.equals("Developer")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.developer);
                    return new DeveloperHandler();
                }
                if (localName.equals("Contact")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.contact);
                    return new ContactHandler();
                }
                if (localName.equals("Attribution")) {
                    this.ensureNull(OpenSearchDescriptionDocument.this.attribution);
                    return new AttributionHandler();
                }
                if (localName.equals("SyndicationRight")) {
                    return new SyndicationRightHandler();
                }
                if (localName.equals("AdultContent")) {
                    return new AdultContentHandler();
                }
            } else {
                return super.getChildHandler(namespace, localName, attrs);
            }
            return null;
        }

        private void ensureNull(String s) throws ParseException {
            if (s != null) {
                throw new ParseException(CoreErrorDomain.ERR.duplicateValue);
            }
        }

        private class AdultContentHandler
        extends XmlParser.ElementHandler {
            private AdultContentHandler() {
            }

            @Override
            public void processEndElement() {
                if (!(this.value.equals("false") || this.value.equals("FALSE") || this.value.equals("0") || this.value.equals("no") || this.value.equals("NO"))) {
                    OpenSearchDescriptionDocument.this.adultContent = true;
                }
            }
        }

        private class SyndicationRightHandler
        extends XmlParser.ElementHandler {
            private SyndicationRightHandler() {
            }

            @Override
            public void processEndElement() {
                if (this.value.equalsIgnoreCase("open")) {
                    OpenSearchDescriptionDocument.this.syndicationRight = 0;
                } else if (this.value.equalsIgnoreCase("limited")) {
                    OpenSearchDescriptionDocument.this.syndicationRight = 1;
                } else if (this.value.equalsIgnoreCase("private")) {
                    OpenSearchDescriptionDocument.this.syndicationRight = 2;
                } else if (this.value.equalsIgnoreCase("closed")) {
                    OpenSearchDescriptionDocument.this.syndicationRight = 3;
                }
            }
        }

        private class AttributionHandler
        extends XmlParser.ElementHandler {
            private AttributionHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.attribution = this.value;
            }
        }

        private class ContactHandler
        extends XmlParser.ElementHandler {
            private ContactHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.contact = this.value;
            }
        }

        private class DeveloperHandler
        extends XmlParser.ElementHandler {
            private DeveloperHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.developer = this.value;
            }
        }

        private class SampleSearchHandler
        extends XmlParser.ElementHandler {
            private SampleSearchHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.sampleSearch = this.value;
            }
        }

        private class ImageHandler
        extends XmlParser.ElementHandler {
            private ImageHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.image = this.value;
            }
        }

        private class TagsHandler
        extends XmlParser.ElementHandler {
            private TagsHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.tags = this.value;
            }
        }

        private class DescriptionHandler
        extends XmlParser.ElementHandler {
            private DescriptionHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.description = this.value;
            }
        }

        private class LongNameHandler
        extends XmlParser.ElementHandler {
            private LongNameHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.longName = this.value;
            }
        }

        private class ShortNameHandler
        extends XmlParser.ElementHandler {
            private ShortNameHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.shortName = this.value;
            }
        }

        private class FormatHandler
        extends XmlParser.ElementHandler {
            private FormatHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.format = this.value;
            }
        }

        private class UrlHandler
        extends XmlParser.ElementHandler {
            private UrlHandler() {
            }

            @Override
            public void processEndElement() {
                OpenSearchDescriptionDocument.this.url = this.value;
            }
        }
    }

    public static class SyndicationRight {
        public static final int OPEN = 0;
        public static final int LIMITED = 1;
        public static final int PRIVATE = 2;
        public static final int CLOSED = 3;
    }
}

