/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.util.common.base.CharEscapers;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class OAuthUtil {
    private OAuthUtil() {
    }

    public static String getNonce() {
        return Long.toString(System.nanoTime());
    }

    public static String getTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    public static String getSignatureBaseString(String requestUrl, String httpMethod, Map<String, String> baseParameters) throws OAuthException {
        return OAuthUtil.encode(httpMethod.toUpperCase()) + '&' + OAuthUtil.encode(OAuthUtil.normalizeUrl(requestUrl)) + '&' + OAuthUtil.encode(OAuthUtil.normalizeParameters(requestUrl, baseParameters));
    }

    public static String normalizeUrl(String requestUrl) throws OAuthException {
        int index;
        URI uri;
        if (requestUrl == null || requestUrl.length() == 0) {
            throw new OAuthException("Request Url cannot be empty");
        }
        try {
            uri = new URI(requestUrl);
        }
        catch (URISyntaxException e) {
            throw new OAuthException(e);
        }
        String authority = uri.getAuthority();
        String scheme = uri.getScheme();
        if (authority == null || scheme == null) {
            throw new OAuthException("Invalid Request Url");
        }
        authority = authority.toLowerCase();
        if (((scheme = scheme.toLowerCase()).equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443) && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        return scheme + "://" + authority + uri.getRawPath();
    }

    public static String normalizeParameters(String requestUrl, Map<String, String> requestParameters) {
        TreeMap<String, String> alphaParams = new TreeMap<String, String>(requestParameters);
        if (requestUrl.indexOf(63) > 0) {
            Map<String, String> queryParameters = OAuthUtil.parseQuerystring(requestUrl.substring(requestUrl.indexOf(63) + 1));
            alphaParams.putAll(queryParameters);
        }
        StringBuilder paramString = new StringBuilder();
        for (Map.Entry<String, String> e : alphaParams.entrySet()) {
            if (e.getValue().length() == 0) continue;
            if (paramString.length() > 0) {
                paramString.append("&");
            }
            paramString.append(OAuthUtil.encode(e.getKey())).append("=").append(OAuthUtil.encode(e.getValue()));
        }
        return paramString.toString();
    }

    public static Map<String, String> parseQuerystring(String queryString) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString == null || queryString.equals("")) {
            return map;
        }
        for (String param : params = queryString.split("&")) {
            try {
                String[] keyValuePair = param.split("=", 2);
                String name = URLDecoder.decode(keyValuePair[0], "UTF-8");
                if (name == "") continue;
                String value = keyValuePair.length > 1 ? URLDecoder.decode(keyValuePair[1], "UTF-8") : "";
                map.put(name, value);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return map;
    }

    public static String encode(String stringToEncode) {
        return CharEscapers.uriEscaper().escape(stringToEncode).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }
}

