/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import net.kano.joscar.ByteBlock;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.MemoryAttachment;
import org.jetbrains.annotations.Nullable;

public class IncomingMemoryAttachment
extends MemoryAttachment {
    private ByteArrayOutputStream bout;

    public IncomingMemoryAttachment(String id, long length) {
        super(id, length);
        assert (length < Integer.MAX_VALUE);
        this.bout = new ByteArrayOutputStream((int)length);
    }

    public ByteBlock getBuffer() {
        return ByteBlock.wrap(this.bout.toByteArray());
    }

    public ReadableByteChannel openForReading() throws IOException {
        return Channels.newChannel(new ByteArrayInputStream(this.bout.toByteArray()));
    }

    public WritableByteChannel openForWriting() throws IOException {
        return Channels.newChannel(this.bout);
    }

    @Nullable
    public SelectableChannel getSelectableForWriting() {
        return null;
    }
}

