/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public class GroupItem
extends AbstractItemObj {
    private static final int ID_DEFAULT = 0;
    private static final int TYPE_BUDDIES = 200;
    private String name;
    private final int id;
    private int[] buddies;

    public GroupItem(SsiItem item) {
        DefensiveTools.checkNull(item, "item");
        this.name = item.getName();
        this.id = item.getParentId();
        ImmutableTlvChain chain = TlvTools.readChain(item.getData());
        Tlv buddiesTlv = chain.getLastTlv(200);
        if (buddiesTlv != null) {
            ByteBlock buddyBlock = buddiesTlv.getData();
            this.buddies = new int[buddyBlock.getLength() / 2];
            for (int i = 0; i < this.buddies.length; ++i) {
                this.buddies[i] = BinaryTools.getUShort(buddyBlock, i * 2);
            }
        } else {
            this.buddies = null;
        }
        MutableTlvChain extraTlvs = TlvTools.getMutableCopy(chain);
        extraTlvs.removeTlvs(new int[]{200});
        this.addExtraTlvs(extraTlvs);
    }

    public GroupItem(GroupItem other) {
        this(other.name, other.id, other.buddies == null ? null : (int[])other.buddies.clone(), other.copyExtraTlvs());
    }

    public GroupItem(String name, int id) {
        this(name, id, null, null);
    }

    public GroupItem(String name, int id, int[] buddies) {
        this(name, id, buddies, null);
    }

    public GroupItem(String name, int id, int[] buddies, TlvChain extraTlvs) {
        super(extraTlvs);
        DefensiveTools.checkNull(name, "name");
        DefensiveTools.checkRange(id, "id", 0);
        this.name = name;
        this.id = id;
        this.buddies = buddies == null ? null : (int[])buddies.clone();
    }

    public final String getGroupName() {
        return this.name;
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final synchronized int[] getBuddies() {
        return this.buddies == null ? null : (int[])this.buddies.clone();
    }

    public final synchronized void setBuddies(@Nullable int[] buddies) {
        this.buddies = DefensiveTools.getSafeMinArrayCopy(buddies, "buddies", 0);
    }

    public void setGroupName(String name) {
        this.name = name;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain chain = TlvTools.createMutableChain();
        if (this.buddies != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.buddies.length * 2);
            try {
                for (int buddy : this.buddies) {
                    BinaryTools.writeUShort(out, buddy);
                }
            }
            catch (IOException impossible) {
                // empty catch block
            }
            ByteBlock tlvData = ByteBlock.wrap(out.toByteArray());
            chain.addTlv(new Tlv(200, tlvData));
        }
        return this.generateItem(this.name, this.id, 0, 1, chain);
    }

    public synchronized String toString() {
        String buddyStr;
        if (this.buddies != null) {
            StringBuffer buffer = new StringBuffer();
            for (int buddy : this.buddies) {
                buffer.append("0x");
                buffer.append(Integer.toHexString(buddy));
                buffer.append(", ");
            }
            buddyStr = buffer.toString();
        } else {
            buddyStr = "none";
        }
        return "GroupItem for " + this.name + ", groupid=0x" + Integer.toHexString(this.id) + ", buddies: " + buddyStr;
    }
}

