/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.icq.AimStatusEnum;
import net.java.sip.communicator.impl.protocol.icq.ContactGroupIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ContactIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetExtendedAuthorizationsIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ServerStoredContactListIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.VolatileBuddy;
import net.java.sip.communicator.service.protocol.AbstractOperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.service.protocol.icqconstants.IcqStatusEnum;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.InfoData;
import net.kano.joscar.snaccmd.conn.SetExtraInfoCmd;
import net.kano.joscar.snaccmd.error.SnacError;
import net.kano.joscar.snaccmd.loc.GetInfoCmd;
import net.kano.joscar.snaccmd.loc.SetInfoCmd;
import net.kano.joscar.snaccmd.loc.UserInfoCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.GlobalBuddyInfoAdapter;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosServiceListener;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyService;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyServiceListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconService;
import net.kano.joustsim.oscar.oscar.service.info.InfoService;
import net.kano.joustsim.oscar.oscar.service.info.InfoServiceListener;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyAuthorizationListener;
import net.kano.joustsim.oscar.oscar.service.ssi.Group;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableGroup;
import net.kano.joustsim.trust.BuddyCertificateInfo;

public class OperationSetPersistentPresenceIcqImpl
extends AbstractOperationSetPersistentPresence<ProtocolProviderServiceIcqImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetPersistentPresenceIcqImpl.class);
    private static final long ICQ_ONLINE_MASK = 0x1000000L;
    private ContactIcqImpl localContact = null;
    private RegistrationStateListener registrationStateListener = new RegistrationStateListener();
    private JoustSimBuddyServiceListener joustSimBuddySerListener = new JoustSimBuddyServiceListener();
    private JoustSimBosListener joustSimBosListener = new JoustSimBosListener();
    private String currentStatusMessage = "";
    private long currentIcqStatus = -1L;
    private AuthorizationHandler authorizationHandler = null;
    private AuthListener authListener = new AuthListener();
    private Timer presenceQueryTimer = null;
    private long PRESENCE_QUERY_INTERVAL = 120000L;
    private OperationSetExtendedAuthorizationsIcqImpl opSetExtendedAuthorizations = null;
    private final List<String> buddiesSeenAvailable = new Vector<String>();
    private final List<PresenceStatus> supportedPresenceStatusSet = new ArrayList<PresenceStatus>();
    private static final Map<PresenceStatus, Long> scToIcqStatusMappings = new Hashtable<PresenceStatus, Long>();
    private static final Map<PresenceStatus, Long> scToAimStatusMappings;
    private ServerStoredContactListIcqImpl ssContactList = null;

    protected OperationSetPersistentPresenceIcqImpl(ProtocolProviderServiceIcqImpl icqProvider, String uin) {
        super((ProtocolProviderService)icqProvider);
        this.ssContactList = new ServerStoredContactListIcqImpl(this, icqProvider);
        ((ProtocolProviderServiceIcqImpl)this.parentProvider).addRegistrationStateChangeListener(this.registrationStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PresenceStatus queryContactStatus(String contactIdentifier) throws IllegalStateException, IllegalArgumentException {
        this.assertConnected();
        StatusResponseRetriever responseRetriever = new StatusResponseRetriever();
        GetInfoCmd getInfoCmd = new GetInfoCmd(6L, contactIdentifier);
        ((ProtocolProviderServiceIcqImpl)this.parentProvider).getAimConnection().getInfoService().getOscarConnection().sendSnacRequest(getInfoCmd, responseRetriever);
        StatusResponseRetriever statusResponseRetriever = responseRetriever;
        synchronized (statusResponseRetriever) {
            try {
                responseRetriever.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.statusLongToPresenceStatus(responseRetriever.status);
    }

    private PresenceStatus statusLongToPresenceStatus(long icqStatus) {
        if (((ProtocolProviderServiceIcqImpl)this.parentProvider).USING_ICQ) {
            if (icqStatus == -1L) {
                return IcqStatusEnum.OFFLINE;
            }
            if ((icqStatus & 0x100L) != 0L) {
                return IcqStatusEnum.INVISIBLE;
            }
            if ((icqStatus & 2L) != 0L) {
                return IcqStatusEnum.DO_NOT_DISTURB;
            }
            if ((icqStatus & 0x10L) != 0L) {
                return IcqStatusEnum.OCCUPIED;
            }
            if ((icqStatus & 4L) != 0L) {
                return IcqStatusEnum.NOT_AVAILABLE;
            }
            if ((icqStatus & 1L) != 0L) {
                return IcqStatusEnum.AWAY;
            }
            if ((icqStatus & 0x20L) != 0L) {
                return IcqStatusEnum.FREE_FOR_CHAT;
            }
            return IcqStatusEnum.ONLINE;
        }
        if (icqStatus == -1L) {
            return AimStatusEnum.OFFLINE;
        }
        if ((icqStatus & 0x100L) != 0L) {
            return AimStatusEnum.INVISIBLE;
        }
        if ((icqStatus & 1L) != 0L) {
            return AimStatusEnum.AWAY;
        }
        return AimStatusEnum.ONLINE;
    }

    private long presenceStatusToStatusLong(PresenceStatus status) {
        if (((ProtocolProviderServiceIcqImpl)this.parentProvider).USING_ICQ) {
            return scToIcqStatusMappings.get(status);
        }
        return scToAimStatusMappings.get(status);
    }

    public void subscribe(String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        this.ssContactList.addContact(contactIdentifier);
    }

    public ContactIcqImpl createVolatileContact(String uin) {
        return this.ssContactList.createVolatileContact(new Screenname(uin));
    }

    public Contact createUnresolvedContact(String address, String persistentData, ContactGroup parentGroup) throws IllegalArgumentException {
        if (!(parentGroup instanceof ContactGroupIcqImpl)) {
            throw new IllegalArgumentException("Argument is not an icq contact group (group=" + parentGroup + ")");
        }
        ContactIcqImpl contact = this.ssContactList.createUnresolvedContact((ContactGroupIcqImpl)parentGroup, new Screenname(address));
        contact.setPersistentData(persistentData);
        return contact;
    }

    public Contact createUnresolvedContact(String address, String persistentData) {
        return this.createUnresolvedContact(address, persistentData, this.getServerStoredContactListRoot());
    }

    public ContactGroup createUnresolvedContactGroup(String groupUID, String persistentData, ContactGroup parentGroup) {
        return this.ssContactList.createUnresolvedContactGroup(groupUID);
    }

    public void subscribe(ContactGroup parent, String contactIdentifier) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(parent instanceof ContactGroupIcqImpl)) {
            throw new IllegalArgumentException("Argument is not an icq contact group (group=" + parent + ")");
        }
        this.ssContactList.addContact((ContactGroupIcqImpl)parent, contactIdentifier);
    }

    public void unsubscribe(Contact contact) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(contact instanceof ContactIcqImpl)) {
            throw new IllegalArgumentException("Argument is not an icq contact (contact=" + contact + ")");
        }
        ContactIcqImpl contactIcqImpl = (ContactIcqImpl)contact;
        ContactGroupIcqImpl contactGroup = this.ssContactList.findContactGroup(contactIcqImpl);
        if (contactGroup == null) {
            throw new IllegalArgumentException("The specified contact was not found on the local contact/subscription list: " + contact);
        }
        if (!contactIcqImpl.isPersistent()) {
            contactGroup.removeContact(contactIcqImpl);
            this.fireSubscriptionEvent((Contact)contactIcqImpl, contactGroup, 2);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Going to remove contact from ss-list : " + contact));
        }
        if (!contactGroup.isPersistent() && contactIcqImpl.getJoustSimBuddy().isAwaitingAuthorization()) {
            ContactGroupIcqImpl origParent = this.ssContactList.findGroup(contactIcqImpl.getJoustSimBuddy());
            if (origParent != null) {
                origParent.getJoustSimSourceGroup().deleteBuddy(contactIcqImpl.getJoustSimBuddy());
            }
        } else {
            MutableGroup joustSimContactGroup = contactGroup.getJoustSimSourceGroup();
            joustSimContactGroup.deleteBuddy(contactIcqImpl.getJoustSimBuddy());
        }
    }

    public Contact findContactByID(String contactID) {
        return this.ssContactList.findContactByScreenName(contactID);
    }

    public void publishPresenceStatus(PresenceStatus status, String statusMessage) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        this.assertConnected();
        if (!(status instanceof IcqStatusEnum) && !(status instanceof AimStatusEnum)) {
            throw new IllegalArgumentException(status + " is not a valid ICQ/AIM status");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will set status: " + status));
        }
        MainBosService bosService = ((ProtocolProviderServiceIcqImpl)this.parentProvider).getAimConnection().getBosService();
        if (!((ProtocolProviderServiceIcqImpl)this.parentProvider).USING_ICQ) {
            if (status.equals((Object)AimStatusEnum.AWAY)) {
                if (this.getPresenceStatus().equals((Object)AimStatusEnum.INVISIBLE)) {
                    bosService.setVisibleStatus(true);
                }
                bosService.getOscarConnection().sendSnac(new SetInfoCmd(new InfoData(null, "I'm away!", null, null)));
            } else if (status.equals((Object)AimStatusEnum.INVISIBLE)) {
                if (this.getPresenceStatus().equals((Object)AimStatusEnum.AWAY)) {
                    bosService.getOscarConnection().sendSnac(new SetInfoCmd(new InfoData(null, "", null, null)));
                }
                bosService.setVisibleStatus(false);
            } else if (status.equals((Object)AimStatusEnum.ONLINE)) {
                if (this.getPresenceStatus().equals((Object)AimStatusEnum.INVISIBLE)) {
                    bosService.setVisibleStatus(true);
                } else if (this.getPresenceStatus().equals((Object)AimStatusEnum.AWAY)) {
                    bosService.getOscarConnection().sendSnac(new SetInfoCmd(new InfoData(null, "", null, null)));
                }
            }
        } else {
            long icqStatus = this.presenceStatusToStatusLong(status);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Will set status: " + status + " long=" + icqStatus));
            }
            bosService.getOscarConnection().sendSnac(new SetExtraInfoCmd(icqStatus));
            if (status.equals((Object)IcqStatusEnum.AWAY)) {
                ((ProtocolProviderServiceIcqImpl)this.parentProvider).getAimConnection().getInfoService().setAwayMessage(statusMessage);
            } else {
                bosService.setStatusMessage(statusMessage);
            }
        }
        this.queryContactStatus(((ProtocolProviderServiceIcqImpl)this.parentProvider).getAimConnection().getScreenname().getFormatted());
    }

    public String getCurrentStatusMessage() {
        return this.currentStatusMessage;
    }

    public Contact getLocalContact() {
        return this.localContact;
    }

    public void createServerStoredContactGroup(ContactGroup parent, String groupName) {
        this.assertConnected();
        if (!parent.canContainSubgroups()) {
            throw new IllegalArgumentException("The specified contact group cannot contain child groups. Group:" + parent);
        }
        this.ssContactList.createGroup(groupName);
    }

    public void removeServerStoredContactGroup(ContactGroup group) {
        this.assertConnected();
        if (!(group instanceof ContactGroupIcqImpl)) {
            throw new IllegalArgumentException("The specified group is not an icq contact group: " + group);
        }
        this.ssContactList.removeGroup((ContactGroupIcqImpl)group);
    }

    public void renameServerStoredContactGroup(ContactGroup group, String newName) {
        this.assertConnected();
        if (!(group instanceof ContactGroupIcqImpl)) {
            throw new IllegalArgumentException("The specified group is not an icq contact group: " + group);
        }
        this.ssContactList.renameGroup((ContactGroupIcqImpl)group, newName);
    }

    public void moveContactToGroup(Contact contactToMove, ContactGroup newParent) {
        this.assertConnected();
        if (!(contactToMove instanceof ContactIcqImpl)) {
            throw new IllegalArgumentException("The specified contact is not an icq contact." + contactToMove);
        }
        if (!(newParent instanceof ContactGroupIcqImpl)) {
            throw new IllegalArgumentException("The specified group is not an icq contact group." + newParent);
        }
        this.ssContactList.moveContact((ContactIcqImpl)contactToMove, (ContactGroupIcqImpl)newParent);
    }

    ServerStoredContactListIcqImpl getServerStoredContactList() {
        return this.ssContactList;
    }

    public PresenceStatus getPresenceStatus() {
        return this.statusLongToPresenceStatus(this.currentIcqStatus);
    }

    public Iterator<PresenceStatus> getSupportedStatusSet() {
        if (this.supportedPresenceStatusSet.size() == 0) {
            if (((ProtocolProviderServiceIcqImpl)this.parentProvider).USING_ICQ) {
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.ONLINE);
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.DO_NOT_DISTURB);
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.FREE_FOR_CHAT);
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.NOT_AVAILABLE);
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.OCCUPIED);
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.AWAY);
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.INVISIBLE);
                this.supportedPresenceStatusSet.add((PresenceStatus)IcqStatusEnum.OFFLINE);
            } else {
                this.supportedPresenceStatusSet.add(AimStatusEnum.ONLINE);
                this.supportedPresenceStatusSet.add(AimStatusEnum.AWAY);
                this.supportedPresenceStatusSet.add(AimStatusEnum.INVISIBLE);
                this.supportedPresenceStatusSet.add(AimStatusEnum.OFFLINE);
            }
        }
        return this.supportedPresenceStatusSet.iterator();
    }

    public void setAuthorizationHandler(AuthorizationHandler handler) {
        this.authorizationHandler = handler;
        ((ProtocolProviderServiceIcqImpl)this.parentProvider).getAimConnection().getSsiService().addBuddyAuthorizationListener(this.authListener);
    }

    private void assertConnected() throws IllegalStateException {
        if (this.parentProvider == null) {
            throw new IllegalStateException("The icq provider must be non-null and signed on the ICQ service before being able to communicate.");
        }
        if (!((ProtocolProviderServiceIcqImpl)this.parentProvider).isRegistered()) {
            throw new IllegalStateException("The icq provider must be signed on the ICQ service before being able to communicate.");
        }
    }

    public ContactGroup getServerStoredContactListRoot() {
        return this.ssContactList.getRootGroup();
    }

    public void addServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.addGroupListener(listener);
    }

    public void removeServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        this.ssContactList.removeGroupListener(listener);
    }

    void fireProviderPresenceStatusChangeEvent(long oldStatusL, long newStatusL) {
        PresenceStatus newStatus;
        PresenceStatus oldStatus = this.statusLongToPresenceStatus(oldStatusL);
        if (oldStatus.equals((Object)(newStatus = this.statusLongToPresenceStatus(newStatusL)))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignored prov stat. change evt. old==new = " + oldStatus));
            } else {
                this.fireProviderStatusChangeEvent(oldStatus, newStatus);
            }
        }
    }

    static {
        scToIcqStatusMappings.put((PresenceStatus)IcqStatusEnum.AWAY, 1L);
        scToIcqStatusMappings.put((PresenceStatus)IcqStatusEnum.DO_NOT_DISTURB, 2L);
        scToIcqStatusMappings.put((PresenceStatus)IcqStatusEnum.FREE_FOR_CHAT, 32L);
        scToIcqStatusMappings.put((PresenceStatus)IcqStatusEnum.INVISIBLE, 256L);
        scToIcqStatusMappings.put((PresenceStatus)IcqStatusEnum.NOT_AVAILABLE, 4L);
        scToIcqStatusMappings.put((PresenceStatus)IcqStatusEnum.OCCUPIED, 16L);
        scToIcqStatusMappings.put((PresenceStatus)IcqStatusEnum.ONLINE, 0x1000000L);
        scToAimStatusMappings = new Hashtable<PresenceStatus, Long>();
        scToAimStatusMappings.put(AimStatusEnum.AWAY, 1L);
        scToAimStatusMappings.put(AimStatusEnum.INVISIBLE, 256L);
        scToAimStatusMappings.put(AimStatusEnum.ONLINE, 0x1000000L);
    }

    private class AwayMessageListener
    implements InfoServiceListener {
        private AwayMessageListener() {
        }

        @Override
        public void handleAwayMessage(InfoService service, Screenname buddy, String awayMessage) {
            ContactIcqImpl sourceContact = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactByScreenName(buddy.getFormatted());
            if (sourceContact != null) {
                sourceContact.setStatusMessage(awayMessage);
            }
        }

        @Override
        public void handleUserProfile(InfoService service, Screenname buddy, String userInfo) {
        }

        @Override
        public void handleCertificateInfo(InfoService service, Screenname buddy, BuddyCertificateInfo certInfo) {
        }

        @Override
        public void handleInvalidCertificates(InfoService service, Screenname buddy, CertificateInfo origCertInfo, Throwable ex) {
        }

        @Override
        public void handleDirectoryInfo(InfoService service, Screenname buddy, DirInfo dirInfo) {
        }
    }

    private class AwaitingAuthorizationContactsPresenceTimer
    extends TimerTask {
        private AwaitingAuthorizationContactsPresenceTimer() {
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Running status retreiver for AwaitingAuthorizationContacts");
            }
            Iterator groupsIter = OperationSetPersistentPresenceIcqImpl.this.getServerStoredContactListRoot().subgroups();
            while (groupsIter.hasNext()) {
                ContactGroup group = (ContactGroup)groupsIter.next();
                Iterator contactsIter = group.contacts();
                while (contactsIter.hasNext()) {
                    PresenceStatus oldStatus;
                    String sourceContactAddress;
                    PresenceStatus newStatus;
                    ContactIcqImpl sourceContact = (ContactIcqImpl)((Object)contactsIter.next());
                    if (!sourceContact.getJoustSimBuddy().isAwaitingAuthorization() || (newStatus = OperationSetPersistentPresenceIcqImpl.this.queryContactStatus(sourceContactAddress = sourceContact.getAddress())).equals((Object)(oldStatus = sourceContact.getPresenceStatus()))) continue;
                    sourceContact.updatePresenceStatus(newStatus);
                    OperationSetPersistentPresenceIcqImpl.this.fireContactPresenceStatusChangeEvent((Contact)sourceContact, sourceContact.getParentContactGroup(), oldStatus, newStatus);
                    if (newStatus.equals((Object)IcqStatusEnum.OFFLINE) || OperationSetPersistentPresenceIcqImpl.this.buddiesSeenAvailable.contains(sourceContactAddress)) continue;
                    OperationSetPersistentPresenceIcqImpl.this.buddiesSeenAvailable.add(sourceContactAddress);
                    try {
                        AuthorizationRequest req = new AuthorizationRequest();
                        req.setReason("I'm resending my request. Please authorize me!");
                        OperationSetPersistentPresenceIcqImpl.this.opSetExtendedAuthorizations.reRequestAuthorization(req, (Contact)sourceContact);
                    }
                    catch (OperationFailedException ex) {
                        logger.error((Object)"failed to reRequestAuthorization", (Throwable)ex);
                    }
                }
            }
        }
    }

    private class IconUpdateListener
    implements IconRequestListener {
        private IconUpdateListener() {
        }

        @Override
        public void buddyIconCleared(IconService iconService, Screenname screenname, ExtraInfoData extraInfoData) {
            this.updateBuddyIcon(screenname, null);
        }

        @Override
        public void buddyIconUpdated(IconService iconService, Screenname screenname, ExtraInfoData extraInfoData, ByteBlock byteBlock) {
            if (byteBlock != null) {
                this.updateBuddyIcon(screenname, byteBlock.toByteArray());
            }
        }

        private void updateBuddyIcon(Screenname screenname, byte[] icon) {
            ContactIcqImpl contact = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactByScreenName(screenname.getFormatted());
            if (contact != null) {
                byte[] oldIcon = contact.getImage();
                contact.setImage(icon);
                OperationSetPersistentPresenceIcqImpl.this.fireContactPropertyChangeEvent("Image", (Contact)contact, oldIcon, icon);
            }
        }
    }

    private class AuthListener
    implements BuddyAuthorizationListener {
        private AuthListener() {
        }

        @Override
        public void authorizationDenied(Screenname screenname, String reason) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("authorizationDenied from " + screenname));
            }
            Contact srcContact = OperationSetPersistentPresenceIcqImpl.this.findContactByID(screenname.getFormatted());
            OperationSetPersistentPresenceIcqImpl.this.authorizationHandler.processAuthorizationResponse(new AuthorizationResponse(AuthorizationResponse.REJECT, reason), srcContact);
            try {
                OperationSetPersistentPresenceIcqImpl.this.unsubscribe(srcContact);
            }
            catch (OperationFailedException ex) {
                logger.error((Object)("cannot remove denied contact : " + srcContact), (Throwable)ex);
            }
        }

        @Override
        public void authorizationAccepted(Screenname screenname, String reason) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("authorizationAccepted from " + screenname));
            }
            Contact srcContact = OperationSetPersistentPresenceIcqImpl.this.findContactByID(screenname.getFormatted());
            OperationSetPersistentPresenceIcqImpl.this.authorizationHandler.processAuthorizationResponse(new AuthorizationResponse(AuthorizationResponse.ACCEPT, reason), srcContact);
        }

        @Override
        public void authorizationRequestReceived(Screenname screenname, String reason) {
            Object srcContact;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("authorizationRequestReceived from " + screenname));
            }
            if ((srcContact = OperationSetPersistentPresenceIcqImpl.this.findContactByID(screenname.getFormatted())) == null) {
                srcContact = OperationSetPersistentPresenceIcqImpl.this.createVolatileContact(screenname.getFormatted());
            }
            AuthorizationRequest authRequest = new AuthorizationRequest();
            authRequest.setReason(reason);
            AuthorizationResponse authResponse = OperationSetPersistentPresenceIcqImpl.this.authorizationHandler.processAuthorisationRequest(authRequest, srcContact);
            if (authResponse.getResponseCode() == AuthorizationResponse.IGNORE) {
                return;
            }
            ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getSsiService().replyBuddyAuthorization(screenname, authResponse.getResponseCode() == AuthorizationResponse.ACCEPT, authResponse.getReason());
        }

        @Override
        public boolean authorizationRequired(Screenname screenname, Group parentGroup) {
            AuthorizationRequest authRequest;
            ContactIcqImpl srcContact;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("authorizationRequired from " + screenname));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("finding buddy : " + screenname));
            }
            if ((srcContact = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactByScreenName(screenname.getFormatted())) == null) {
                ContactGroupIcqImpl parent = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactGroup(parentGroup);
                srcContact = OperationSetPersistentPresenceIcqImpl.this.ssContactList.createUnresolvedContact(parent, screenname);
                Buddy buddy = srcContact.getJoustSimBuddy();
                if (buddy instanceof VolatileBuddy) {
                    ((VolatileBuddy)buddy).setAwaitingAuthorization(true);
                }
            }
            if ((authRequest = OperationSetPersistentPresenceIcqImpl.this.authorizationHandler.createAuthorizationRequest((Contact)srcContact)) == null) {
                return false;
            }
            ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getSsiService().sendFutureBuddyAuthorization(screenname, authRequest.getReason());
            ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getSsiService().requestBuddyAuthorization(screenname, authRequest.getReason());
            return true;
        }

        @Override
        public void futureAuthorizationGranted(Screenname screenname, String reason) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("futureAuthorizationGranted from " + screenname));
            }
        }

        @Override
        public void youWereAdded(Screenname screenname) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("youWereAdded from " + screenname));
            }
        }
    }

    private class GlobalBuddyInfoListener
    extends GlobalBuddyInfoAdapter {
        private GlobalBuddyInfoListener() {
        }

        @Override
        public void receivedStatusUpdate(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
            ContactIcqImpl sourceContact;
            String statusMessage = info.getStatusMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buddy=" + buddy));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("info.getAwayMessage()=" + info.getAwayMessage()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("info.getOnlineSince()=" + info.getOnlineSince()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("info.getStatusMessage()=" + statusMessage));
            }
            if ((sourceContact = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactByScreenName(buddy.getFormatted())) != null) {
                sourceContact.setStatusMessage(statusMessage);
            }
        }
    }

    private class JoustSimBuddyServiceListener
    implements BuddyServiceListener {
        private JoustSimBuddyServiceListener() {
        }

        @Override
        public void gotBuddyStatus(BuddyService service, Screenname buddy, FullUserInfo info) {
            Boolean awayStatus;
            ContactIcqImpl sourceContact;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received a status update for buddy=" + buddy));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updated user info is " + info));
            }
            if ((sourceContact = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactByScreenName(buddy.getFormatted())) == null) {
                logger.warn((Object)("No source contact found for screenname=" + buddy));
                return;
            }
            PresenceStatus oldStatus = sourceContact.getPresenceStatus();
            PresenceStatus newStatus = null;
            newStatus = !((ProtocolProviderServiceIcqImpl)((OperationSetPersistentPresenceIcqImpl)OperationSetPersistentPresenceIcqImpl.this).parentProvider).USING_ICQ ? ((awayStatus = info.getAwayStatus()) == null || awayStatus.equals(Boolean.FALSE) ? AimStatusEnum.ONLINE : AimStatusEnum.AWAY) : OperationSetPersistentPresenceIcqImpl.this.statusLongToPresenceStatus(info.getIcqStatus());
            sourceContact.updatePresenceStatus(newStatus);
            ContactGroupIcqImpl parent = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactGroup(sourceContact);
            List<ExtraInfoBlock> extraInfoBlocks = info.getExtraInfoBlocks();
            if (extraInfoBlocks != null) {
                for (ExtraInfoBlock block : extraInfoBlocks) {
                    if (block.getType() != 2) continue;
                    String status = ExtraInfoData.readAvailableMessage(block.getExtraData());
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Status Message is: " + status + "."));
                    }
                    sourceContact.setStatusMessage(status);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Will Dispatch the contact status event.");
            }
            OperationSetPersistentPresenceIcqImpl.this.fireContactPresenceStatusChangeEvent((Contact)sourceContact, parent, oldStatus, newStatus);
        }

        @Override
        public void buddyOffline(BuddyService service, Screenname buddy) {
            ContactIcqImpl sourceContact;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received a status update for buddy=" + buddy));
            }
            if ((sourceContact = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactByScreenName(buddy.getFormatted())) == null) {
                return;
            }
            PresenceStatus oldStatus = sourceContact.getPresenceStatus();
            Object newStatus = null;
            newStatus = ((ProtocolProviderServiceIcqImpl)((OperationSetPersistentPresenceIcqImpl)OperationSetPersistentPresenceIcqImpl.this).parentProvider).USING_ICQ ? IcqStatusEnum.OFFLINE : AimStatusEnum.OFFLINE;
            sourceContact.updatePresenceStatus((PresenceStatus)newStatus);
            ContactGroupIcqImpl parent = OperationSetPersistentPresenceIcqImpl.this.ssContactList.findContactGroup(sourceContact);
            OperationSetPersistentPresenceIcqImpl.this.fireContactPresenceStatusChangeEvent((Contact)sourceContact, parent, oldStatus, (PresenceStatus)newStatus);
        }
    }

    private class JoustSimBosListener
    implements MainBosServiceListener {
        private JoustSimBosListener() {
        }

        @Override
        public void handleYourExtraInfo(List<ExtraInfoBlock> extraInfos) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Got extra info: " + extraInfos));
            }
            for (ExtraInfoBlock block : extraInfos) {
                if (block.getType() != 2) continue;
                String statusMessage = ExtraInfoData.readAvailableMessage(block.getExtraData());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Received a status message:" + statusMessage));
                }
                if (OperationSetPersistentPresenceIcqImpl.this.getCurrentStatusMessage().equals(statusMessage)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Status message is same as old. Ignoring");
                    }
                    return;
                }
                String oldStatusMessage = OperationSetPersistentPresenceIcqImpl.this.getCurrentStatusMessage();
                OperationSetPersistentPresenceIcqImpl.this.currentStatusMessage = statusMessage;
                OperationSetPersistentPresenceIcqImpl.this.fireProviderStatusMessageChangeEvent(oldStatusMessage, OperationSetPersistentPresenceIcqImpl.this.getCurrentStatusMessage());
            }
        }

        @Override
        public void handleYourInfo(MainBosService service, FullUserInfo userInfo) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received our own user info: " + userInfo));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("previous status was: " + OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new status is: " + userInfo.getIcqStatus()));
            }
            long oldStatus = OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus;
            if (((ProtocolProviderServiceIcqImpl)((OperationSetPersistentPresenceIcqImpl)OperationSetPersistentPresenceIcqImpl.this).parentProvider).USING_ICQ) {
                OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus = userInfo.getIcqStatus();
                if (OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus == -1L) {
                    OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus = 0x1000000L;
                }
                if (oldStatus != OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus) {
                    OperationSetPersistentPresenceIcqImpl.this.fireProviderPresenceStatusChangeEvent(oldStatus, OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus);
                }
            } else {
                if (userInfo.getAwayStatus() != null && userInfo.getAwayStatus().equals(Boolean.TRUE)) {
                    OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus = OperationSetPersistentPresenceIcqImpl.this.presenceStatusToStatusLong(AimStatusEnum.AWAY);
                } else if (userInfo.getIcqStatus() != -1L) {
                    OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus = userInfo.getIcqStatus();
                } else {
                    OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus = 0x1000000L;
                }
                if (oldStatus != OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus) {
                    OperationSetPersistentPresenceIcqImpl.this.fireProviderPresenceStatusChangeEvent(oldStatus, OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus);
                }
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The ICQ provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.FINALIZING_REGISTRATION) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"adding a Bos Service Listener");
                }
                ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getBosService().addMainBosServiceListener(OperationSetPersistentPresenceIcqImpl.this.joustSimBosListener);
                OperationSetPersistentPresenceIcqImpl.this.ssContactList.init(((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getSsiService());
                ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getBuddyService().addBuddyListener(OperationSetPersistentPresenceIcqImpl.this.joustSimBuddySerListener);
                ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getBuddyInfoManager().addGlobalBuddyInfoListener(new GlobalBuddyInfoListener());
                ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getExternalServiceManager().getIconServiceArbiter().addIconRequestListener(new IconUpdateListener());
                ((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getAimConnection().getInfoService().addInfoListener(new AwayMessageListener());
            } else if (evt.getNewState() == RegistrationState.REGISTERED) {
                if (((ProtocolProviderServiceIcqImpl)((OperationSetPersistentPresenceIcqImpl)OperationSetPersistentPresenceIcqImpl.this).parentProvider).USING_ICQ) {
                    OperationSetPersistentPresenceIcqImpl.this.opSetExtendedAuthorizations = (OperationSetExtendedAuthorizationsIcqImpl)((ProtocolProviderServiceIcqImpl)OperationSetPersistentPresenceIcqImpl.this.parentProvider).getOperationSet(OperationSetExtendedAuthorizations.class);
                    if (OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer == null) {
                        OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer = new Timer();
                    } else {
                        OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer.cancel();
                        OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer = new Timer();
                    }
                    AwaitingAuthorizationContactsPresenceTimer queryTask = new AwaitingAuthorizationContactsPresenceTimer();
                    OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer.scheduleAtFixedRate((TimerTask)queryTask, 15000L, OperationSetPersistentPresenceIcqImpl.this.PRESENCE_QUERY_INTERVAL);
                }
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                if (OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer != null) {
                    OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer.cancel();
                    OperationSetPersistentPresenceIcqImpl.this.presenceQueryTimer = null;
                }
                long oldStatus = OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus;
                OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus = -1L;
                if (oldStatus != -1L) {
                    OperationSetPersistentPresenceIcqImpl.this.fireProviderPresenceStatusChangeEvent(oldStatus, OperationSetPersistentPresenceIcqImpl.this.currentIcqStatus);
                }
                Iterator groupsIter = OperationSetPersistentPresenceIcqImpl.this.getServerStoredContactListRoot().subgroups();
                while (groupsIter.hasNext()) {
                    ContactGroup group = (ContactGroup)groupsIter.next();
                    Iterator contactsIter = group.contacts();
                    while (contactsIter.hasNext()) {
                        ContactIcqImpl contact = (ContactIcqImpl)((Object)contactsIter.next());
                        PresenceStatus oldContactStatus = contact.getPresenceStatus();
                        if (!oldContactStatus.isOnline()) continue;
                        if (((ProtocolProviderServiceIcqImpl)((OperationSetPersistentPresenceIcqImpl)OperationSetPersistentPresenceIcqImpl.this).parentProvider).USING_ICQ) {
                            contact.updatePresenceStatus((PresenceStatus)IcqStatusEnum.OFFLINE);
                            OperationSetPersistentPresenceIcqImpl.this.fireContactPresenceStatusChangeEvent((Contact)contact, contact.getParentContactGroup(), oldContactStatus, (PresenceStatus)IcqStatusEnum.OFFLINE);
                            continue;
                        }
                        contact.updatePresenceStatus(AimStatusEnum.OFFLINE);
                        OperationSetPersistentPresenceIcqImpl.this.fireContactPresenceStatusChangeEvent((Contact)contact, contact.getParentContactGroup(), oldContactStatus, AimStatusEnum.OFFLINE);
                    }
                }
            }
        }
    }

    private static class StatusResponseRetriever
    extends SnacRequestAdapter {
        private boolean ran = false;
        private long status = -1L;

        private StatusResponseRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(SnacResponseEvent e) {
            SnacCommand snac = e.getSnacCommand();
            StatusResponseRetriever statusResponseRetriever = this;
            synchronized (statusResponseRetriever) {
                if (this.ran) {
                    return;
                }
                this.ran = true;
            }
            if (snac instanceof UserInfoCmd) {
                UserInfoCmd uic = (UserInfoCmd)snac;
                FullUserInfo userInfo = uic.getUserInfo();
                if (userInfo != null) {
                    this.status = userInfo.getIcqStatus();
                    StatusResponseRetriever statusResponseRetriever2 = this;
                    synchronized (statusResponseRetriever2) {
                        this.notifyAll();
                    }
                }
            } else if (snac instanceof SnacError) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("status is" + this.status));
                }
                statusResponseRetriever = this;
                synchronized (statusResponseRetriever) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTimeout(SnacRequestTimeoutEvent event) {
            StatusResponseRetriever statusResponseRetriever = this;
            synchronized (statusResponseRetriever) {
                if (this.ran) {
                    return;
                }
                this.ran = true;
                this.notifyAll();
            }
        }
    }
}

