/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.util.List;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.main.contactlist.GenericUIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class InviteUIContact
extends GenericUIContactImpl {
    private final UIContact sourceUIContact;
    private final ProtocolProviderService backupProvider;

    public InviteUIContact(UIContact uiContact, ProtocolProviderService protocolProvider) {
        super(uiContact.getDescriptor(), null, uiContact.getDisplayName());
        this.setDisplayDetails(uiContact.getDisplayDetails());
        this.sourceUIContact = uiContact;
        this.backupProvider = protocolProvider;
    }

    @Override
    public List<UIContactDetail> getContactDetailsForOperationSet(Class<? extends OperationSet> opSetClass) {
        List contactDetails = this.sourceUIContact.getContactDetailsForOperationSet(opSetClass);
        if (contactDetails == null) {
            return null;
        }
        if (this.backupProvider == null) {
            return contactDetails;
        }
        for (UIContactDetail contactDetail : contactDetails) {
            if (contactDetail.getPreferredProtocolProvider(opSetClass) == null) {
                contactDetail.addPreferredProtocolProvider(opSetClass, this.backupProvider);
            }
            if (contactDetail.getPreferredProtocol(opSetClass) != null) continue;
            contactDetail.addPreferredProtocol(opSetClass, this.backupProvider.getProtocolName());
        }
        return contactDetails;
    }

    @Override
    public List<UIContactDetail> getContactDetails() {
        return this.sourceUIContact.getContactDetails();
    }

    @Override
    public UIContactDetail getDefaultContactDetail(Class<? extends OperationSet> opSetClass) {
        return this.sourceUIContact.getDefaultContactDetail(opSetClass);
    }

    @Override
    public ImageIcon getScaledAvatar(boolean isSelected, int width, int height) {
        if (this.sourceUIContact instanceof UIContactImpl) {
            return ((UIContactImpl)this.sourceUIContact).getScaledAvatar(isSelected, width, height);
        }
        return null;
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (this.sourceUIContact instanceof UIContactImpl) {
            return ((UIContactImpl)this.sourceUIContact).getStatusIcon();
        }
        return null;
    }
}

