/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListTreeCellRenderer;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.DefaultTreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.MetaContactListManager;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIGroup;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTransferHandler;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresencePermissions;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;

public class ContactListTransferHandler
extends ExtendedTransferHandler {
    protected static final DataFlavor uiContactDataFlavor = new DataFlavor(UIContact.class, "UIContact");
    private static final Logger logger = Logger.getLogger(ContactListTransferHandler.class);
    private final DefaultTreeContactList contactList;
    private Object transferredObject = null;

    public ContactListTransferHandler(DefaultTreeContactList contactList) {
        this.contactList = contactList;
    }

    protected Transferable createTransferable(JComponent component) {
        if (ConfigurationUtils.isAddContactDisabled() && (ConfigurationUtils.isContactMoveDisabled() || ConfigurationUtils.isCreateGroupDisabled())) {
            return null;
        }
        if (component instanceof JTree) {
            JTree tree = (JTree)component;
            TreePath selectionPath = tree.getSelectionPath();
            this.transferredObject = selectionPath.getLastPathComponent();
            return new ContactListTransferable(tree.getRowForPath(selectionPath), selectionPath.getLastPathComponent());
        }
        return super.createTransferable(component);
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        if (!(this.transferredObject instanceof ContactNode)) {
            return false;
        }
        Object selectedObject = ((ContactNode)this.transferredObject).getContactDescriptor().getDescriptor();
        if (selectedObject instanceof MetaContact) {
            MetaContact metaContact = (MetaContact)selectedObject;
            Iterator contacts = metaContact.getContacts();
            while (contacts.hasNext()) {
                Contact contact = (Contact)contacts.next();
                if (contact.getPersistableAddress() != null) continue;
                return false;
            }
        }
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            if (!flavor[i].equals(uiContactDataFlavor)) continue;
            return true;
        }
        return super.canImport(comp, flavor);
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            ChatPanel chatPanel;
            Object o;
            block31: {
                o = null;
                try {
                    o = t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to drop files.", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block31;
                    logger.debug((Object)"Failed to drop files.", (Throwable)e);
                }
            }
            if (o instanceof Collection && (chatPanel = this.getChatPanel()) != null) {
                Collection files = (Collection)o;
                for (File file : files) {
                    chatPanel.sendFile(file);
                    GuiActivator.getUIService().getChatWindowManager().openChat(chatPanel, false);
                }
                return true;
            }
        } else if (t.isDataFlavorSupported(uiContactDataFlavor)) {
            Object o;
            block32: {
                o = null;
                try {
                    o = t.getTransferData(uiContactDataFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block32;
                    logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                }
            }
            if (o instanceof ContactNode && comp instanceof TreeContactList) {
                UIContactImpl transferredContact = ((ContactNode)o).getContactDescriptor();
                if (!(transferredContact instanceof MetaUIContact)) {
                    return false;
                }
                TreeContactList list = (TreeContactList)comp;
                Object dest = list.getSelectedValue();
                if (transferredContact == null) {
                    return false;
                }
                if (transferredContact.getDescriptor() instanceof MetaContact) {
                    MetaContact metaContact = (MetaContact)transferredContact.getDescriptor();
                    boolean onlyReadonlyContacts = true;
                    Iterator iter = metaContact.getContacts();
                    while (iter.hasNext()) {
                        Contact c = (Contact)iter.next();
                        ProtocolProviderService pp = c.getProtocolProvider();
                        OperationSetPersistentPresencePermissions opsetPermissions = (OperationSetPersistentPresencePermissions)pp.getOperationSet(OperationSetPersistentPresencePermissions.class);
                        if (opsetPermissions != null && opsetPermissions.isReadOnly(c)) continue;
                        onlyReadonlyContacts = false;
                        break;
                    }
                    if (onlyReadonlyContacts) {
                        return false;
                    }
                }
                if (dest instanceof ContactNode) {
                    UIContactImpl destContact = ((ContactNode)dest).getContactDescriptor();
                    if (!(destContact instanceof MetaUIContact)) {
                        return false;
                    }
                    if (transferredContact != destContact) {
                        String mergeEnabledStr = GuiActivator.getResources().getSettingsString("impl.gui.dnd.MERGE_ENABLED");
                        if (mergeEnabledStr != null && !Boolean.parseBoolean(mergeEnabledStr)) {
                            UIGroup destGroup = destContact.getParentGroup();
                            if (destGroup == null || !(destGroup instanceof MetaUIGroup) || ConfigurationUtils.isContactMoveDisabled() || ConfigurationUtils.isCreateGroupDisabled()) {
                                return false;
                            }
                            MetaContactListManager.moveMetaContactToGroup((MetaContact)transferredContact.getDescriptor(), (MetaContactGroup)destGroup.getDescriptor());
                        } else if (!ConfigurationUtils.isAddContactDisabled()) {
                            MetaContactListManager.moveMetaContactToMetaContact((MetaContact)transferredContact.getDescriptor(), (MetaContact)destContact.getDescriptor());
                        }
                    }
                    return true;
                }
                if (dest instanceof GroupNode) {
                    UIGroupImpl destGroup = ((GroupNode)dest).getGroupDescriptor();
                    if (!(destGroup instanceof MetaUIGroup) && !((Object)((Object)destGroup)).equals((Object)list.getRootUIGroup())) {
                        return false;
                    }
                    if (!(!(destGroup instanceof MetaUIGroup) || transferredContact.getParentGroup().equals((Object)destGroup) || ConfigurationUtils.isContactMoveDisabled() && ConfigurationUtils.isCreateGroupDisabled())) {
                        MetaContactListManager.moveMetaContactToGroup((MetaContact)transferredContact.getDescriptor(), (MetaContactGroup)destGroup.getDescriptor());
                    } else if (((Object)((Object)destGroup)).equals((Object)list.getRootUIGroup())) {
                        MetaContactListManager.moveMetaContactToGroup((MetaContact)transferredContact.getDescriptor(), GuiActivator.getContactListService().getRoot());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public Icon getVisualRepresentation(Transferable t) {
        Icon icon;
        block5: {
            icon = null;
            if (t instanceof ContactListTransferable) {
                ContactListTransferable transferable = (ContactListTransferable)t;
                try {
                    icon = ((ContactListTreeCellRenderer)this.contactList.getCellRenderer()).getDragIcon(this.contactList, transferable.getTransferData(uiContactDataFlavor), transferable.getTransferIndex());
                }
                catch (UnsupportedFlavorException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Unsupported flavor while obtaining transfer data.", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"The data for the request flavor is no longer available.", (Throwable)e);
                }
            }
        }
        return icon;
    }

    private ChatPanel getChatPanel() {
        ChatPanel chatPanel = null;
        Object selectedObject = this.contactList.getSelectedValue();
        if (selectedObject instanceof MetaContact) {
            MetaContact metaContact = (MetaContact)selectedObject;
            chatPanel = GuiActivator.getUIService().getChatWindowManager().getContactChat(metaContact, true);
        }
        return chatPanel;
    }

    public class ContactListTransferable
    implements Transferable {
        private int transferredIndex;
        private Object transferredObject;

        public ContactListTransferable(int index, Object o) {
            this.transferredIndex = index;
            this.transferredObject = o;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{uiContactDataFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return uiContactDataFlavor.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (uiContactDataFlavor.equals(flavor)) {
                return this.transferredObject;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                if (this.transferredObject instanceof ContactNode) {
                    return ((ContactNode)this.transferredObject).getContactDescriptor().getDisplayName();
                }
            } else {
                throw new UnsupportedFlavorException(flavor);
            }
            return null;
        }

        public int getTransferIndex() {
            return this.transferredIndex;
        }
    }
}

