/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.authorization;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.skin.Skinnable;

public class AuthorizationResponseDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    private JTextArea infoTextArea = new JTextArea();
    private JTextArea responseArea = new JTextArea();
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
    private JScrollPane responseScrollPane = new JScrollPane();
    private JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel northPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 0));
    private JLabel iconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.AUTHORIZATION_ICON)));
    private JPanel titlePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private JLabel titleLabel = new JLabel();
    private String title = GuiActivator.getResources().getI18NString("service.gui.AUTHORIZATION_RESPONSE");

    public AuthorizationResponseDialog(MainFrame mainFrame, Contact contact, AuthorizationResponse response) {
        super((Frame)((Object)mainFrame));
        this.setModal(false);
        this.setTitle(this.title);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(this.title);
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(font.deriveFont(1, font.getSize2D() + 6.0f));
        this.mainPanel.setPreferredSize(new Dimension(400, 250));
        AuthorizationResponse.AuthorizationResponseCode responseCode = response.getResponseCode();
        if (responseCode.equals(AuthorizationResponse.ACCEPT)) {
            this.infoTextArea.setText(GuiActivator.getResources().getI18NString("service.gui.AUTHORIZATION_ACCEPTED", new String[]{contact.getDisplayName()}));
        } else if (responseCode.equals(AuthorizationResponse.REJECT)) {
            this.infoTextArea.setText(GuiActivator.getResources().getI18NString("service.gui.AUTHENTICATION_REJECTED", new String[]{contact.getDisplayName()}));
        }
        if (response.getReason() != null && !response.getReason().equals("")) {
            this.responseScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.responseArea.setText(response.getReason());
            this.responseArea.setLineWrap(true);
            this.responseArea.setWrapStyleWord(true);
            this.responseArea.setEditable(false);
            this.responseArea.setOpaque(false);
            this.responseScrollPane.getViewport().add(this.responseArea);
            this.mainPanel.add((Component)this.responseScrollPane, "Center");
            this.mainPanel.setPreferredSize(new Dimension(400, 250));
        } else {
            this.mainPanel.setPreferredSize(new Dimension(400, 180));
        }
        this.infoTextArea.setFont(this.infoTextArea.getFont().deriveFont(1));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setOpaque(false);
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.add(this.infoTextArea);
        this.northPanel.add((Component)this.iconLabel, "West");
        this.northPanel.add((Component)this.titlePanel, "Center");
        this.okButton.requestFocus();
        this.okButton.setName("ok");
        this.okButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.OK"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(this);
        this.buttonsPanel.add(this.okButton);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    protected void close(boolean isEscaped) {
        this.dispose();
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.AUTHORIZATION_ICON)));
    }
}

