/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.snac.AbstractSnacProcessor;
import net.kano.joscar.snac.ImmediateSnacQueueManager;
import net.kano.joscar.snac.OutgoingSnacRequestListener;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import org.jetbrains.annotations.Nullable;

public class ClientSnacProcessor
extends AbstractSnacProcessor {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.snac");
    public static final ConnProcessor.ErrorType ERRTYPE_SNAC_REQUEST_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_SNAC_REQUEST_LISTENER");
    public static final ConnProcessor.ErrorType ERRTYPE_SNAC_RESPONSE_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_SNAC_RESPONSE_LISTENER");
    public static final int REQUEST_TTL_DEFAULT = 900;
    public static final long REQID_MIN = 0L;
    public static final long REQID_MAX = Integer.MAX_VALUE;
    private final SeqNum reqid = new SeqNum(0L, Integer.MAX_VALUE);
    private final Object requestEventLock = new Object();
    private final CopyOnWriteArrayList<OutgoingSnacRequestListener> requestListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<SnacResponseListener> responseListeners = new CopyOnWriteArrayList();
    private int requestTtl = 900;
    private final Map<Long, RequestInfo> requests = new HashMap<Long, RequestInfo>();
    private final List<RequestInfo> requestQueue = new LinkedList<RequestInfo>();
    private boolean paused = false;
    private SnacQueueManager queueManager;

    public ClientSnacProcessor(FlapProcessor processor) {
        super(processor);
        this.setSnacQueueManager(null);
    }

    public final synchronized void pause() {
        if (this.paused) {
            return;
        }
        this.queueManager.pause(this);
        this.paused = true;
    }

    public final synchronized void unpause() {
        if (!this.paused) {
            return;
        }
        this.queueManager.unpause(this);
        this.paused = false;
    }

    public final synchronized boolean isPaused() {
        return this.paused;
    }

    public final void migrate(FlapProcessor processor) {
        super.migrate(processor);
    }

    public final void addGlobalRequestListener(OutgoingSnacRequestListener l) {
        DefensiveTools.checkNull(l, "l");
        this.requestListeners.addIfAbsent(l);
    }

    public final void removeGlobalRequestListener(OutgoingSnacRequestListener l) {
        DefensiveTools.checkNull(l, "l");
        this.requestListeners.remove(l);
    }

    public final void addGlobalResponseListener(SnacResponseListener l) {
        DefensiveTools.checkNull(l, "l");
        this.responseListeners.addIfAbsent(l);
    }

    public final void removeGlobalResponseListener(SnacResponseListener l) {
        DefensiveTools.checkNull(l, "l");
        this.responseListeners.remove(l);
    }

    public final synchronized void setSnacQueueManager(SnacQueueManager mgr) {
        if (this.queueManager != null) {
            this.queueManager.clearQueue(this);
            this.queueManager.detached(this);
        }
        SnacQueueManager realMgr = mgr == null ? new ImmediateSnacQueueManager() : mgr;
        this.queueManager = realMgr;
        this.queueManager.attached(this);
        if (this.paused) {
            realMgr.pause(this);
        }
    }

    public final synchronized void unsetSnacQueueManager(SnacQueueManager mgr) {
        if (this.queueManager == mgr) {
            this.setSnacQueueManager(null);
        }
    }

    public final synchronized SnacQueueManager getSnacQueueManager() {
        return this.queueManager;
    }

    public synchronized void setRequestTtl(int requestTtl) {
        DefensiveTools.checkRange(requestTtl, "requestTtl", 0);
        this.requestTtl = requestTtl;
    }

    public synchronized int getRequestTtl() {
        return this.requestTtl;
    }

    @Nullable
    public synchronized SnacRequest getRequest(long reqid) {
        RequestInfo reqinfo = this.requests.get(reqid);
        if (reqinfo == null) {
            return null;
        }
        return reqinfo.getRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void timeoutRequest(RequestInfo reqInfo) {
        int ttl;
        FlapProcessor processor;
        ClientSnacProcessor clientSnacProcessor = this;
        synchronized (clientSnacProcessor) {
            processor = this.getFlapProcessor();
            ttl = this.requestTtl;
        }
        SnacRequest request = reqInfo.getRequest();
        SnacRequestTimeoutEvent event = new SnacRequestTimeoutEvent(processor, this, request, ttl);
        if (logger.logFinerEnabled()) {
            logger.logFiner("Snac request timed out: " + request);
        }
        Object object = this.requestEventLock;
        synchronized (object) {
            if (!this.requestListeners.isEmpty()) {
                for (OutgoingSnacRequestListener l : this.requestListeners) {
                    try {
                        l.handleTimeout(event);
                    }
                    catch (Throwable t) {
                        processor.handleException(ERRTYPE_SNAC_REQUEST_LISTENER, t, l);
                    }
                }
            }
            request.timedOut(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearAllRequests() {
        Map<Long, RequestInfo> map = this.requests;
        synchronized (map) {
            for (RequestInfo reqInfo : this.requests.values()) {
                this.timeoutRequest(reqInfo);
            }
            this.requests.clear();
            this.requestQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanRequests() {
        int ttl;
        ClientSnacProcessor clientSnacProcessor = this;
        synchronized (clientSnacProcessor) {
            ttl = this.requestTtl;
        }
        LinkedList<RequestInfo> timedout = new LinkedList<RequestInfo>();
        Map<Long, RequestInfo> map = this.requests;
        synchronized (map) {
            if (this.requestQueue.isEmpty()) {
                return;
            }
            if (ttl == 0) {
                this.clearAllRequests();
                return;
            }
            long time = System.currentTimeMillis();
            long ttlms = ttl * 1000;
            Iterator<RequestInfo> it = this.requestQueue.iterator();
            while (it.hasNext()) {
                RequestInfo reqInfo = it.next();
                long sentTime = reqInfo.getSentTime();
                if (sentTime == -1L) continue;
                long diff = time - sentTime;
                if (diff < ttlms) break;
                timedout.add(reqInfo);
                it.remove();
                this.requests.remove(reqInfo.getRequest().getReqid());
            }
        }
        for (RequestInfo reqInfo : timedout) {
            this.timeoutRequest(reqInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendSnac(SnacRequest request) {
        SnacQueueManager queueMgr;
        DefensiveTools.checkNull(request, "request");
        SnacCommand command = request.getCommand();
        RequestInfo reqInfo = this.registerSnacRequest(request);
        long reqid = reqInfo.getRequest().getReqid();
        if (logger.logFineEnabled()) {
            logger.logFine("Queueing Snac request #" + reqid + ": " + command);
        }
        ClientSnacProcessor clientSnacProcessor = this;
        synchronized (clientSnacProcessor) {
            queueMgr = this.queueManager;
        }
        queueMgr.queueSnac(this, request);
        if (logger.logFinerEnabled()) {
            logger.logFiner("Finished queueing Snac request #" + reqid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendSnacImmediately(SnacRequest request) {
        int ttl;
        RequestInfo reqInfo;
        DefensiveTools.checkNull(request, "request");
        if (logger.logFineEnabled()) {
            logger.logFine("Sending SNAC request " + request);
        }
        if ((reqInfo = this.registerSnacRequest(request)).getSentTime() != -1L) {
            throw new IllegalArgumentException("SNAC request " + request + " was already sent");
        }
        ClientSnacProcessor clientSnacProcessor = this;
        synchronized (clientSnacProcessor) {
            ttl = this.requestTtl;
        }
        long reqid = reqInfo.getRequest().getReqid();
        this.sendSnac(reqid, request.getCommand());
        this.fireSentEvent(reqInfo);
        Map<Long, RequestInfo> map = this.requests;
        synchronized (map) {
            if (ttl != 0) {
                this.requestQueue.add(reqInfo);
            } else {
                this.requests.remove(reqid);
            }
        }
        if (logger.logFinerEnabled()) {
            logger.logFiner("Finished sending SNAC request " + request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSentEvent(RequestInfo reqInfo) {
        FlapProcessor processor;
        SnacRequest request = reqInfo.getRequest();
        long now = System.currentTimeMillis();
        reqInfo.sent(now);
        ClientSnacProcessor clientSnacProcessor = this;
        synchronized (clientSnacProcessor) {
            processor = this.getFlapProcessor();
        }
        SnacRequestSentEvent event = new SnacRequestSentEvent(processor, this, request, now);
        Object object = this.requestEventLock;
        synchronized (object) {
            if (!this.requestListeners.isEmpty()) {
                for (OutgoingSnacRequestListener l : this.requestListeners) {
                    try {
                        l.handleSent(event);
                    }
                    catch (Throwable t) {
                        processor.handleException(ERRTYPE_SNAC_REQUEST_LISTENER, t, l);
                    }
                }
            }
            request.sent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInfo registerSnacRequest(SnacRequest request) {
        Map<Long, RequestInfo> map = this.requests;
        synchronized (map) {
            if (request.getReqid() != -1L) {
                return this.requests.get(request.getReqid());
            }
            long id = this.reqid.next();
            request.setReqid(id);
            Long key = id;
            this.cleanRequests();
            RequestInfo reqInfo = new RequestInfo(request);
            this.requests.put(key, reqInfo);
            return reqInfo;
        }
    }

    public final synchronized void detach() {
        if (!this.isAttached()) {
            return;
        }
        super.detach();
        this.paused = false;
        this.queueManager.clearQueue(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean continueHandling(SnacPacketEvent event) {
        RequestInfo reqInfo;
        boolean logFiner = logger.logFinerEnabled();
        FlapProcessor processor = event.getFlapProcessor();
        SnacPacket snacPacket = event.getSnacPacket();
        Long key = snacPacket.getReqid();
        Map<Long, RequestInfo> map = this.requests;
        synchronized (map) {
            reqInfo = this.requests.get(key);
        }
        if (reqInfo == null) {
            return true;
        }
        SnacRequest request = reqInfo.getRequest();
        if (logFiner) {
            logger.logFiner("This Snac packet is a response to a request!");
        }
        SnacResponseEvent sre = new SnacResponseEvent(event, request);
        if (!this.responseListeners.isEmpty()) {
            for (SnacResponseListener l : this.responseListeners) {
                try {
                    l.handleResponse(sre);
                }
                catch (Throwable t) {
                    processor.handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, t, l);
                }
            }
        }
        try {
            request.gotResponse(sre);
        }
        catch (Throwable t) {
            processor.handleException(ERRTYPE_SNAC_REQUEST_LISTENER, t, request);
        }
        return false;
    }

    public String toString() {
        return "ClientSnacProcessor: lastreqid=" + this.reqid.getLast() + ", requests: " + this.requests.size() + ", paused=" + this.paused;
    }

    private static class RequestInfo {
        private final SnacRequest request;
        private long sent = -1L;

        private RequestInfo(SnacRequest request) {
            this.request = request;
        }

        public final synchronized void sent(long time) throws IllegalStateException {
            if (this.sent != -1L) {
                throw new IllegalStateException(this.request + " was already sent " + (System.currentTimeMillis() - this.sent) / 1000L + " seconds ago");
            }
            this.sent = time;
        }

        public final SnacRequest getRequest() {
            return this.request;
        }

        public final synchronized long getSentTime() {
            return this.sent;
        }

        public String toString() {
            return "Request " + MiscTools.getClassName(this.request.getCommand()) + ": " + (this.sent == -1L ? "not sent" : "sent " + (System.currentTimeMillis() - this.sent) / 1000L + "s ago");
        }
    }
}

