/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.generic;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.fileaccess.FileAccessService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class TestOperationSetFileTransfer
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetFileTransfer.class);
    private FileAccessService fileAccessService = null;

    public TestOperationSetFileTransfer(String name) {
        super(name);
    }

    public TestOperationSetFileTransfer() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    protected void tearDown() throws Exception {
        this.stop();
        super.tearDown();
    }

    private FileAccessService getFileService() {
        if (this.fileAccessService == null) {
            ServiceReference ref = this.getContext().getServiceReference(FileAccessService.class.getName());
            this.fileAccessService = (FileAccessService)this.getContext().getService(ref);
        }
        return this.fileAccessService;
    }

    private File getTempFileToTransfer(int size) throws Exception {
        File fileToTransfer = this.getFileService().getTemporaryFile();
        byte[] buff = new byte[size];
        Arrays.fill(buff, (byte)1);
        FileOutputStream out = new FileOutputStream(fileToTransfer);
        out.write(buff);
        out.flush();
        out.close();
        return fileToTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendAndReceive() throws Exception {
        if (!this.enableTestSendAndReceive()) {
            return;
        }
        logger.trace((Object)"Start test : send and receive ok.");
        File fileToTransfer = this.getTempFileToTransfer(123456);
        OperationSetFileTransfer ftOpSet1 = this.getOpSetFilTransfer1();
        OperationSetFileTransfer ftOpSet2 = this.getOpSetFilTransfer2();
        FileTransferStatusEventCollector senderStatusListener = new FileTransferStatusEventCollector("Sender");
        FileTransferEventCollector senderFTListerner = new FileTransferEventCollector("Sender", senderStatusListener);
        ftOpSet1.addFileTransferListener((FileTransferListener)senderFTListerner);
        FileTransferStatusEventCollector receiverStatusListener = new FileTransferStatusEventCollector("Receiver");
        FileTransferEventCollector receiverFTListerner = new FileTransferEventCollector("Receiver", receiverStatusListener);
        ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        try {
            ftOpSet1.sendFile(this.getContact1(), fileToTransfer);
            senderFTListerner.waitForEvent(2000L);
            receiverFTListerner.waitForEvent(8000L);
            senderStatusListener.waitForEvent(2000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on send side", (int)1, (int)senderFTListerner.collectedEvents.size());
            FileTransferCreatedEvent fileTransferCreatedEvent = (FileTransferCreatedEvent)senderFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)fileToTransfer);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer status changed - preparing received on send side", (int)1, (int)senderStatusListener.collectedEvents.size());
            FileTransferStatusChangeEvent fileTransferStatusEvent = senderStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be preparing", (int)6, (int)fileTransferStatusEvent.getNewStatus());
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer request must be received on the receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            FileTransferRequestEvent fileTransferRequestEvent = (FileTransferRequestEvent)receiverFTListerner.collectedEvents.get(0);
            IncomingFileTransferRequest req = fileTransferRequestEvent.getRequest();
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file name must be the same", (String)req.getFileName(), (String)fileToTransfer.getName());
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file size must be the same", (long)req.getFileSize(), (long)fileToTransfer.length());
            senderFTListerner.clear();
            receiverFTListerner.clear();
            senderStatusListener.clear();
            File receiveFile = this.getFileService().getTemporaryFile();
            req.acceptFile(receiveFile);
            senderFTListerner.waitForEvent(4000L);
            receiverFTListerner.waitForEvent(4000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            fileTransferCreatedEvent = (FileTransferCreatedEvent)receiverFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)receiveFile);
            receiverStatusListener.waitForEvent(30000L, 3);
            TestOperationSetFileTransfer.assertTrue((String)"A file transfer status changed - preparing, inprogress and completed received on receiver side", (3 == receiverStatusListener.collectedEvents.size() || 2 == receiverStatusListener.collectedEvents.size() ? 1 : 0) != 0);
            fileTransferStatusEvent = receiverStatusListener.collectedEvents.get(0);
            if (receiverStatusListener.collectedEvents.size() == 3) {
                TestOperationSetFileTransfer.assertEquals((String)"Event must be preparing", (int)6, (int)fileTransferStatusEvent.getNewStatus());
                fileTransferStatusEvent = receiverStatusListener.collectedEvents.get(1);
            }
            TestOperationSetFileTransfer.assertEquals((String)"Event must be in_progress", (int)4, (int)fileTransferStatusEvent.getNewStatus());
            fileTransferStatusEvent = receiverStatusListener.collectedEvents.size() == 3 ? receiverStatusListener.collectedEvents.get(2) : receiverStatusListener.collectedEvents.get(1);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be completed", (int)0, (int)fileTransferStatusEvent.getNewStatus());
            senderStatusListener.waitForEvent(4000L, 2);
            TestOperationSetFileTransfer.assertTrue((String)"Completed event must be received", (boolean)senderStatusListener.contains(0));
        }
        finally {
            ftOpSet1.removeFileTransferListener((FileTransferListener)senderFTListerner);
            ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSenderCancelBeforeAccepted() throws Exception {
        if (!this.enableTestSenderCancelBeforeAccepted()) {
            return;
        }
        logger.trace((Object)"Start test : sender will cancel transfer before receiver accept or decline it");
        File fileToTransfer = this.getTempFileToTransfer(1234567);
        OperationSetFileTransfer ftOpSet1 = this.getOpSetFilTransfer1();
        OperationSetFileTransfer ftOpSet2 = this.getOpSetFilTransfer2();
        FileTransferStatusEventCollector senderStatusListener = new FileTransferStatusEventCollector("Sender");
        FileTransferEventCollector senderFTListerner = new FileTransferEventCollector("Sender", senderStatusListener);
        ftOpSet1.addFileTransferListener((FileTransferListener)senderFTListerner);
        FileTransferEventCollector receiverFTListerner = new FileTransferEventCollector("Receiver", null);
        ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        try {
            FileTransfer ft1 = ftOpSet1.sendFile(this.getContact1(), fileToTransfer);
            senderFTListerner.waitForEvent(2000L);
            receiverFTListerner.waitForEvent(2000L);
            senderStatusListener.waitForEvent(2000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on send side", (int)1, (int)senderFTListerner.collectedEvents.size());
            FileTransferCreatedEvent fileTransferCreatedEvent = (FileTransferCreatedEvent)senderFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)fileToTransfer);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer status changed - preparing received on send side", (int)1, (int)senderStatusListener.collectedEvents.size());
            FileTransferStatusChangeEvent fileTransferStatusEvent = senderStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be preparing", (int)6, (int)fileTransferStatusEvent.getNewStatus());
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer request must be received on the receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            FileTransferRequestEvent fileTransferRequestEvent = (FileTransferRequestEvent)receiverFTListerner.collectedEvents.get(0);
            IncomingFileTransferRequest req = fileTransferRequestEvent.getRequest();
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file name must be the same", (String)req.getFileName(), (String)fileToTransfer.getName());
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file size must be the same", (long)req.getFileSize(), (long)fileToTransfer.length());
            senderFTListerner.clear();
            receiverFTListerner.clear();
            senderStatusListener.clear();
            ft1.cancel();
            receiverFTListerner.waitForEvent(6000L);
            senderStatusListener.waitForEvent(6000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer status changed - cancel received on send side", (int)1, (int)senderStatusListener.collectedEvents.size());
            fileTransferStatusEvent = senderStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be canceled", (int)1, (int)fileTransferStatusEvent.getNewStatus());
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer cancel must be received on receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            fileTransferRequestEvent = (FileTransferRequestEvent)receiverFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertTrue((String)"FileTransfer must be canceled", (boolean)receiverFTListerner.isCanceled());
        }
        finally {
            ftOpSet1.removeFileTransferListener((FileTransferListener)senderFTListerner);
            ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceiverDecline() throws Exception {
        if (!this.enableTestReceiverDecline()) {
            return;
        }
        logger.info((Object)"Start test: receiver will decline incoming fileTransfer");
        File fileToTransfer = this.getTempFileToTransfer(12345);
        OperationSetFileTransfer ftOpSet1 = this.getOpSetFilTransfer1();
        OperationSetFileTransfer ftOpSet2 = this.getOpSetFilTransfer2();
        FileTransferStatusEventCollector senderStatusListener = new FileTransferStatusEventCollector("Sender");
        FileTransferEventCollector senderFTListerner = new FileTransferEventCollector("Sender", senderStatusListener);
        ftOpSet1.addFileTransferListener((FileTransferListener)senderFTListerner);
        FileTransferEventCollector receiverFTListerner = new FileTransferEventCollector("Receiver", null);
        ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        try {
            ftOpSet1.sendFile(this.getContact1(), fileToTransfer);
            senderFTListerner.waitForEvent(2000L);
            receiverFTListerner.waitForEvent(6000L);
            senderStatusListener.waitForEvent(2000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on send side", (int)1, (int)senderFTListerner.collectedEvents.size());
            FileTransferCreatedEvent fileTransferCreatedEvent = (FileTransferCreatedEvent)senderFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)fileToTransfer);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer status changed - preparing received on send side", (int)1, (int)senderStatusListener.collectedEvents.size());
            FileTransferStatusChangeEvent fileTransferStatusEvent = senderStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be preparing", (int)6, (int)fileTransferStatusEvent.getNewStatus());
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer request must be received on the receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            FileTransferRequestEvent fileTransferRequestEvent = (FileTransferRequestEvent)receiverFTListerner.collectedEvents.get(0);
            IncomingFileTransferRequest req = fileTransferRequestEvent.getRequest();
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file name must be the same", (String)req.getFileName(), (String)fileToTransfer.getName());
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file size must be the same", (long)req.getFileSize(), (long)fileToTransfer.length());
            senderFTListerner.clear();
            receiverFTListerner.clear();
            senderStatusListener.clear();
            req.rejectFile();
            senderStatusListener.waitForEvent(4000L);
            receiverFTListerner.waitForEvent(4000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer rejected must be received on receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            fileTransferRequestEvent = (FileTransferRequestEvent)receiverFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertTrue((String)"FileTransfer must be rejected", (boolean)receiverFTListerner.isRejected());
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer status changed - refused received on send side", (int)1, (int)senderStatusListener.collectedEvents.size());
            fileTransferStatusEvent = senderStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertTrue((String)"Event must be refused (or failed)", (fileTransferStatusEvent.getNewStatus() == 3 || fileTransferStatusEvent.getNewStatus() == 2 ? 1 : 0) != 0);
        }
        finally {
            ftOpSet1.removeFileTransferListener((FileTransferListener)senderFTListerner);
            ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceiverCancelsWhileTransfering() throws Exception {
        if (!this.enableTestReceiverCancelsWhileTransfering()) {
            return;
        }
        logger.trace((Object)"Start test : receiver will cancel fileTransfer whil transfering.");
        File fileToTransfer = this.getTempFileToTransfer(12345678);
        OperationSetFileTransfer ftOpSet1 = this.getOpSetFilTransfer1();
        OperationSetFileTransfer ftOpSet2 = this.getOpSetFilTransfer2();
        FileTransferStatusEventCollector senderStatusListener = new FileTransferStatusEventCollector("Sender");
        FileTransferEventCollector senderFTListerner = new FileTransferEventCollector("Sender", senderStatusListener);
        ftOpSet1.addFileTransferListener((FileTransferListener)senderFTListerner);
        FileTransferStatusEventCollector receiverStatusListener = new FileTransferStatusEventCollector("Receiver");
        FileTransferEventCollector receiverFTListerner = new FileTransferEventCollector("Receiver", receiverStatusListener);
        ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        try {
            ftOpSet1.sendFile(this.getContact1(), fileToTransfer);
            senderFTListerner.waitForEvent(4000L);
            receiverFTListerner.waitForEvent(4000L);
            senderStatusListener.waitForEvent(4000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on send side", (int)1, (int)senderFTListerner.collectedEvents.size());
            FileTransferCreatedEvent fileTransferCreatedEvent = (FileTransferCreatedEvent)senderFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)fileToTransfer);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer status changed - preparing received on send side", (int)1, (int)senderStatusListener.collectedEvents.size());
            FileTransferStatusChangeEvent fileTransferStatusEvent = senderStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be preparing", (int)6, (int)fileTransferStatusEvent.getNewStatus());
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer request must be received on the receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            FileTransferRequestEvent fileTransferRequestEvent = (FileTransferRequestEvent)receiverFTListerner.collectedEvents.get(0);
            IncomingFileTransferRequest req = fileTransferRequestEvent.getRequest();
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file name must be the same", (String)req.getFileName(), (String)fileToTransfer.getName());
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file size must be the same", (long)req.getFileSize(), (long)fileToTransfer.length());
            senderFTListerner.clear();
            receiverFTListerner.clear();
            senderStatusListener.clear();
            File receiveFile = this.getFileService().getTemporaryFile();
            FileTransfer ft2 = req.acceptFile(receiveFile);
            receiverStatusListener.waitForEvent(16000L, 1);
            TestOperationSetFileTransfer.assertTrue((String)"A file transfer status changed - preparing or and inProgress received on receiver side", (receiverStatusListener.collectedEvents.size() >= 1 ? 1 : 0) != 0);
            FileTransferStatusChangeEvent stat1 = receiverStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be preparing", (int)6, (int)stat1.getNewStatus());
            receiverStatusListener.waitForEvent(14000L);
            senderStatusListener.waitForEvent(14000L);
            receiverStatusListener.collectedEvents.clear();
            senderStatusListener.clear();
            ft2.cancel();
            receiverStatusListener.waitForEvent(14000L);
            FileTransferStatusChangeEvent stat3 = receiverStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be canceled", (int)1, (int)stat3.getNewStatus());
            receiverFTListerner.waitForEvent(14000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            fileTransferCreatedEvent = (FileTransferCreatedEvent)receiverFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)receiveFile);
            senderStatusListener.waitForEvent(14000L, 2);
            TestOperationSetFileTransfer.assertTrue((String)"Must contain canceled event", (boolean)senderStatusListener.contains(1));
        }
        finally {
            ftOpSet1.removeFileTransferListener((FileTransferListener)senderFTListerner);
            ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSenderCancelsWhileTransfering() throws Exception {
        if (!this.enableTestSenderCancelsWhileTransfering()) {
            return;
        }
        logger.trace((Object)"Start test : Sender will cancel fileTransfer while transfering.");
        File fileToTransfer = this.getTempFileToTransfer(12345678);
        OperationSetFileTransfer ftOpSet1 = this.getOpSetFilTransfer1();
        OperationSetFileTransfer ftOpSet2 = this.getOpSetFilTransfer2();
        FileTransferStatusEventCollector senderStatusListener = new FileTransferStatusEventCollector("Sender");
        FileTransferEventCollector senderFTListerner = new FileTransferEventCollector("Sender", senderStatusListener);
        ftOpSet1.addFileTransferListener((FileTransferListener)senderFTListerner);
        FileTransferEventCollector receiverFTListerner = new FileTransferEventCollector("Receiver", null);
        ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        try {
            FileTransfer ft1 = ftOpSet1.sendFile(this.getContact1(), fileToTransfer);
            senderFTListerner.waitForEvent(4000L);
            receiverFTListerner.waitForEvent(4000L);
            senderStatusListener.waitForEvent(4000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on send side", (int)1, (int)senderFTListerner.collectedEvents.size());
            FileTransferCreatedEvent fileTransferCreatedEvent = (FileTransferCreatedEvent)senderFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)fileToTransfer);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer status changed - preparing received on send side", (int)1, (int)senderStatusListener.collectedEvents.size());
            FileTransferStatusChangeEvent fileTransferStatusEvent = senderStatusListener.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"Event must be preparing", (int)6, (int)fileTransferStatusEvent.getNewStatus());
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer request must be received on the receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            FileTransferRequestEvent fileTransferRequestEvent = (FileTransferRequestEvent)receiverFTListerner.collectedEvents.get(0);
            IncomingFileTransferRequest req = fileTransferRequestEvent.getRequest();
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file name must be the same", (String)req.getFileName(), (String)fileToTransfer.getName());
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file size must be the same", (long)req.getFileSize(), (long)fileToTransfer.length());
            senderFTListerner.clear();
            receiverFTListerner.clear();
            senderStatusListener.clear();
            File receiveFile = this.getFileService().getTemporaryFile();
            FileTransferStatusEventCollector receiverStatusListener = new FileTransferStatusEventCollector("Receiver");
            FileTransfer ft2 = req.acceptFile(receiveFile);
            ft2.addStatusListener((FileTransferStatusListener)receiverStatusListener);
            senderStatusListener.waitForEvent(4000L);
            FileTransferStatusChangeEvent stat1 = senderStatusListener.collectedEvents.get(0);
            senderStatusListener.collectedEvents.clear();
            TestOperationSetFileTransfer.assertEquals((String)"Event must be inProgress", (int)4, (int)stat1.getNewStatus());
            ft1.cancel();
            senderStatusListener.waitForEvent(4000L);
            FileTransferStatusChangeEvent stat2 = senderStatusListener.collectedEvents.get(0);
            senderStatusListener.collectedEvents.clear();
            TestOperationSetFileTransfer.assertEquals((String)"Event must be canceled", (int)1, (int)stat2.getNewStatus());
            receiverFTListerner.waitForEvent(4000L);
            TestOperationSetFileTransfer.assertEquals((String)"A file transfer created must be received on receiver side", (int)1, (int)receiverFTListerner.collectedEvents.size());
            fileTransferCreatedEvent = (FileTransferCreatedEvent)receiverFTListerner.collectedEvents.get(0);
            TestOperationSetFileTransfer.assertEquals((String)"FileTransfer file", (Object)fileTransferCreatedEvent.getFileTransfer().getLocalFile(), (Object)receiveFile);
            receiverStatusListener.waitForEvent(4000L, 3);
            TestOperationSetFileTransfer.assertTrue((String)"Cancel event must be received", (boolean)receiverStatusListener.contains(1));
        }
        finally {
            ftOpSet1.removeFileTransferListener((FileTransferListener)senderFTListerner);
            ftOpSet2.addFileTransferListener((FileTransferListener)receiverFTListerner);
        }
    }

    private static String statusToString(int s) {
        switch (s) {
            case 1: {
                return "canceled";
            }
            case 0: {
                return "completed";
            }
            case 2: {
                return "failed";
            }
            case 4: {
                return "in_progress";
            }
            case 6: {
                return "preparing";
            }
            case 3: {
                return "refused";
            }
        }
        return "waiting";
    }

    public abstract void start() throws Exception;

    public abstract BundleContext getContext();

    public abstract Contact getContact1();

    public abstract Contact getContact2();

    public abstract OperationSetFileTransfer getOpSetFilTransfer1();

    public abstract OperationSetFileTransfer getOpSetFilTransfer2();

    public abstract boolean enableTestSendAndReceive();

    public abstract boolean enableTestSenderCancelBeforeAccepted();

    public abstract boolean enableTestReceiverDecline();

    public abstract boolean enableTestReceiverCancelsWhileTransfering();

    public abstract boolean enableTestSenderCancelsWhileTransfering();

    public abstract void stop() throws Exception;

    public class FileTransferStatusEventCollector
    implements FileTransferStatusListener {
        public ArrayList<FileTransferStatusChangeEvent> collectedEvents = new ArrayList();
        private String name = null;
        private int eventsNum = 1;

        FileTransferStatusEventCollector(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor, int eventsNum) {
            this.eventsNum = eventsNum;
            logger.trace((Object)"Waiting for a FileTransfer Status Event");
            FileTransferStatusEventCollector fileTransferStatusEventCollector = this;
            synchronized (fileTransferStatusEventCollector) {
                if (this.collectedEvents.size() > eventsNum - 1) {
                    logger.trace((Object)("Event already received. " + this.collectedEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedEvents.size() > eventsNum - 1) {
                        logger.trace((Object)"Received a FileTransferEvent.");
                    } else {
                        logger.trace((Object)("Not enough FileTransferEvent received for" + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a FileTransferEvent", (Throwable)ex);
                }
            }
        }

        public void waitForEvent(long waitFor) {
            this.waitForEvent(waitFor, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void statusChanged(FileTransferStatusChangeEvent event) {
            FileTransferStatusEventCollector fileTransferStatusEventCollector = this;
            synchronized (fileTransferStatusEventCollector) {
                logger.debug((Object)(this.name + " Collected evt(" + this.collectedEvents.size() + ")= " + event + " status:" + TestOperationSetFileTransfer.statusToString(event.getNewStatus())));
                this.collectedEvents.add(event);
                if (this.collectedEvents.size() == this.eventsNum) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(int status) {
            FileTransferStatusEventCollector fileTransferStatusEventCollector = this;
            synchronized (fileTransferStatusEventCollector) {
                Iterator<FileTransferStatusChangeEvent> iter = this.collectedEvents.iterator();
                String statuses = "";
                while (iter.hasNext()) {
                    FileTransferStatusChangeEvent e = iter.next();
                    if (e.getNewStatus() == status) {
                        return true;
                    }
                    statuses = statuses + e.getNewStatus() + " ";
                }
                logger.warn((Object)("Status not found : " + status + " between statuses : " + statuses));
                return false;
            }
        }

        public void clear() {
            this.collectedEvents.clear();
            this.eventsNum = 1;
        }
    }

    public class FileTransferEventCollector
    implements FileTransferListener {
        public final List<EventObject> collectedEvents = new ArrayList<EventObject>();
        private boolean rejected = false;
        private boolean canceled = false;
        private FileTransferStatusEventCollector statusCollector = null;
        private String name = null;

        public FileTransferEventCollector(String name, FileTransferStatusEventCollector statusCollector) {
            this.name = name;
            this.statusCollector = statusCollector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a FileTransferEvent");
            FileTransferEventCollector fileTransferEventCollector = this;
            synchronized (fileTransferEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    logger.trace((Object)("Event already received. " + this.collectedEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedEvents.size() > 0) {
                        logger.trace((Object)"Received a FileTransferEvent.");
                    } else {
                        logger.trace((Object)("No FileTransferEvent received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a FileTransferEvent", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileTransferRequestReceived(FileTransferRequestEvent event) {
            FileTransferEventCollector fileTransferEventCollector = this;
            synchronized (fileTransferEventCollector) {
                logger.debug((Object)(this.name + " Collected evt(" + this.collectedEvents.size() + ")= " + event));
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileTransferCreated(FileTransferCreatedEvent event) {
            FileTransferEventCollector fileTransferEventCollector = this;
            synchronized (fileTransferEventCollector) {
                logger.debug((Object)(this.name + " Collected evt(" + this.collectedEvents.size() + ")= " + event));
                if (this.statusCollector != null) {
                    event.getFileTransfer().addStatusListener((FileTransferStatusListener)this.statusCollector);
                }
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileTransferRequestRejected(FileTransferRequestEvent event) {
            FileTransferEventCollector fileTransferEventCollector = this;
            synchronized (fileTransferEventCollector) {
                logger.debug((Object)(this.name + " Collected evt(" + this.collectedEvents.size() + ")= " + event));
                this.rejected = true;
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileTransferRequestCanceled(FileTransferRequestEvent event) {
            FileTransferEventCollector fileTransferEventCollector = this;
            synchronized (fileTransferEventCollector) {
                logger.debug((Object)(this.name + " Collected evt(" + this.collectedEvents.size() + ")= " + event));
                this.canceled = true;
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        public void clear() {
            this.collectedEvents.clear();
            this.rejected = false;
        }

        public boolean isRejected() {
            return this.rejected;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }
}

