/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.history.records;

import java.util.Date;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;

public class HistoryRecord {
    private final Date timestamp;
    private final String[] propertyNames;
    private final String[] propertyValues;

    public HistoryRecord(HistoryRecordStructure entryStructure, String[] propertyValues) {
        this(entryStructure.getPropertyNames(), propertyValues, new Date());
    }

    public HistoryRecord(String[] propertyNames, String[] propertyValues) {
        this(propertyNames, propertyValues, new Date());
    }

    public HistoryRecord(HistoryRecordStructure entryStructure, String[] propertyValues, Date timestamp) {
        this(entryStructure.getPropertyNames(), propertyValues, timestamp);
    }

    public HistoryRecord(String[] propertyNames, String[] propertyValues, Date timestamp) {
        this.propertyNames = propertyNames;
        this.propertyValues = propertyValues;
        this.timestamp = timestamp;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String[] getPropertyValues() {
        return this.propertyValues;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("History Record: ");
        for (int i = 0; i < this.propertyNames.length; ++i) {
            s.append(this.propertyNames[i]);
            s.append('=');
            s.append(this.propertyValues[i]);
            s.append('\n');
        }
        return s.toString();
    }
}

