/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCipherCTR;

public class SRTPCipherCTRJava
extends SRTPCipherCTR {
    private final byte[] tmpCipherBlock = new byte[16];
    private final BlockCipher cipher;

    public SRTPCipherCTRJava(BlockCipher cipher) {
        this.cipher = cipher;
    }

    @Override
    public void init(byte[] key) {
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new IllegalArgumentException("Not an AES key length");
        }
        this.cipher.init(true, (CipherParameters)new KeyParameter(key));
    }

    @Override
    public void process(byte[] data, int off, int len, byte[] iv) {
        SRTPCipherCTRJava.checkProcessArgs(data, off, len, iv);
        int l = len;
        int o = off;
        while (l >= 16) {
            this.cipher.processBlock(iv, 0, this.tmpCipherBlock, 0);
            iv[15] = (byte)(iv[15] + 1);
            if (iv[15] == 0) {
                iv[14] = (byte)(iv[14] + 1);
            }
            int n = o + 0;
            data[n] = (byte)(data[n] ^ this.tmpCipherBlock[0]);
            int n2 = o + 1;
            data[n2] = (byte)(data[n2] ^ this.tmpCipherBlock[1]);
            int n3 = o + 2;
            data[n3] = (byte)(data[n3] ^ this.tmpCipherBlock[2]);
            int n4 = o + 3;
            data[n4] = (byte)(data[n4] ^ this.tmpCipherBlock[3]);
            int n5 = o + 4;
            data[n5] = (byte)(data[n5] ^ this.tmpCipherBlock[4]);
            int n6 = o + 5;
            data[n6] = (byte)(data[n6] ^ this.tmpCipherBlock[5]);
            int n7 = o + 6;
            data[n7] = (byte)(data[n7] ^ this.tmpCipherBlock[6]);
            int n8 = o + 7;
            data[n8] = (byte)(data[n8] ^ this.tmpCipherBlock[7]);
            int n9 = o + 8;
            data[n9] = (byte)(data[n9] ^ this.tmpCipherBlock[8]);
            int n10 = o + 9;
            data[n10] = (byte)(data[n10] ^ this.tmpCipherBlock[9]);
            int n11 = o + 10;
            data[n11] = (byte)(data[n11] ^ this.tmpCipherBlock[10]);
            int n12 = o + 11;
            data[n12] = (byte)(data[n12] ^ this.tmpCipherBlock[11]);
            int n13 = o + 12;
            data[n13] = (byte)(data[n13] ^ this.tmpCipherBlock[12]);
            int n14 = o + 13;
            data[n14] = (byte)(data[n14] ^ this.tmpCipherBlock[13]);
            int n15 = o + 14;
            data[n15] = (byte)(data[n15] ^ this.tmpCipherBlock[14]);
            int n16 = o + 15;
            data[n16] = (byte)(data[n16] ^ this.tmpCipherBlock[15]);
            l -= 16;
            o += 16;
        }
        if (l > 0) {
            this.cipher.processBlock(iv, 0, this.tmpCipherBlock, 0);
            iv[15] = (byte)(iv[15] + 1);
            if (iv[15] == 0) {
                iv[14] = (byte)(iv[14] + 1);
            }
            for (int i = 0; i < l; ++i) {
                int n = o + i;
                data[n] = (byte)(data[n] ^ this.tmpCipherBlock[i]);
            }
        }
    }
}

