/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.security;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.message.SIPRequest;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TransactionUnavailableException;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.security.CredentialsCache;
import net.java.sip.communicator.impl.protocol.sip.security.CredentialsCacheEntry;
import net.java.sip.communicator.impl.protocol.sip.security.MessageDigestAlgorithm;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.util.Logger;

public class SipSecurityManager {
    private static final Logger logger = Logger.getLogger(SipSecurityManager.class);
    private SecurityAuthority securityAuthority = null;
    private HeaderFactory headerFactory = null;
    private CredentialsCache cachedCredentials = new CredentialsCache();
    private final AccountID accountID;
    private final ProtocolProviderServiceSipImpl protocolProvider;

    public SipSecurityManager(AccountID accountID, ProtocolProviderServiceSipImpl protocolProvider) {
        this.accountID = accountID;
        this.protocolProvider = protocolProvider;
    }

    public void setHeaderFactory(HeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    public synchronized ClientTransaction handleChallenge(Response challenge, ClientTransaction challengedTransaction, SipProvider transactionCreator) throws SipException, InvalidArgumentException, OperationFailedException, NullPointerException {
        return this.handleChallenge(challenge, challengedTransaction, transactionCreator, -1L);
    }

    public synchronized ClientTransaction handleChallenge(Response challenge, ClientTransaction challengedTransaction, SipProvider transactionCreator, long newCSeq) throws SipException, InvalidArgumentException, OperationFailedException, NullPointerException {
        String branchID = challengedTransaction.getBranchId();
        Request challengedRequest = challengedTransaction.getRequest();
        Request reoriginatedRequest = this.cloneReqForAuthentication(challengedRequest, challenge);
        this.incrementRequestSeqNo(reoriginatedRequest, newCSeq);
        ListIterator<WWWAuthenticateHeader> authHeaders = this.extractChallenges(challenge);
        ClientTransaction retryTran = transactionCreator.getNewClientTransaction(reoriginatedRequest);
        Dialog tranDialog = retryTran.getDialog();
        if (tranDialog != null && tranDialog.getLocalSeqNumber() != this.getRequestSeqNo(reoriginatedRequest)) {
            tranDialog.incrementLocalSequenceNumber();
        }
        while (authHeaders.hasNext()) {
            CallIdHeader call;
            WWWAuthenticateHeader authHeader = authHeaders.next();
            String realm = authHeader.getRealm();
            CredentialsCacheEntry ccEntry = this.cachedCredentials.remove(realm);
            boolean ccEntryHasSeenTran = false;
            if (ccEntry != null) {
                ccEntryHasSeenTran = ccEntry.popBranchID(branchID);
            }
            long authenticationDuration = System.currentTimeMillis();
            String storedPassword = SipActivator.getProtocolProviderFactory().loadPassword(this.accountID);
            if (ccEntry == null) {
                if (storedPassword != null) {
                    ccEntry = this.createCcEntryWithStoredPassword(storedPassword);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"seem to have a stored pass! Try with it.");
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"We don't seem to have a good pass! Get one.");
                    }
                    if ((ccEntry = this.createCcEntryWithNewCredentials(realm, 0)) == null) {
                        throw new OperationFailedException("User has canceled the authentication process.", 15);
                    }
                }
            } else if (ccEntryHasSeenTran && !authHeader.isStale()) {
                SipActivator.getProtocolProviderFactory().storePassword(this.accountID, null);
                this.protocolProvider.getRegistrarConnection().setRegistrationState(RegistrationState.AUTHENTICATION_FAILED, 1, null);
                ccEntry = this.createCcEntryWithNewCredentials(realm, 1);
                if (ccEntry == null) {
                    throw new OperationFailedException("User has canceled the authentication process.", 15);
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)"We seem to have a pass in the cache. Let's try with it.");
            }
            if (ccEntry.userCredentials == null) {
                throw new OperationFailedException("Unable to authenticate with realm " + realm + ". User did not provide credentials.", 401);
            }
            boolean authDurTooLong = System.currentTimeMillis() - authenticationDuration > 25000L;
            AuthorizationHeader authorization = this.createAuthorizationHeader(reoriginatedRequest.getMethod(), reoriginatedRequest.getRequestURI().toString(), reoriginatedRequest.getContent() == null ? "" : reoriginatedRequest.getContent().toString(), authHeader, ccEntry.userCredentials);
            if (!authDurTooLong) {
                ccEntry.pushBranchID(retryTran.getBranchId());
            }
            this.cachedCredentials.cacheEntry(realm, ccEntry);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created authorization header: " + authorization.toString()));
            }
            if ((call = (CallIdHeader)reoriginatedRequest.getHeader("Call-ID")) != null) {
                String callid = call.getCallId();
                this.cachedCredentials.cacheAuthorizationHeader(callid, authorization);
            }
            reoriginatedRequest.addHeader((Header)authorization);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Returning authorization transaction.");
        }
        return retryTran;
    }

    public void setSecurityAuthority(SecurityAuthority authority) {
        this.securityAuthority = authority;
    }

    public SecurityAuthority getSecurityAuthority() {
        return this.securityAuthority;
    }

    public synchronized ClientTransaction handleForbiddenResponse(Response forbidden, ClientTransaction endedTransaction, SipProvider transactionCreator) throws InvalidArgumentException, TransactionUnavailableException, OperationFailedException {
        this.cachedCredentials.clear();
        SipActivator.getProtocolProviderFactory().storePassword(this.accountID, null);
        Request challengedRequest = endedTransaction.getRequest();
        Request reoriginatedRequest = (Request)challengedRequest.clone();
        this.removeBranchID(reoriginatedRequest);
        List<String> realms = this.removeAuthHeaders(reoriginatedRequest);
        if (realms.size() == 0) {
            throw new OperationFailedException("No realms present, cannot authenticate", 403);
        }
        this.incrementRequestSeqNo(reoriginatedRequest, -1L);
        ClientTransaction retryTran = transactionCreator.getNewClientTransaction(reoriginatedRequest);
        Dialog tranDialog = retryTran.getDialog();
        if (tranDialog != null && tranDialog.getLocalSeqNumber() != this.getRequestSeqNo(reoriginatedRequest)) {
            tranDialog.incrementLocalSequenceNumber();
        }
        Iterator<String> realmsIter = realms.iterator();
        while (realmsIter.hasNext()) {
            CredentialsCacheEntry ccEntry = this.createCcEntryWithStoredPassword("");
            ccEntry.pushBranchID(retryTran.getBranchId());
            this.cachedCredentials.cacheEntry(realmsIter.next(), ccEntry);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Returning authorization transaction.");
        }
        return retryTran;
    }

    private List<String> removeAuthHeaders(Request request) {
        Iterator headers = ((SIPRequest)request).getHeaders();
        LinkedList<String> realms = new LinkedList<String>();
        this.removeAuthHeaders(headers, realms);
        request.removeHeader("Authorization");
        request.removeHeader("Proxy-Authorization");
        return realms;
    }

    private void removeAuthHeaders(Iterator<SIPHeader> headers, List<String> realms) {
        while (headers.hasNext()) {
            SIPHeader header = headers.next();
            if (header instanceof AuthorizationHeader) {
                realms.add(((AuthorizationHeader)header).getRealm());
                continue;
            }
            if (!(header instanceof SIPHeaderList)) continue;
            Iterator hdrListIter = ((SIPHeaderList)header).iterator();
            this.removeAuthHeaders(hdrListIter, realms);
        }
    }

    private Request cloneReqForAuthentication(Request challengedRequest, Response challenge) {
        Request reoriginatedRequest = (Request)challengedRequest.clone();
        this.removeBranchID(reoriginatedRequest);
        if (challenge.getStatusCode() == 401) {
            reoriginatedRequest.removeHeader("Authorization");
        } else if (challenge.getStatusCode() == 407) {
            reoriginatedRequest.removeHeader("Proxy-Authorization");
        }
        return reoriginatedRequest;
    }

    private ListIterator<WWWAuthenticateHeader> extractChallenges(Response challenge) {
        ListIterator authHeaders = null;
        if (challenge.getStatusCode() == 401) {
            authHeaders = challenge.getHeaders("WWW-Authenticate");
        } else if (challenge.getStatusCode() == 407) {
            authHeaders = challenge.getHeaders("Proxy-Authenticate");
        }
        return authHeaders;
    }

    private AuthorizationHeader createAuthorizationHeader(String method, String uri, String requestBody, WWWAuthenticateHeader authHeader, UserCredentials userCredentials) throws OperationFailedException {
        String response = null;
        String qopList = authHeader.getQop();
        String qop = qopList != null ? "auth" : null;
        String nc_value = "00000001";
        String cnonce = "xyz";
        try {
            response = MessageDigestAlgorithm.calculateResponse(authHeader.getAlgorithm(), userCredentials.getUserName(), authHeader.getRealm(), new String(userCredentials.getPassword()), authHeader.getNonce(), nc_value, cnonce, method, uri, requestBody, qop);
        }
        catch (NullPointerException exc) {
            throw new OperationFailedException("The authenticate header was malformatted", 1, (Throwable)exc);
        }
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader ? this.headerFactory.createProxyAuthorizationHeader(authHeader.getScheme()) : this.headerFactory.createAuthorizationHeader(authHeader.getScheme());
            authorization.setUsername(userCredentials.getUserName());
            authorization.setRealm(authHeader.getRealm());
            authorization.setNonce(authHeader.getNonce());
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (authHeader.getAlgorithm() != null) {
                authorization.setAlgorithm(authHeader.getAlgorithm());
            }
            if (authHeader.getOpaque() != null) {
                authorization.setOpaque(authHeader.getOpaque());
            }
            if (qop != null) {
                authorization.setQop(qop);
                authorization.setCNonce(cnonce);
                authorization.setNonceCount(Integer.parseInt(nc_value));
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new SecurityException("Failed to create an authorization header!");
        }
        return authorization;
    }

    public void cacheCredentials(String realm, UserCredentials credentials) {
        CredentialsCacheEntry ccEntry = new CredentialsCacheEntry();
        ccEntry.userCredentials = credentials;
        this.cachedCredentials.cacheEntry(realm, ccEntry);
    }

    private void removeBranchID(Request request) {
        block2: {
            ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
            request.removeHeader("Via");
            try {
                ViaHeader newViaHeader = this.headerFactory.createViaHeader(viaHeader.getHost(), viaHeader.getPort(), viaHeader.getTransport(), null);
                request.setHeader((Header)newViaHeader);
            }
            catch (Exception exc) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"failed to reset a Via header");
            }
        }
    }

    private CredentialsCacheEntry createCcEntryWithNewCredentials(String realm, int reasonCode) {
        CredentialsCacheEntry ccEntry = new CredentialsCacheEntry();
        UserCredentials defaultCredentials = new UserCredentials();
        String authName = this.accountID.getAccountPropertyString((Object)"AUTHORIZATION_NAME");
        if (authName != null && authName.length() > 0) {
            defaultCredentials.setUserName(authName);
        } else {
            defaultCredentials.setUserName(this.accountID.getUserID());
        }
        UserCredentials newCredentials = this.getSecurityAuthority().obtainCredentials(this.accountID.getDisplayName(), defaultCredentials, reasonCode);
        if (newCredentials == null) {
            return null;
        }
        if (newCredentials.getPassword() == null) {
            return null;
        }
        ccEntry.userCredentials = newCredentials;
        if (ccEntry.userCredentials != null && ccEntry.userCredentials.isPasswordPersistent()) {
            SipActivator.getProtocolProviderFactory().storePassword(this.accountID, ccEntry.userCredentials.getPasswordAsString());
        }
        return ccEntry;
    }

    private CredentialsCacheEntry createCcEntryWithStoredPassword(String password) {
        CredentialsCacheEntry ccEntry = new CredentialsCacheEntry();
        ccEntry.userCredentials = new UserCredentials();
        String authName = this.accountID.getAccountPropertyString((Object)"AUTHORIZATION_NAME");
        if (authName != null && authName.length() > 0) {
            ccEntry.userCredentials.setUserName(authName);
        } else {
            ccEntry.userCredentials.setUserName(this.accountID.getUserID());
        }
        ccEntry.userCredentials.setPassword(password.toCharArray());
        return ccEntry;
    }

    public AuthorizationHeader getCachedAuthorizationHeader(String callID) {
        return this.cachedCredentials.getCachedAuthorizationHeader(callID);
    }

    private void incrementRequestSeqNo(Request request, long newCSeq) throws InvalidArgumentException {
        CSeqHeader cSeq = (CSeqHeader)request.getHeader("CSeq");
        if (newCSeq == -1L) {
            cSeq.setSeqNumber(cSeq.getSeqNumber() + 1L);
        } else {
            cSeq.setSeqNumber(newCSeq);
        }
    }

    private long getRequestSeqNo(Request request) {
        CSeqHeader cSeq = (CSeqHeader)request.getHeader("CSeq");
        return cSeq.getSeqNumber();
    }
}

