/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DesktopSharingProtocolSipImpl {
    public static final String EVENT_PACKAGE = "remote-control";
    public static final int REFRESH_MARGIN = 60;
    public static final int SUBSCRIPTION_DURATION = 3600;
    public static final String CONTENT_SUB_TYPE = "remote-control+xml";
    private static final String ELEMENT_REMOTE_CONTROL = "remote-control";
    private static final String ELEMENT_MOUSE_MOVE = "mouse-move";
    private static final String ELEMENT_MOUSE_WHEEL = "mouse-wheel";
    private static final String ELEMENT_MOUSE_PRESS = "mouse-press";
    private static final String ELEMENT_MOUSE_RELEASE = "mouse-release";
    private static final String ELEMENT_KEY_PRESS = "key-press";
    private static final String ELEMENT_KEY_RELEASE = "key-release";
    private static final String ELEMENT_KEY_TYPE = "key-type";
    private static final Component component = new Canvas();

    private static void append(StringBuffer stringBuffer, String ... strings) {
        for (String str : strings) {
            stringBuffer.append(str);
        }
    }

    public static String getKeyPressedXML(int keycode) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        DesktopSharingProtocolSipImpl.append(xml, "<", "remote-control", ">");
        DesktopSharingProtocolSipImpl.append(xml, "<", ELEMENT_KEY_PRESS);
        DesktopSharingProtocolSipImpl.append(xml, " keycode=\"", Integer.toString(keycode), "\" />");
        DesktopSharingProtocolSipImpl.append(xml, "</", "remote-control", ">");
        return xml.toString();
    }

    public static String getKeyReleasedXML(int keycode) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        DesktopSharingProtocolSipImpl.append(xml, "<", "remote-control", ">");
        DesktopSharingProtocolSipImpl.append(xml, "<", ELEMENT_KEY_RELEASE);
        DesktopSharingProtocolSipImpl.append(xml, " keycode=\"", Integer.toString(keycode), "\" />");
        DesktopSharingProtocolSipImpl.append(xml, "</", "remote-control", ">");
        return xml.toString();
    }

    public static String getKeyTypedXML(int keycode) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        DesktopSharingProtocolSipImpl.append(xml, "<", "remote-control", ">");
        DesktopSharingProtocolSipImpl.append(xml, "<", ELEMENT_KEY_TYPE);
        DesktopSharingProtocolSipImpl.append(xml, " keychar=\"", Integer.toString(keycode), "\" />");
        DesktopSharingProtocolSipImpl.append(xml, "</", "remote-control", ">");
        return xml.toString();
    }

    public static String getMousePressedXML(int btns) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        DesktopSharingProtocolSipImpl.append(xml, "<", "remote-control", ">");
        DesktopSharingProtocolSipImpl.append(xml, "<", ELEMENT_MOUSE_PRESS);
        DesktopSharingProtocolSipImpl.append(xml, " btns=\"", Integer.toString(btns), "\" />");
        DesktopSharingProtocolSipImpl.append(xml, "</", "remote-control", ">");
        return xml.toString();
    }

    public static String getMouseReleasedXML(int btns) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        DesktopSharingProtocolSipImpl.append(xml, "<", "remote-control", ">");
        DesktopSharingProtocolSipImpl.append(xml, "<", ELEMENT_MOUSE_RELEASE);
        DesktopSharingProtocolSipImpl.append(xml, " btns=\"", Integer.toString(btns), "\" />");
        DesktopSharingProtocolSipImpl.append(xml, "</", "remote-control", ">");
        return xml.toString();
    }

    public static String getMouseMovedXML(double x, double y) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        DesktopSharingProtocolSipImpl.append(xml, "<", "remote-control", ">");
        DesktopSharingProtocolSipImpl.append(xml, "<", ELEMENT_MOUSE_MOVE);
        DesktopSharingProtocolSipImpl.append(xml, " x=\"", Double.toString(x), "\" y=\"", Double.toString(y), "\" />");
        DesktopSharingProtocolSipImpl.append(xml, "</", "remote-control", ">");
        return xml.toString();
    }

    public static String getMouseWheelXML(int notch) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        DesktopSharingProtocolSipImpl.append(xml, "<", "remote-control", ">");
        DesktopSharingProtocolSipImpl.append(xml, "<", ELEMENT_MOUSE_WHEEL);
        DesktopSharingProtocolSipImpl.append(xml, " notch=\"", Integer.toString(notch), "\" />");
        DesktopSharingProtocolSipImpl.append(xml, "</", "remote-control", ">");
        return xml.toString();
    }

    public static List<ComponentEvent> parse(Element root, Dimension size, Point origin) {
        MouseEvent me;
        Element el;
        int i;
        ArrayList<ComponentEvent> events = new ArrayList<ComponentEvent>();
        NodeList nl = null;
        int originX = origin != null ? origin.x : 0;
        int originY = origin != null ? origin.y : 0;
        nl = root.getElementsByTagName(ELEMENT_MOUSE_PRESS);
        if (nl != null) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                if (!el.hasAttribute("btns")) continue;
                me = new MouseEvent(component, 501, System.currentTimeMillis(), Integer.parseInt(el.getAttribute("btns")), 0, 0, 0, false, 0);
                events.add(me);
            }
        }
        if ((nl = root.getElementsByTagName(ELEMENT_MOUSE_RELEASE)) != null) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                if (!el.hasAttribute("btns")) continue;
                me = new MouseEvent(component, 502, System.currentTimeMillis(), Integer.parseInt(el.getAttribute("btns")), 0, 0, 0, false, 0);
                events.add(me);
            }
        }
        if ((nl = root.getElementsByTagName(ELEMENT_MOUSE_MOVE)) != null) {
            int x = -1;
            int y = -1;
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Element el2 = (Element)nl.item(i2);
                if (el2.hasAttribute("x")) {
                    x = (int)(Double.parseDouble(el2.getAttribute("x")) * (double)size.width + (double)originX);
                }
                if (el2.hasAttribute("y")) {
                    y = (int)(Double.parseDouble(el2.getAttribute("y")) * (double)size.height + (double)originY);
                }
                MouseEvent me2 = new MouseEvent(component, 503, System.currentTimeMillis(), 0, x, y, 0, false, 0);
                events.add(me2);
            }
        }
        if ((nl = root.getElementsByTagName(ELEMENT_MOUSE_WHEEL)) != null) {
            for (i = 0; i < nl.getLength(); ++i) {
                Element el3 = (Element)nl.item(i);
                if (!el3.hasAttribute("notch")) continue;
                MouseWheelEvent me3 = new MouseWheelEvent(component, 507, System.currentTimeMillis(), 0, 0, 0, 0, false, 0, 0, Integer.parseInt(el3.getAttribute("notch")));
                events.add(me3);
            }
        }
        if ((nl = root.getElementsByTagName(ELEMENT_KEY_PRESS)) != null) {
            for (i = 0; i < nl.getLength(); ++i) {
                Element el4 = (Element)nl.item(i);
                if (!el4.hasAttribute("keycode")) continue;
                KeyEvent ke = new KeyEvent(component, 401, System.currentTimeMillis(), 0, Integer.parseInt(el4.getAttribute("keycode")), '\u0000');
                events.add(ke);
            }
        }
        if ((nl = root.getElementsByTagName(ELEMENT_KEY_RELEASE)) != null) {
            for (i = 0; i < nl.getLength(); ++i) {
                Element el5 = (Element)nl.item(i);
                if (!el5.hasAttribute("keycode")) continue;
                KeyEvent ke = new KeyEvent(component, 402, System.currentTimeMillis(), 0, Integer.parseInt(el5.getAttribute("keycode")), '\u0000');
                events.add(ke);
            }
        }
        if ((nl = root.getElementsByTagName(ELEMENT_KEY_TYPE)) != null) {
            for (i = 0; i < nl.getLength(); ++i) {
                Element el6 = (Element)nl.item(i);
                if (!el6.hasAttribute("keychar")) continue;
                KeyEvent ke = new KeyEvent(component, 400, System.currentTimeMillis(), 0, 0, (char)Integer.parseInt(el6.getAttribute("keychar")));
                events.add(ke);
            }
        }
        return events;
    }
}

