/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.xml.namespace.QName;
import net.java.sip.communicator.impl.protocol.sip.ContactGroupSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.DisplayNameType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.EntryType;
import net.java.sip.communicator.service.protocol.AbstractContact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.w3c.dom.Element;

public class ContactSipImpl
extends AbstractContact {
    private static final String XCAP_RESOLVED_PROPERTY = "xcap.resolved";
    private final ProtocolProviderServiceSipImpl parentProvider;
    private ContactGroupSipImpl parentGroup = null;
    private PresenceStatus presenceStatus;
    private URI imageUri;
    private byte[] image;
    private boolean isPersistent = true;
    private boolean isResolved = false;
    private boolean isResolvable = true;
    private boolean xCapResolved = false;
    private final EntryType entry;
    private final Address sipAddress;
    private String subscriptionState;

    public ContactSipImpl(Address contactAddress, ProtocolProviderServiceSipImpl parentProvider) {
        this.sipAddress = contactAddress;
        this.entry = new EntryType(contactAddress.getURI().toString());
        this.parentProvider = parentProvider;
        this.presenceStatus = parentProvider.getSipStatusEnum().getStatus("Unknown");
    }

    EntryType getEntry() {
        return this.entry;
    }

    public String getUri() {
        return this.entry.getUri();
    }

    void setParentGroup(ContactGroupSipImpl newParentGroup) {
        this.parentGroup = newParentGroup;
    }

    public String getAddress() {
        SipURI sipURI = (SipURI)this.sipAddress.getURI();
        return sipURI.toString().substring(sipURI.getScheme().length() + 1);
    }

    public Address getSipAddress() {
        return this.sipAddress;
    }

    public String getDisplayName() {
        if (this.entry.getDisplayName() != null) {
            return this.entry.getDisplayName().getValue();
        }
        SipURI sipURI = (SipURI)this.sipAddress.getURI();
        String sipUserName = sipURI.getUser();
        if (sipUserName != null && sipUserName.length() > 0) {
            return sipUserName;
        }
        if (this.getAddress().startsWith("sip:")) {
            return this.getAddress().substring(4);
        }
        return this.getAddress();
    }

    public void setDisplayName(String displayName) {
        DisplayNameType displayNameType = new DisplayNameType();
        displayNameType.setValue(displayName);
        this.entry.setDisplayName(displayNameType);
    }

    public void setDisplayName(DisplayNameType displayName) {
        this.entry.setDisplayName(displayName);
    }

    void setOtherAttributes(Map<QName, String> otherAttributes) {
        this.entry.setAnyAttributes(otherAttributes);
    }

    void setAny(List<Element> any) {
        this.entry.setAny(any);
    }

    List<Element> getAny() {
        return this.entry.getAny();
    }

    URI getImageUri() {
        return this.imageUri;
    }

    void setImageUri(URI imageUri) {
        this.imageUri = imageUri;
    }

    public byte[] getImage() {
        return this.image;
    }

    void setImage(byte[] image) {
        this.image = image;
    }

    public PresenceStatus getPresenceStatus() {
        return this.presenceStatus;
    }

    public void setPresenceStatus(PresenceStatus sipPresenceStatus) {
        this.presenceStatus = sipPresenceStatus;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.parentProvider;
    }

    public boolean isLocal() {
        return false;
    }

    public ContactGroup getParentContactGroup() {
        return this.parentGroup;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("ContactSipImpl[ DisplayName=").append(this.getDisplayName()).append("]");
        return buff.toString();
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public boolean isXCapResolved() {
        return this.xCapResolved;
    }

    public void setXCapResolved(boolean xCapResolved) {
        this.xCapResolved = xCapResolved;
    }

    public String getPersistentData() {
        return "xcap.resolved=" + Boolean.toString(this.xCapResolved) + ";";
    }

    public void setPersistentData(String persistentData) {
        if (persistentData == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(persistentData, ";");
        while (tokenizer.hasMoreTokens()) {
            String[] data = tokenizer.nextToken().split("=");
            if (!data[0].equals(XCAP_RESOLVED_PROPERTY) || data.length <= 1) continue;
            this.xCapResolved = Boolean.valueOf(data[1]);
        }
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setResolved(boolean resolved) {
        this.isResolved = resolved;
    }

    public boolean isResolvable() {
        return this.isResolvable;
    }

    public void setResolvable(boolean resolvable) {
        this.isResolvable = resolvable;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContactSipImpl) && !(obj instanceof String)) {
            return false;
        }
        if (obj instanceof String) {
            String sobj = (String)obj;
            sobj = ContactSipImpl.stripScheme(ContactSipImpl.stripAddress(sobj));
            if (this.getAddress().equalsIgnoreCase(sobj)) {
                return true;
            }
            SipURI sipURI = (SipURI)this.sipAddress.getURI();
            return sipURI.getUser().equalsIgnoreCase(sobj);
        }
        ContactSipImpl sipContact = (ContactSipImpl)((Object)obj);
        return this.getAddress().equals(sipContact.getAddress());
    }

    static String stripAddress(String address) {
        if (address != null && address.length() > 0) {
            int idx = address.indexOf(58, 5);
            if (idx > -1) {
                address = address.substring(0, idx);
            }
            if ((idx = address.indexOf(59)) > -1) {
                address = address.substring(0, idx);
            }
        }
        return address;
    }

    public static String stripScheme(String from) {
        if (from.startsWith("sip:")) {
            return from.substring(4);
        }
        if (from.startsWith("sips:")) {
            return from.substring(5);
        }
        return from;
    }

    public OperationSetPresenceSipImpl getParentPresenceOperationSet() {
        return (OperationSetPresenceSipImpl)this.parentProvider.getOperationSet(OperationSetPresence.class);
    }

    public String getStatusMessage() {
        return null;
    }

    public String getSubscriptionState() {
        return this.subscriptionState;
    }

    public void setSubscriptionState(String subscriptionState) {
        this.subscriptionState = subscriptionState;
    }

    public boolean supportResources() {
        return false;
    }

    public Collection<ContactResource> getResources() {
        return null;
    }
}

