/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globalshortcut;

import java.awt.AWTKeyStroke;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.globalshortcut.GlobalShortcutActivator;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutEvent;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutListener;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.keybindings.GlobalKeybindingSet;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.util.Logger;

public class UIShortcut
implements GlobalShortcutListener {
    private static final Logger logger = Logger.getLogger(UIShortcut.class);
    private KeybindingsService keybindingsService = GlobalShortcutActivator.getKeybindingsService();

    @Override
    public synchronized void shortcutReceived(GlobalShortcutEvent evt) {
        AWTKeyStroke keystroke = evt.getKeyStroke();
        GlobalKeybindingSet set = this.keybindingsService.getGlobalBindings();
        if (keystroke == null) {
            return;
        }
        try {
            for (Map.Entry entry : set.getBindings().entrySet()) {
                for (AWTKeyStroke ks : (List)entry.getValue()) {
                    if (ks == null || !((String)entry.getKey()).equals("contactlist") || keystroke.getKeyCode() != ks.getKeyCode() || keystroke.getModifiers() != ks.getModifiers()) continue;
                    ExportedWindow window = GlobalShortcutActivator.getUIService().getExportedWindow(ExportedWindow.MAIN_WINDOW);
                    if (window == null) {
                        return;
                    }
                    this.setVisible(window, window.isVisible());
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.info((Object)"Failed to execute contactlist action", t);
        }
    }

    private void setVisible(final ExportedWindow window, final boolean visible) {
        new Thread(){

            @Override
            public void run() {
                if (!visible) {
                    window.bringToFront();
                    window.setVisible(true);
                    if (window instanceof Window) {
                        ((Window)window).setAlwaysOnTop(true);
                        ((Window)window).setAlwaysOnTop(false);
                    }
                } else {
                    window.setVisible(false);
                }
            }
        }.start();
    }
}

