/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.geo.Namespaces;
import java.text.NumberFormat;

@ExtensionDescription.Default(nsAlias="geo", nsUri="http://www.w3.org/2003/01/geo/wgs84_pos#", localName="long")
public class GeoLong
extends ValueConstruct {
    public static final double MAX_LONG = 180.0;
    public static final double MIN_LONG = -180.0;
    public static final int COORDINATE_PRECISION = 6;
    private static final NumberFormat NUM_FORMAT = NumberFormat.getInstance();
    private Double lon = null;

    public GeoLong() {
        this((Double)null);
    }

    public GeoLong(Double lon) throws IllegalArgumentException {
        super(Namespaces.W3C_GEO_NAMESPACE, "long", null, null);
        this.setRequired(true);
        if (lon != null) {
            this.setLongitude(lon);
            this.setImmutable(true);
        }
    }

    public Double getLongitude() {
        return this.lon;
    }

    public void setLongitude(Double longitude) {
        this.lon = longitude;
        String value = null;
        if (longitude != null) {
            if (longitude.compareTo(-180.0) < 0 || longitude.compareTo(180.0) > 0) {
                throw new IllegalArgumentException("Longitude must be between -180 and 180 degrees.");
            }
            value = NUM_FORMAT.format(longitude);
        }
        super.setValue(value);
    }

    @Override
    public void setValue(String value) {
        Double d = null;
        if (value != null) {
            try {
                d = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("'value' must be a double.");
            }
        }
        this.setLongitude(d);
    }

    static {
        NUM_FORMAT.setMaximumFractionDigits(6);
        NUM_FORMAT.setMinimumFractionDigits(6);
    }
}

