/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.AbstractConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.xmlpull.v1.XmlPullParser;

public class XMPPConnection
extends AbstractConnection {
    private static final Logger LOGGER = Logger.getLogger(XMPPConnection.class.getName());
    private Socket socket;
    private boolean usingTLS = false;
    private Collection<String> compressionMethods;
    private boolean usingCompression;

    public XMPPConnection(String serviceName, CallbackHandler callbackHandler) {
        super(new ConnectionConfiguration(serviceName));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
        this.config.setCallbackHandler(callbackHandler);
    }

    public XMPPConnection(String serviceName) {
        super(new ConnectionConfiguration(serviceName));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
    }

    public XMPPConnection(ConnectionConfiguration config) {
        super(config);
    }

    public XMPPConnection(ConnectionConfiguration config, CallbackHandler callbackHandler) {
        super(config);
        config.setCallbackHandler(callbackHandler);
    }

    @Override
    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    @Override
    public void shutdown(Presence unavailablePresence) {
        super.shutdown(unavailablePresence);
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void connectUsingConfiguration(ConnectionConfiguration config) throws XMPPException {
        String host = config.getHost();
        int port = config.getPort();
        try {
            this.socket = config.getSocketFactory() == null ? new Socket(host, port) : config.getSocketFactory().createSocket(host, port);
        }
        catch (UnknownHostException uhe) {
            String errorMessage = "Could not connect to " + host + ":" + port + ".";
            throw new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.remote_server_timeout, errorMessage), uhe);
        }
        catch (IOException ioe) {
            String errorMessage = "XMPPError connecting to " + host + ":" + port + ".";
            throw new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.remote_server_error, errorMessage), ioe);
        }
    }

    @Override
    protected void initConnectionFailed(XMPPException ex) {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    @Override
    protected void onSuccessReceived() throws IOException {
        this.packetWriter.openStream();
        this.packetReader.resetParser();
    }

    @Override
    protected void initConnection() throws XMPPException {
        boolean isFirstInitialization;
        boolean bl = isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        if (!isFirstInitialization) {
            this.usingCompression = false;
        }
        super.initConnection();
    }

    @Override
    protected PacketWriter createPacketWriter() {
        return new TCPXmppPacketWriter();
    }

    @Override
    protected PacketReader createPacketReader() {
        return new TCPXmppPacketReader();
    }

    @Override
    protected void initReaderAndWriter() throws XMPPException {
        try {
            if (!this.usingCompression) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    Class<?> zoClass = Class.forName("com.jcraft.jzlib.ZOutputStream");
                    Constructor<?> constructor = zoClass.getConstructor(OutputStream.class, Integer.TYPE);
                    Object out = constructor.newInstance(this.socket.getOutputStream(), 9);
                    Method method = zoClass.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(out, 2);
                    this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    Class<?> ziClass = Class.forName("com.jcraft.jzlib.ZInputStream");
                    constructor = ziClass.getConstructor(InputStream.class);
                    Object in = constructor.newInstance(this.socket.getInputStream());
                    method = ziClass.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(in, 2);
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Error writing packet", e);
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), ioe);
        }
        super.initReaderAndWriter();
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    private void startTLSReceived(boolean required) {
        if (required && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.packetReader.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.packetReader.notifyConnectionError(e);
        }
    }

    private void proceedTLSReceived() throws Exception {
        KeyStore ks = null;
        KeyManager[] kms = null;
        PasswordCallback pcb = null;
        if (this.config.getCallbackHandler() == null) {
            ks = null;
        } else {
            if (this.config.getKeystoreType().equals("NONE")) {
                ks = null;
                pcb = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    Constructor<?> c = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String pkcs11Config = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream config = new ByteArrayInputStream(pkcs11Config.getBytes());
                    Provider p = (Provider)c.newInstance(config);
                    Security.addProvider(p);
                    ks = KeyStore.getInstance("PKCS11", p);
                    pcb = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(null, pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                ks = KeyStore.getInstance("KeychainStore", "Apple");
                ks.load(null, null);
            } else {
                ks = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    pcb = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(new FileInputStream(this.config.getKeystorePath()), pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            try {
                if (pcb == null) {
                    kmf.init(ks, null);
                } else {
                    kmf.init(ks, pcb.getPassword());
                    pcb.clearPassword();
                }
                kms = kmf.getKeyManagers();
            }
            catch (NullPointerException npe) {
                kms = null;
            }
        }
        SSLContext context = this.config.getCustomSSLContext();
        if (context == null) {
            context = SSLContext.getInstance("TLS");
            context.init(kms, new TrustManager[]{new ServerTrustManager(this.getServiceName(), this.config)}, new SecureRandom());
        }
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostAddress(), plain.getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        SSLSocket sslSocket = (SSLSocket)this.socket;
        TLSUtils.setEnabledProtocolsAndCiphers(sslSocket, this.config.getEnabledSSLProtocols(), this.config.getEnabledSSLCiphers());
        sslSocket.startHandshake();
        this.usingTLS = true;
        this.packetReader.resetParser();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    private void setAvailableCompressionMethods(Collection<String> methods) {
        this.compressionMethods = methods;
    }

    private boolean hasAvailableCompressionMethod(String method) {
        return this.compressionMethods != null && this.compressionMethods.contains(method);
    }

    @Override
    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean useCompression() {
        if (this.isAuthenticated()) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        try {
            Class.forName("com.jcraft.jzlib.ZOutputStream");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot use compression. Add smackx.jar to the classpath");
        }
        if (this.hasAvailableCompressionMethod("zlib")) {
            this.requestStreamCompression();
            XMPPConnection xMPPConnection = this;
            synchronized (xMPPConnection) {
                try {
                    this.wait(SmackConfiguration.getPacketReplyTimeout() * 5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.usingCompression;
        }
        return false;
    }

    private void requestStreamCompression() {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>zlib</method></compress>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.packetReader.notifyConnectionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStreamCompression() throws Exception {
        this.usingCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamCompressionDenied() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    private class TCPXmppPacketReader
    extends PacketReader {
        private boolean startTLSReceived;
        private boolean startTLSRequired;

        private TCPXmppPacketReader() {
            super(XMPPConnection.this, "stream");
        }

        @Override
        protected void init() {
            super.init();
            this.startTLSReceived = false;
            this.startTLSRequired = false;
        }

        @Override
        protected void doParsePackets(XmlPullParser parser) throws Exception {
            int eventType = parser.getEventType();
            boolean consumed = false;
            if (eventType == 2) {
                if (parser.getName().equals("stream")) {
                    if ("jabber:client".equals(parser.getNamespace(null))) {
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            if (parser.getAttributeName(i).equals("id")) {
                                String connectionID = parser.getAttributeValue(i);
                                String version = parser.getAttributeValue("", "version");
                                XMPPConnection.this.connectionID = connectionID;
                                if ("1.0".equals(version)) continue;
                                XMPPConnection.this.connected = true;
                                this.releaseConnectionIDLock();
                                continue;
                            }
                            if (!parser.getAttributeName(i).equals("from")) continue;
                            XMPPConnection.this.config.setServiceName(parser.getAttributeValue(i));
                        }
                    }
                } else if (parser.getName().equals("failure")) {
                    String namespace = parser.getNamespace(null);
                    if ("urn:ietf:params:xml:ns:xmpp-tls".equals(namespace)) {
                        throw new Exception("TLS negotiation has failed");
                    }
                    if ("http://jabber.org/protocol/compress".equals(namespace)) {
                        XMPPConnection.this.streamCompressionDenied();
                        consumed = true;
                    }
                } else if (parser.getName().equals("proceed")) {
                    XMPPConnection.this.proceedTLSReceived();
                } else if (parser.getName().equals("compressed")) {
                    XMPPConnection.this.startStreamCompression();
                    XMPPConnection.this.packetReader.resetParser();
                }
            }
            if (!consumed) {
                super.doParsePackets(parser);
            }
        }

        @Override
        protected void doParseFeatures(XmlPullParser parser) throws Exception {
            super.doParseFeatures(parser);
            boolean lastLoop = false;
            int eventType = parser.getEventType();
            String name = parser.getName();
            if (eventType == 2) {
                if ("starttls".equals(name)) {
                    this.startTLSReceived = true;
                } else if (parser.getName().equals("compression")) {
                    XMPPConnection.this.setAvailableCompressionMethods(PacketParserUtils.parseCompressionMethods(parser));
                }
            } else if (eventType == 3) {
                if (name.equals("starttls")) {
                    XMPPConnection.this.startTLSReceived(this.startTLSRequired);
                } else if (name.equals("required") && this.startTLSReceived) {
                    this.startTLSRequired = true;
                } else if (name.equals("features")) {
                    lastLoop = true;
                }
            }
            if (lastLoop) {
                if (!XMPPConnection.this.isSecureConnection() && !this.startTLSReceived && XMPPConnection.this.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
                    throw new XMPPException("Server does not support security (TLS), but security required by connection configuration.", new XMPPError(XMPPError.Condition.forbidden));
                }
                if (!this.startTLSReceived || XMPPConnection.this.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                    XMPPConnection.this.connected = true;
                    this.releaseConnectionIDLock();
                }
                this.startTLSReceived = false;
                this.startTLSReceived = false;
            }
        }
    }

    class TCPXmppPacketWriter
    extends PacketWriter {
        TCPXmppPacketWriter() {
            super(XMPPConnection.this, true);
        }

        @Override
        protected void openStream() throws IOException {
            StringBuilder stream = new StringBuilder();
            stream.append("<stream:stream");
            stream.append(" to=\"").append(XMPPConnection.this.getServiceName()).append("\"");
            stream.append(" xmlns=\"jabber:client\"");
            stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
            stream.append(" version=\"1.0\">");
            this.writer.write(stream.toString());
            this.writer.flush();
        }

        @Override
        protected void closeStream() throws IOException {
            this.writer.write("</stream:stream>");
            this.writer.flush();
        }
    }
}

