/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.muc.BaseChatRoomSourceContact;
import net.java.sip.communicator.impl.muc.MUCActivator;
import net.java.sip.communicator.impl.muc.MUCServiceImpl;
import net.java.sip.communicator.impl.muc.ServerChatRoomContactSourceService;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapperListener;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class ServerChatRoomQuery
extends AsyncContactQuery<ContactSourceService>
implements ChatRoomProviderWrapperListener {
    private String queryString;
    private Set<BaseChatRoomSourceContact> contactResults = new TreeSet<BaseChatRoomSourceContact>();
    private MUCServiceImpl mucService;
    private int contactQueryListenersCount = 0;
    private ChatRoomProviderWrapper provider = null;

    public ServerChatRoomQuery(String queryString, ServerChatRoomContactSourceService contactSource, ChatRoomProviderWrapper provider) {
        super((ContactSourceService)contactSource, Pattern.compile(queryString, 18), true);
        this.queryString = queryString;
        this.mucService = MUCActivator.getMUCService();
        this.provider = provider;
    }

    private void initListeners() {
        this.mucService.addChatRoomProviderWrapperListener(this);
    }

    protected void run() {
        if (this.provider == null) {
            Iterator<ChatRoomProviderWrapper> chatRoomProviders = this.mucService.getChatRoomProviders();
            while (chatRoomProviders.hasNext()) {
                ChatRoomProviderWrapper provider = chatRoomProviders.next();
                this.providerAdded(provider, true);
            }
        } else {
            this.providerAdded(this.provider, true);
        }
        if (this.getStatus() != 1) {
            this.setStatus(0);
        }
    }

    private void providerAdded(ChatRoomProviderWrapper provider, boolean addQueryResult) {
        ProtocolProviderService pps = provider.getProtocolProvider();
        List<String> chatRoomNames = MUCActivator.getMUCService().getExistingChatRooms(provider);
        if (chatRoomNames == null) {
            return;
        }
        HashSet<BaseChatRoomSourceContact> chatRooms = new HashSet<BaseChatRoomSourceContact>(chatRoomNames.size());
        for (String name : chatRoomNames) {
            chatRooms.add(new BaseChatRoomSourceContact(name, name, (ContactQuery)this, pps));
        }
        this.addChatRooms(pps, chatRooms, addQueryResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChatRoom(ProtocolProviderService pps, String chatRoomName, String chatRoomID, boolean addQueryResult) {
        if ((this.queryString == null || chatRoomName.contains(this.queryString) || chatRoomID.contains(this.queryString)) && this.isMatching(chatRoomID, pps)) {
            BaseChatRoomSourceContact contact = new BaseChatRoomSourceContact(chatRoomName, chatRoomID, (ContactQuery)this, pps);
            Set<BaseChatRoomSourceContact> set = this.contactResults;
            synchronized (set) {
                this.contactResults.add(contact);
            }
            if (addQueryResult) {
                this.addQueryResult((SourceContact)contact, false);
            } else {
                this.fireContactReceived((SourceContact)contact, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChatRooms(ProtocolProviderService pps, Set<BaseChatRoomSourceContact> chatRooms, boolean addQueryResult) {
        Iterator<BaseChatRoomSourceContact> iterator = chatRooms.iterator();
        while (iterator.hasNext()) {
            BaseChatRoomSourceContact room = iterator.next();
            if ((this.queryString == null || room.getChatRoomName().contains(this.queryString) || room.getChatRoomID().contains(this.queryString)) && this.isMatching(room.getChatRoomID(), pps)) continue;
            iterator.remove();
        }
        Set<BaseChatRoomSourceContact> set = this.contactResults;
        synchronized (set) {
            this.contactResults.addAll(chatRooms);
        }
        if (addQueryResult) {
            this.addQueryResults(chatRooms);
        } else {
            for (SourceContact sourceContact : chatRooms) {
                this.fireContactReceived(sourceContact, false);
            }
        }
    }

    @Override
    public void chatRoomProviderWrapperAdded(ChatRoomProviderWrapper provider) {
        this.providerAdded(provider, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chatRoomProviderWrapperRemoved(ChatRoomProviderWrapper provider) {
        Set<BaseChatRoomSourceContact> set = this.contactResults;
        synchronized (set) {
            LinkedList<BaseChatRoomSourceContact> tmpContactResults = new LinkedList<BaseChatRoomSourceContact>(this.contactResults);
            for (BaseChatRoomSourceContact contact : tmpContactResults) {
                if (!contact.getProvider().equals(provider.getProtocolProvider())) continue;
                this.contactResults.remove((Object)contact);
                this.fireContactRemoved((SourceContact)contact);
            }
        }
    }

    private void clearListeners() {
        this.mucService.removeChatRoomProviderWrapperListener(this);
    }

    public void cancel() {
        this.clearListeners();
        super.cancel();
    }

    public void setStatus(int status) {
        if (status == 1) {
            this.clearListeners();
        }
        super.setStatus(status);
    }

    public void addContactQueryListener(ContactQueryListener l) {
        super.addContactQueryListener(l);
        ++this.contactQueryListenersCount;
        if (this.contactQueryListenersCount == 1) {
            this.initListeners();
        }
    }

    public void removeContactQueryListener(ContactQueryListener l) {
        super.removeContactQueryListener(l);
        --this.contactQueryListenersCount;
        if (this.contactQueryListenersCount == 0) {
            this.clearListeners();
        }
    }

    public boolean isMatching(String chatRoomID, ProtocolProviderService pps) {
        return MUCActivator.getMUCService().findChatRoomWrapperFromChatRoomID(chatRoomID, pps) == null;
    }

    public int indexOf(BaseChatRoomSourceContact contact) {
        Iterator<BaseChatRoomSourceContact> it = this.contactResults.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (((Object)((Object)contact)).equals((Object)it.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

