/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.event.CloseListener;
import net.java.sip.communicator.plugin.desktoputil.event.DoubleClickListener;
import net.java.sip.communicator.plugin.desktoputil.event.MaxListener;
import net.java.sip.communicator.plugin.desktoputil.event.PopupOutsideListener;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTabbedPaneEnhancedUI;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTabbedPaneUI;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommTabbedPane
extends JTabbedPane
implements ChangeListener,
Skinnable {
    private static final long serialVersionUID = 0L;
    private int overTabIndex = -1;
    private int lastSelectedIndex;

    public SIPCommTabbedPane() {
        this(false, false);
    }

    public SIPCommTabbedPane(boolean closingTabs, boolean maximizingTabs) {
        super.setTabLayoutPolicy(1);
        UIManager.getDefaults().put("TabbedPane.tabAreaInsets", new Insets(0, 5, 0, 0));
        UIManager.getDefaults().put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        this.setForeground(new Color(DesktopUtilActivator.getResources().getColor("service.gui.TAB_TITLE")));
        this.setUI(new SIPCommTabbedPaneEnhancedUI());
        if (closingTabs) {
            this.setCloseIcon(true);
        }
        if (maximizingTabs) {
            this.setMaxIcon(true);
        }
        this.addChangeListener(this);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public boolean isCloseEnabled() {
        SIPCommTabbedPaneUI ui = (SIPCommTabbedPaneUI)this.getUI();
        return ui.isCloseEnabled();
    }

    public boolean isMaxEnabled() {
        return ((SIPCommTabbedPaneUI)this.getUI()).isMaxEnabled();
    }

    @Override
    public void setTabLayoutPolicy(int tabLayoutPolicy) {
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
    }

    public void setCloseIcon(boolean b) {
        ((SIPCommTabbedPaneUI)this.getUI()).setCloseIcon(b);
    }

    public void setMaxIcon(boolean b) {
        ((SIPCommTabbedPaneUI)this.getUI()).setMaxIcon(b);
    }

    public void detachTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        final int tabIndex = index;
        final JComponent c = (JComponent)this.getComponentAt(tabIndex);
        final Icon icon = this.getIconAt(tabIndex);
        final String title = this.getTitleAt(tabIndex);
        final String toolTip = this.getToolTipTextAt(tabIndex);
        final Border border = c.getBorder();
        final SIPCommFrame frame = new SIPCommFrame(){
            private static final long serialVersionUID = 0L;

            @Override
            protected void close(boolean isEscaped) {
                if (isEscaped) {
                    return;
                }
                this.dispose();
                SIPCommTabbedPane.this.insertTab(title, icon, c, toolTip, Math.min(tabIndex, SIPCommTabbedPane.this.getTabCount()));
                c.setBorder(border);
                SIPCommTabbedPane.this.setSelectedComponent(c);
            }
        };
        Window parentWindow = SwingUtilities.windowForComponent(this);
        this.removeTabAt(index);
        c.setPreferredSize(c.getSize());
        frame.setTitle(title);
        frame.getContentPane().add(c);
        frame.setLocation(parentWindow.getLocation());
        frame.pack();
        WindowFocusListener windowFocusListener = new WindowFocusListener(){
            long start;
            long end;

            @Override
            public void windowGainedFocus(WindowEvent e) {
                this.start = System.currentTimeMillis();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                this.end = System.currentTimeMillis();
                long elapsed = this.end - this.start;
                if (elapsed < 100L) {
                    frame.toFront();
                }
                frame.removeWindowFocusListener(this);
            }
        };
        frame.addWindowFocusListener(windowFocusListener);
        ((Window)frame).setVisible(true);
        frame.toFront();
    }

    public synchronized void addCloseListener(CloseListener l) {
        this.listenerList.add(CloseListener.class, l);
    }

    public synchronized void addMaxListener(MaxListener l) {
        this.listenerList.add(MaxListener.class, l);
    }

    public synchronized void addDoubleClickListener(DoubleClickListener l) {
        this.listenerList.add(DoubleClickListener.class, l);
    }

    public synchronized void addPopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.add(PopupOutsideListener.class, l);
    }

    public synchronized void removeCloseListener(CloseListener l) {
        this.listenerList.remove(CloseListener.class, l);
    }

    public synchronized void removeMaxListener(MaxListener l) {
        this.listenerList.remove(MaxListener.class, l);
    }

    public synchronized void removeDoubleClickListener(DoubleClickListener l) {
        this.listenerList.remove(DoubleClickListener.class, l);
    }

    public synchronized void removePopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.remove(PopupOutsideListener.class, l);
    }

    public void fireCloseTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] closeListeners = this.getListeners(CloseListener.class);
        for (int i = 0; i < closeListeners.length; ++i) {
            ((CloseListener)closeListeners[i]).closeOperation(e);
        }
    }

    public void fireMaxTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] maxListeners = this.getListeners(MaxListener.class);
        for (int i = 0; i < maxListeners.length; ++i) {
            ((MaxListener)maxListeners[i]).maxOperation(e);
        }
    }

    public void fireDoubleClickTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] dClickListeners = this.getListeners(DoubleClickListener.class);
        for (int i = 0; i < dClickListeners.length; ++i) {
            ((DoubleClickListener)dClickListeners[i]).doubleClickOperation(e);
        }
    }

    public void firePopupOutsideTabEvent(MouseEvent e) {
        this.overTabIndex = -1;
        EventListener[] popupListeners = this.getListeners(PopupOutsideListener.class);
        for (int i = 0; i < popupListeners.length; ++i) {
            ((PopupOutsideListener)popupListeners[i]).popupOutsideOperation(e);
        }
    }

    @Override
    public void setSelectedIndex(int tabIndex) {
        SIPCommTabbedPaneEnhancedUI ui = (SIPCommTabbedPaneEnhancedUI)this.getUI();
        if (ui.isTabHighlighted(tabIndex)) {
            ui.tabRemoveHighlight(tabIndex);
        }
        super.setSelectedIndex(tabIndex);
    }

    public void highlightTab(int tabIndex) {
        SIPCommTabbedPaneEnhancedUI ui = (SIPCommTabbedPaneEnhancedUI)this.getUI();
        if (!ui.isTabHighlighted(tabIndex) && this.getSelectedIndex() != tabIndex) {
            ui.tabAddHightlight(tabIndex);
        }
        this.repaint();
    }

    @Override
    public void removeTabAt(int index) {
        if (index < this.lastSelectedIndex) {
            this.setSelectedIndex(this.lastSelectedIndex - 1);
        } else if (index > this.lastSelectedIndex) {
            this.setSelectedIndex(this.lastSelectedIndex);
        }
        super.removeTabAt(index);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.lastSelectedIndex = this.getSelectedIndex();
    }

    public void loadSkin() {
        this.setForeground(new Color(DesktopUtilActivator.getResources().getColor("service.gui.TAB_TITLE")));
        ((SIPCommTabbedPaneEnhancedUI)this.getUI()).loadSkin();
    }
}

