/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolTipUI;
import net.java.sip.communicator.plugin.desktoputil.ComponentUtils;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.Logger;

public class ExtendedTooltip
extends JToolTip
implements AncestorListener,
WindowFocusListener {
    private static final Logger logger = Logger.getLogger(ExtendedTooltip.class);
    private static final String uiClassID = ExtendedTooltip.class.getName() + "ToolTipUI";
    private final JLabel imageLabel = new JLabel();
    private final JLabel titleLabel = new JLabel();
    private final JPanel linesPanel = new JPanel();
    private final JTextArea bottomTextArea = new JTextArea();
    private int textWidth = 0;
    private int textHeight = 0;
    private boolean isListViewEnabled;
    private Window parentWindow = null;

    public ExtendedTooltip(boolean isListViewEnabled) {
        this.isListViewEnabled = isListViewEnabled;
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel(new BorderLayout());
        mainPanel.setOpaque(false);
        centerPanel.setOpaque(false);
        this.linesPanel.setOpaque(false);
        this.bottomTextArea.setOpaque(false);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        if (isListViewEnabled) {
            this.linesPanel.setLayout(new BoxLayout(this.linesPanel, 1));
            mainPanel.add((Component)this.imageLabel, "West");
            mainPanel.add((Component)centerPanel, "Center");
            centerPanel.add((Component)this.titleLabel, "North");
            centerPanel.add((Component)this.linesPanel, "Center");
        } else {
            this.titleLabel.setAlignmentX(0.5f);
            mainPanel.add((Component)this.imageLabel, "Center");
            mainPanel.add((Component)this.titleLabel, "North");
        }
        this.bottomTextArea.setEditable(false);
        this.bottomTextArea.setLineWrap(true);
        this.bottomTextArea.setWrapStyleWord(true);
        this.bottomTextArea.setFont(this.bottomTextArea.getFont().deriveFont(10.0f));
        mainPanel.add((Component)this.bottomTextArea, "South");
        this.addAncestorListener(this);
        this.add(mainPanel);
    }

    public void setImage(ImageIcon imageIcon) {
        this.imageLabel.setIcon(imageIcon);
    }

    public void setTitle(String titleText) {
        this.titleLabel.setText(titleText);
        Dimension labelSize = ComponentUtils.getStringSize(this.titleLabel, titleText);
        this.recalculateTooltipSize(labelSize.width, labelSize.height);
    }

    public void addLine(Icon icon, String text) {
        JLabel lineLabel = new JLabel(text, icon, 2);
        this.linesPanel.add(lineLabel);
        Dimension labelSize = this.calculateLabelSize(lineLabel);
        this.recalculateTooltipSize(labelSize.width, labelSize.height);
    }

    public void addSubLine(Icon icon, String text, int leftIndent) {
        JLabel lineLabel = new JLabel(text, icon, 2);
        lineLabel.setBorder(BorderFactory.createEmptyBorder(0, leftIndent, 0, 0));
        lineLabel.setFont(lineLabel.getFont().deriveFont(9.0f));
        lineLabel.setForeground(Color.DARK_GRAY);
        this.linesPanel.add(lineLabel);
        Dimension labelSize = this.calculateLabelSize(lineLabel);
        this.recalculateTooltipSize(labelSize.width + leftIndent, labelSize.height);
    }

    public void addLine(JLabel[] labels) {
        Dimension lineSize = null;
        if (labels.length <= 0) {
            return;
        }
        TransparentPanel labelPanel = new TransparentPanel(new FlowLayout(0, 2, 0));
        this.linesPanel.add((Component)((Object)labelPanel));
        for (JLabel label : labels) {
            ((Container)((Object)labelPanel)).add(label);
            lineSize = lineSize == null ? this.calculateLabelSize(label) : new Dimension(lineSize.width + this.calculateLabelSize((JLabel)label).width, lineSize.height);
        }
        if (lineSize != null) {
            this.recalculateTooltipSize(lineSize.width, lineSize.height);
        }
    }

    public void removeAllLines() {
        this.linesPanel.removeAll();
    }

    public void setBottomText(String text) {
        this.bottomTextArea.setText(text);
    }

    private Dimension calculateLabelSize(JLabel label) {
        Icon icon = label.getIcon();
        String text = label.getText();
        int iconWidth = 0;
        int iconHeight = 0;
        if (icon != null) {
            iconWidth = icon.getIconWidth();
            iconHeight = icon.getIconHeight();
        }
        int labelWidth = ComponentUtils.getStringWidth(label, text) + iconWidth + label.getIconTextGap();
        int textHeight = ComponentUtils.getStringSize((Component)label, (String)text).height;
        int labelHeight = iconHeight > textHeight ? iconHeight : textHeight;
        return new Dimension(labelWidth, labelHeight);
    }

    private void recalculateTooltipSize(int newTextWidth, int newTextHeight) {
        if (this.textWidth < newTextWidth) {
            this.textWidth = newTextWidth;
        }
        this.textHeight += newTextHeight;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        Window popupWindow = SwingUtilities.getWindowAncestor(this);
        if (popupWindow != null && popupWindow.isVisible() && popupWindow instanceof JWindow) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Tooltip window ancestor to hide: " + popupWindow));
            }
            popupWindow.setVisible(false);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.parentWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (this.parentWindow != null) {
            this.parentWindow.addWindowFocusListener(this);
        } else {
            Window popupWindow = SwingUtilities.getWindowAncestor(this);
            if (popupWindow != null && popupWindow instanceof JWindow) {
                popupWindow.setVisible(false);
            }
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (this.parentWindow != null) {
            this.parentWindow.removeWindowFocusListener(this);
            this.parentWindow = null;
        }
        this.removeAncestorListener(this);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    static {
        UIManager.getDefaults().put(uiClassID, ImageToolTipUI.class.getName());
    }

    public static class ImageToolTipUI
    extends MetalToolTipUI {
        static ImageToolTipUI sharedInstance = new ImageToolTipUI();

        public static ComponentUI createUI(JComponent c) {
            return sharedInstance;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
        }

        @Override
        public void update(Graphics g, JComponent c) {
            JTextArea bottomTextArea = ((ExtendedTooltip)c).bottomTextArea;
            String bottomText = bottomTextArea.getText();
            if (bottomText == null || bottomText.length() <= 0) {
                bottomTextArea.setVisible(false);
            } else {
                bottomTextArea.setVisible(true);
            }
            super.update(g, c);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            ExtendedTooltip tooltip = (ExtendedTooltip)c;
            Icon icon = tooltip.imageLabel.getIcon();
            int width = 0;
            if (icon != null) {
                width += icon.getIconWidth();
            }
            width = tooltip.isListViewEnabled ? (width += tooltip.textWidth + 15) : (tooltip.textWidth > width ? tooltip.textWidth : width);
            int imageHeight = 0;
            if (icon != null) {
                imageHeight = icon.getIconHeight();
            }
            int height = tooltip.isListViewEnabled ? (imageHeight > tooltip.textHeight ? imageHeight : tooltip.textHeight) : imageHeight + tooltip.textHeight;
            String bottomText = tooltip.bottomTextArea.getText();
            if (bottomText != null && bottomText.length() > 0) {
                tooltip.bottomTextArea.setColumns(5);
                tooltip.bottomTextArea.setSize(0, 0);
                tooltip.bottomTextArea.setSize(tooltip.bottomTextArea.getPreferredSize());
                height += ((ExtendedTooltip)tooltip).bottomTextArea.getPreferredSize().height;
            }
            return new Dimension(width, height);
        }
    }
}

