/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class EmphasizedLabel
extends JLabel {
    private static final long serialVersionUID = 0L;
    private boolean fUseEmphasisColor;
    public static final Color EMPHASIZED_FONT_COLOR = new Color(255, 255, 255, 110);
    public static final Color EMPHASIZED_FOCUSED_FONT_COLOR = new Color(0);
    public static final Color EMPHASIZED_UNFOCUSED_FONT_COLOR = new Color(0x3F3F3F);

    public EmphasizedLabel(String text) {
        super(text);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        ++d.height;
        return d;
    }

    @Override
    public Color getForeground() {
        boolean hasFoucs;
        Window window = SwingUtilities.getWindowAncestor(this);
        boolean bl = hasFoucs = window != null && window.isFocused();
        Color retVal = this.fUseEmphasisColor ? EMPHASIZED_FONT_COLOR : (hasFoucs ? EMPHASIZED_FOCUSED_FONT_COLOR : EMPHASIZED_UNFOCUSED_FONT_COLOR);
        return retVal;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.fUseEmphasisColor = true;
        g.translate(0, 1);
        super.paintComponent(g);
        g.translate(0, -1);
        this.fUseEmphasisColor = false;
        super.paintComponent(g);
    }
}

