/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.menus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommRadioButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.StringUtils;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AutoAnswerMenu
extends SIPCommMenu
implements Skinnable {
    private static ProtocolProviderListener protocolProviderListener = null;

    public AutoAnswerMenu() {
        super(GuiActivator.getResources().getI18NString("service.gui.AUTO_ANSWER"));
        this.loadSkin();
        AutoAnswerMenu.registerMenuItems(this);
    }

    public static void registerMenuItems(SIPCommMenu parentMenu) {
        if (protocolProviderListener == null) {
            protocolProviderListener = new ProtocolProviderListener(parentMenu);
            GuiActivator.bundleContext.addServiceListener((ServiceListener)protocolProviderListener);
        }
        for (ProtocolProviderFactory providerFactory : GuiActivator.getProtocolProviderFactories().values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
                ProtocolProviderService protocolProvider = (ProtocolProviderService)GuiActivator.bundleContext.getService(serRef);
                AutoAnswerMenu.addAccountInternal(protocolProvider, parentMenu);
            }
        }
        if (ConfigurationUtils.isAutoAnswerDisableSubmenu() && AutoAnswerMenu.getAutoAnswerItemCount(parentMenu) == 1) {
            AutoAnswerMenu.updateItem(AutoAnswerMenu.getAutoAnswerItem(parentMenu, 0), true);
        }
    }

    public static int getAutoAnswerItemCount(SIPCommMenu menu) {
        int count = 0;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!(menu.getItem(i) instanceof AutoAnswerMenuItem)) continue;
            ++count;
        }
        return count;
    }

    public static AutoAnswerMenuItem getAutoAnswerItem(SIPCommMenu menu, int index) {
        int currentIx = 0;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!(menu.getItem(i) instanceof AutoAnswerMenuItem)) continue;
            if (currentIx == index) {
                return (AutoAnswerMenuItem)menu.getItem(i);
            }
            ++currentIx;
        }
        return null;
    }

    private static void addAccount(final ProtocolProviderService protocolProvider, final SIPCommMenu parentMenu) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoAnswerMenu.addAccount(protocolProvider, parentMenu);
                }
            });
            return;
        }
        int initialCount = AutoAnswerMenu.getAutoAnswerItemCount(parentMenu);
        AutoAnswerMenu.addAccountInternal(protocolProvider, parentMenu);
        int itemsCount = AutoAnswerMenu.getAutoAnswerItemCount(parentMenu);
        if (ConfigurationUtils.isAutoAnswerDisableSubmenu() && itemsCount != initialCount) {
            if (initialCount == 1) {
                for (int i = 0; i < parentMenu.getItemCount(); ++i) {
                    JMenuItem item = parentMenu.getItem(i);
                    if (!(item instanceof AutoAnswerMenuItem)) continue;
                    AutoAnswerMenu.updateItem((AutoAnswerMenuItem)item, false);
                }
            } else if (initialCount == 0) {
                AutoAnswerMenu.updateItem(AutoAnswerMenu.getAutoAnswerItem(parentMenu, 0), true);
            }
        }
    }

    private static void updateItem(AutoAnswerMenuItem item, boolean isGlobal) {
        if (item == null) {
            return;
        }
        if (isGlobal) {
            item.setText(GuiActivator.getResources().getI18NString("service.gui.AUTO_ANSWER"));
            item.setIcon(new ImageIcon(AutoAnswerMenu.getIconForProvider(item.getProtocolProvider(), ImageLoader.getImage(ImageLoader.CALL_16x16_ICON), item)));
        } else {
            item.setText(AutoAnswerMenuItem.getItemDisplayName(item.getProtocolProvider()));
            item.setIcon(new ImageIcon(AutoAnswerMenu.getIconForProvider(item.getProtocolProvider(), null, item)));
        }
    }

    private static void addAccountInternal(ProtocolProviderService protocolProvider, SIPCommMenu parentMenu) {
        OperationSetBasicAutoAnswer opSet = (OperationSetBasicAutoAnswer)protocolProvider.getOperationSet(OperationSetBasicAutoAnswer.class);
        if (opSet == null) {
            return;
        }
        if (protocolProvider.getAccountID().isHidden()) {
            return;
        }
        AutoAnswerMenuItem providerMenu = new AutoAnswerMenuItem(protocolProvider, parentMenu);
        int lastAutoAnswerIx = 0;
        boolean isMenuAdded = false;
        AccountID accountId = protocolProvider.getAccountID();
        for (int i = 0; i < parentMenu.getItemCount(); ++i) {
            int menuIndex;
            JMenuItem c = parentMenu.getItem(i);
            if (!(c instanceof AutoAnswerMenuItem)) continue;
            AutoAnswerMenuItem menu = (AutoAnswerMenuItem)c;
            lastAutoAnswerIx = menuIndex = parentMenu.getPopupMenu().getComponentIndex(menu);
            AccountID menuAccountID = menu.getProtocolProvider().getAccountID();
            int protocolCompare = accountId.getProtocolDisplayName().compareTo(menuAccountID.getProtocolDisplayName());
            if (protocolCompare < 0) {
                parentMenu.insert((JMenuItem)providerMenu, menuIndex);
                isMenuAdded = true;
                break;
            }
            if (protocolCompare != 0 || accountId.getDisplayName().compareTo(menuAccountID.getDisplayName()) >= 0) continue;
            parentMenu.insert((JMenuItem)providerMenu, menuIndex);
            isMenuAdded = true;
            break;
        }
        if (!isMenuAdded) {
            if (lastAutoAnswerIx != 0) {
                parentMenu.insert((JMenuItem)providerMenu, lastAutoAnswerIx);
            } else {
                int lastMenuItemIx = 0;
                for (int i = 0; i < parentMenu.getMenuComponentCount(); ++i) {
                    if (parentMenu.getMenuComponent(i) instanceof JSeparator) {
                        parentMenu.insert((JMenuItem)providerMenu, lastMenuItemIx + 1);
                        isMenuAdded = true;
                        break;
                    }
                    ++lastMenuItemIx;
                }
                if (!isMenuAdded) {
                    parentMenu.add((JMenuItem)providerMenu);
                }
            }
        }
    }

    public static void removeAccount(final ProtocolProviderService protocolProvider, final SIPCommMenu parentMenu) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoAnswerMenu.removeAccount(protocolProvider, parentMenu);
                }
            });
            return;
        }
        for (int i = 0; i < parentMenu.getItemCount(); ++i) {
            AutoAnswerMenuItem menu;
            AccountID menuAccountID;
            JMenuItem c = parentMenu.getItem(i);
            if (!(c instanceof AutoAnswerMenuItem) || !(menuAccountID = (menu = (AutoAnswerMenuItem)c).getProtocolProvider().getAccountID()).equals((Object)protocolProvider.getAccountID())) continue;
            parentMenu.remove((JMenuItem)menu);
            menu.clear();
            break;
        }
        if (ConfigurationUtils.isAutoAnswerDisableSubmenu() && AutoAnswerMenu.getAutoAnswerItemCount(parentMenu) == 1) {
            AutoAnswerMenu.updateItem(AutoAnswerMenu.getAutoAnswerItem(parentMenu, 0), true);
        }
    }

    public void loadSkin() {
        this.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CALL_16x16_ICON)));
    }

    private static boolean isAutoAnswerEnabled(ProtocolProviderService providerService) {
        OperationSetBasicAutoAnswer opset = (OperationSetBasicAutoAnswer)providerService.getOperationSet(OperationSetBasicAutoAnswer.class);
        OperationSetAdvancedAutoAnswer opSetAdvanced = (OperationSetAdvancedAutoAnswer)providerService.getOperationSet(OperationSetAdvancedAutoAnswer.class);
        if (opset == null) {
            return false;
        }
        if (opSetAdvanced != null) {
            if (opSetAdvanced.isAutoAnswerConditionSet()) {
                return true;
            }
            if (!StringUtils.isNullOrEmpty((String)opSetAdvanced.getCallForward())) {
                return true;
            }
        }
        return opset.isAutoAnswerWithVideoSet() || opset.isAutoAnswerUnconditionalSet();
    }

    private static Image getIconForProvider(ProtocolProviderService providerService, Image customProviderImage, ImageObserver imageObserver) {
        byte[] bytes;
        BufferedImage left;
        BufferedImage bufferedImage = left = AutoAnswerMenu.isAutoAnswerEnabled(providerService) ? ImageLoader.getImage(ImageLoader.AUTO_ANSWER_CHECK) : null;
        if (customProviderImage == null && (bytes = providerService.getProtocolIcon().getIcon("IconSize16x16")) != null) {
            customProviderImage = ImageUtils.getBytesInImage((byte[])bytes);
        }
        return ImageUtils.getComposedImage((Image)left, (Image)customProviderImage, (ImageObserver)imageObserver);
    }

    private static class AutoAnswerOptionsDialog
    extends SIPCommDialog
    implements ActionListener {
        private static final String AUTO_ALERT_INFO_NAME = "Alert-Info";
        private static final String AUTO_ALERT_INFO_VALUE = "Auto Answer";
        private ProtocolProviderService providerService;
        private final JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
        private final JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
        private JRadioButton noneRadio;
        private JRadioButton alwaysAnswerRadio;
        private JRadioButton alertInfoValue;
        private JRadioButton customValueRadio;
        private SIPCommCheckBox answerWithVideoCheckBox;
        private JTextField headerNameField = new JTextField();
        private JTextField headerValueField = new JTextField();
        private JRadioButton callFwd;
        private JTextField callFwdNumberField = new JTextField();
        private final SIPCommMenu parentMenu;

        AutoAnswerOptionsDialog(ProtocolProviderService providerService, SIPCommMenu parentMenu) {
            super(false);
            this.parentMenu = parentMenu;
            this.providerService = providerService;
            this.setTitle(GuiActivator.getResources().getI18NString("service.gui.AUTO_ANSWER"));
            this.initComponents();
            this.loadValues();
        }

        private void initComponents() {
            OperationSetAdvancedAutoAnswer opSetAdvanced = (OperationSetAdvancedAutoAnswer)this.providerService.getOperationSet(OperationSetAdvancedAutoAnswer.class);
            ResourceManagementService R = GuiActivator.getResources();
            ButtonGroup group = new ButtonGroup();
            TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
            int currentRow = 0;
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = currentRow++;
            c.gridx = c.gridy;
            c.anchor = 21;
            c.fill = 2;
            c.gridy = currentRow++;
            this.noneRadio = new SIPCommRadioButton(R.getI18NString("service.gui.NONE"));
            this.noneRadio.setSelected(true);
            group.add(this.noneRadio);
            mainPanel.add((Component)this.noneRadio, c);
            c.gridy = currentRow++;
            mainPanel.add((Component)this.getTitlePanel(R.getI18NString("service.gui.AUTO_ANSWER_LABEL")), c);
            c.gridy = currentRow++;
            this.alwaysAnswerRadio = new SIPCommRadioButton(R.getI18NString("service.gui.AUTO_ANSWER_ALL_CALLS"));
            group.add(this.alwaysAnswerRadio);
            mainPanel.add((Component)this.alwaysAnswerRadio, c);
            if (opSetAdvanced != null) {
                c.gridy = currentRow++;
                this.alertInfoValue = new SIPCommRadioButton(R.getI18NString("service.gui.AUTO_ANSWER_ALERT_INFO_FIELDS"));
                group.add(this.alertInfoValue);
                mainPanel.add((Component)this.alertInfoValue, c);
                c.gridy = currentRow++;
                this.customValueRadio = new SIPCommRadioButton(R.getI18NString("service.gui.AUTO_ANSWER_CUSTOM_FIELDS"));
                group.add(this.customValueRadio);
                mainPanel.add((Component)this.customValueRadio, c);
                TransparentPanel customHeaderPanel = new TransparentPanel((LayoutManager)new GridLayout(1, 2));
                TransparentPanel namePanel = new TransparentPanel((LayoutManager)new BorderLayout());
                namePanel.add((Component)new JLabel(R.getI18NString("service.gui.AUTO_ANSWER_FIELD")), "West");
                namePanel.add((Component)this.headerNameField, "Center");
                TransparentPanel valuePanel = new TransparentPanel((LayoutManager)new BorderLayout());
                valuePanel.add((Component)new JLabel(R.getI18NString("service.gui.AUTO_ANSWER_VALUE")), "West");
                valuePanel.add((Component)this.headerValueField, "Center");
                customHeaderPanel.add((Component)namePanel);
                customHeaderPanel.add((Component)valuePanel);
                c.gridy = currentRow++;
                c.insets = new Insets(0, 28, 0, 0);
                mainPanel.add((Component)customHeaderPanel, c);
                String description = R.getI18NString("service.gui.AUTO_ANSWER_DESCR_VLUE");
                JLabel descriptionLabel = new JLabel(description);
                descriptionLabel.setToolTipText(description);
                descriptionLabel.setForeground(Color.GRAY);
                descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(8));
                descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
                descriptionLabel.setHorizontalAlignment(4);
                c.gridy = currentRow++;
                mainPanel.add((Component)descriptionLabel, c);
                c.gridy = currentRow++;
                c.insets = new Insets(0, 0, 0, 0);
                mainPanel.add((Component)this.getTitlePanel(R.getI18NString("service.gui.AUTO_ANSWER_FWD_CALLS")), c);
                c.gridy = currentRow++;
                this.callFwd = new SIPCommRadioButton(R.getI18NString("service.gui.AUTO_ANSWER_FWD_CALLS_TO"));
                group.add(this.callFwd);
                mainPanel.add((Component)this.callFwd, c);
                c.gridy = currentRow++;
                c.insets = new Insets(0, 28, 0, 0);
                mainPanel.add((Component)this.callFwdNumberField, c);
                c.insets = new Insets(0, 0, 0, 0);
            } else {
                c.insets = new Insets(10, 0, 0, 0);
            }
            c.gridy = currentRow++;
            mainPanel.add((Component)this.getTitlePanel(R.getI18NString("service.gui.AUTO_ANSWER_VIDEO")), c);
            c.gridy = currentRow++;
            this.answerWithVideoCheckBox = new SIPCommCheckBox(R.getI18NString("service.gui.AUTO_ANSWER_VIDEO_CALLS_WITH_VIDEO"));
            mainPanel.add((Component)this.answerWithVideoCheckBox, c);
            TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.OK"));
            this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            buttonsPanel.add((Component)this.okButton);
            buttonsPanel.add((Component)this.cancelButton);
            c.gridy = currentRow++;
            mainPanel.add((Component)buttonsPanel, c);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setLayout(new BorderLayout());
            this.add((Component)mainPanel, "Center");
        }

        private JPanel getTitlePanel(String title) {
            JLabel label = new JLabel(title);
            label.setBorder(new EmptyBorder(0, 0, 0, 10));
            label.setFont(UIManager.getFont("TitledBorder.font"));
            label.setForeground(UIManager.getColor("TitledBorder.titleColor"));
            TransparentPanel pnlSectionName = new TransparentPanel();
            pnlSectionName.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.anchor = 21;
            c.gridwidth = 2;
            pnlSectionName.add((Component)label, c);
            c.gridx = 2;
            c.weightx = 1.0;
            c.fill = 2;
            pnlSectionName.add((Component)new JSeparator(), c);
            TransparentPanel pnlSection = new TransparentPanel(){

                public Component add(Component comp) {
                    if (comp instanceof JComponent) {
                        ((JComponent)comp).setAlignmentX(0.0f);
                    }
                    return super.add(comp);
                }
            };
            pnlSection.setLayout(new BoxLayout((Container)pnlSection, 1));
            pnlSection.add((Component)pnlSectionName);
            return pnlSection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.okButton)) {
                OperationSetBasicAutoAnswer opset = (OperationSetBasicAutoAnswer)this.providerService.getOperationSet(OperationSetBasicAutoAnswer.class);
                OperationSetAdvancedAutoAnswer opSetAdvanced = (OperationSetAdvancedAutoAnswer)this.providerService.getOperationSet(OperationSetAdvancedAutoAnswer.class);
                if (this.noneRadio.isSelected()) {
                    opset.clear();
                    if (opSetAdvanced != null) {
                        opSetAdvanced.clear();
                    }
                } else if (this.alwaysAnswerRadio.isSelected()) {
                    opset.setAutoAnswerUnconditional();
                } else if (this.alertInfoValue.isSelected()) {
                    if (opSetAdvanced != null) {
                        opSetAdvanced.setAutoAnswerCondition(AUTO_ALERT_INFO_NAME, AUTO_ALERT_INFO_VALUE);
                    }
                } else if (this.customValueRadio.isSelected()) {
                    if (opSetAdvanced != null) {
                        opSetAdvanced.setAutoAnswerCondition(this.headerNameField.getText(), this.headerValueField.getText());
                    }
                } else if (this.callFwd.isSelected() && opSetAdvanced != null) {
                    opSetAdvanced.setCallForward(this.callFwdNumberField.getText());
                }
                opset.setAutoAnswerWithVideo(this.answerWithVideoCheckBox.isSelected());
                if (ConfigurationUtils.isAutoAnswerDisableSubmenu() && AutoAnswerMenu.getAutoAnswerItemCount(this.parentMenu) == 1) {
                    AutoAnswerMenu.updateItem(AutoAnswerMenu.getAutoAnswerItem(this.parentMenu, 0), true);
                } else {
                    for (int i = 0; i < this.parentMenu.getItemCount(); ++i) {
                        JMenuItem item = this.parentMenu.getItem(i);
                        if (!(item instanceof AutoAnswerMenuItem)) continue;
                        AutoAnswerMenu.updateItem((AutoAnswerMenuItem)item, false);
                    }
                }
            }
            this.dispose();
        }

        protected void close(boolean isEscaped) {
            this.dispose();
        }

        private void loadValues() {
            OperationSetBasicAutoAnswer opset = (OperationSetBasicAutoAnswer)this.providerService.getOperationSet(OperationSetBasicAutoAnswer.class);
            OperationSetAdvancedAutoAnswer opSetAdvanced = (OperationSetAdvancedAutoAnswer)this.providerService.getOperationSet(OperationSetAdvancedAutoAnswer.class);
            if (opset == null) {
                return;
            }
            this.noneRadio.setSelected(true);
            this.alwaysAnswerRadio.setSelected(opset.isAutoAnswerUnconditionalSet());
            if (opSetAdvanced != null) {
                if (opSetAdvanced.isAutoAnswerConditionSet()) {
                    String fName = opSetAdvanced.getAutoAnswerHeaderName();
                    String fValue = opSetAdvanced.getAutoAnswerHeaderValue();
                    if (AUTO_ALERT_INFO_NAME.equals(fName) && AUTO_ALERT_INFO_VALUE.equals(fValue)) {
                        this.alertInfoValue.setSelected(true);
                    } else {
                        this.customValueRadio.setSelected(true);
                        this.headerNameField.setText(fName);
                        if (!StringUtils.isNullOrEmpty((String)fValue)) {
                            this.headerValueField.setText(fValue);
                        }
                    }
                }
                if (!StringUtils.isNullOrEmpty((String)opSetAdvanced.getCallForward())) {
                    this.callFwd.setSelected(true);
                    this.callFwdNumberField.setText(opSetAdvanced.getCallForward());
                }
            }
            this.answerWithVideoCheckBox.setSelected(opset.isAutoAnswerWithVideoSet());
        }
    }

    private static class AutoAnswerMenuItem
    extends JMenuItem
    implements ActionListener {
        private ProtocolProviderService providerService;
        private final SIPCommMenu parentMenu;

        AutoAnswerMenuItem(ProtocolProviderService provider, SIPCommMenu parentMenu) {
            this(provider, AutoAnswerMenuItem.getItemDisplayName(provider), AutoAnswerMenu.getIconForProvider(provider, null, (ImageObserver)parentMenu), parentMenu);
        }

        private AutoAnswerMenuItem(ProtocolProviderService provider, String displayName, Image onlineImage, SIPCommMenu parentMenu) {
            super(displayName, onlineImage == null ? null : new ImageIcon(onlineImage));
            this.providerService = provider;
            this.parentMenu = parentMenu;
            this.addActionListener(this);
        }

        public ProtocolProviderService getProtocolProvider() {
            return this.providerService;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new AutoAnswerOptionsDialog(this.providerService, this.parentMenu).setVisible(true);
        }

        private static String getItemDisplayName(ProtocolProviderService provider) {
            if (ConfigurationUtils.isAutoAnswerDisableSubmenu()) {
                return GuiActivator.getResources().getI18NString("service.gui.AUTO_ANSWER") + " - " + provider.getAccountID().getDisplayName();
            }
            return provider.getAccountID().getDisplayName();
        }

        public void clear() {
            this.providerService = null;
        }
    }

    private static class ProtocolProviderListener
    implements ServiceListener {
        SIPCommMenu parentMenu;

        ProtocolProviderListener(SIPCommMenu parentMenu) {
            this.parentMenu = parentMenu;
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = GuiActivator.bundleContext.getService(serviceRef);
            if (!(service instanceof ProtocolProviderService)) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    AutoAnswerMenu.addAccount((ProtocolProviderService)service, this.parentMenu);
                    break;
                }
                case 4: {
                    AutoAnswerMenu.removeAccount((ProtocolProviderService)service, this.parentMenu);
                }
            }
        }
    }
}

