/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListTreeModel;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTreeUI;
import net.java.sip.communicator.service.gui.ContactListNode;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.util.Logger;

public class GroupNode
extends DefaultMutableTreeNode
implements ContactListNode {
    private static final Logger logger = Logger.getLogger(GroupNode.class);
    private final ContactListTreeModel treeModel;
    private final UIGroup group;
    private static final NodeComparator nodeComparator = new NodeComparator();
    private boolean isCollapsed = false;

    public GroupNode(ContactListTreeModel treeModel, UIGroupImpl uiGroup) {
        super((Object)uiGroup, true);
        this.treeModel = treeModel;
        this.group = uiGroup;
        this.isCollapsed = this.group.isGroupCollapsed();
    }

    public ContactNode addContact(UIContactImpl uiContact) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Group node add contact: " + uiContact.getDisplayName()));
        }
        int selectedIndex = this.getLeadSelectionRow();
        ContactNode contactNode = new ContactNode(uiContact);
        uiContact.setContactNode(contactNode);
        this.add(contactNode);
        this.fireNodeInserted(this.children.size() - 1);
        this.refreshSelection(selectedIndex, this.getLeadSelectionRow());
        return contactNode;
    }

    public ContactNode sortedAddContact(UIContactImpl uiContact) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Group node sorted add contact: " + uiContact.getDisplayName()));
        }
        ContactNode contactNode = new ContactNode(uiContact);
        uiContact.setContactNode(contactNode);
        if (this.children == null) {
            this.add(contactNode);
            this.fireNodeInserted(0);
        } else {
            int insertionPoint = Collections.binarySearch(this.children, contactNode, nodeComparator);
            if (insertionPoint < 0) {
                int index = (insertionPoint + 1) * -1;
                this.insert(contactNode, index);
                this.fireNodeInserted(index);
            }
        }
        return contactNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContact(UIContactImpl uiContact) {
        int index;
        ContactNode contactNode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Group node remove contact: " + uiContact.getDisplayName()));
        }
        UIContactImpl uIContactImpl = uiContact;
        synchronized (uIContactImpl) {
            contactNode = uiContact.getContactNode();
            if (contactNode == null) {
                return;
            }
            index = this.getIndex(contactNode);
        }
        if (index == -1) {
            return;
        }
        int selectedIndex = this.getLeadSelectionRow();
        this.children.removeElementAt(index);
        contactNode.setParent(null);
        UIContactImpl uIContactImpl2 = uiContact;
        synchronized (uIContactImpl2) {
            uiContact.setContactNode(null);
            uiContact = null;
        }
        this.fireNodeRemoved(contactNode, index);
        this.refreshSelection(selectedIndex, this.getLeadSelectionRow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupNode addContactGroup(UIGroupImpl uiGroup) {
        GroupNode groupNode;
        int selectedIndex = this.getLeadSelectionRow();
        UIGroupImpl uIGroupImpl = uiGroup;
        synchronized (uIGroupImpl) {
            groupNode = new GroupNode(this.treeModel, uiGroup);
            uiGroup.setGroupNode(groupNode);
        }
        this.add(groupNode);
        this.fireNodeInserted(this.children.size() - 1);
        this.refreshSelection(selectedIndex, this.getLeadSelectionRow());
        return groupNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactGroup(UIGroupImpl uiGroup) {
        GroupNode groupNode;
        UIGroupImpl uIGroupImpl = uiGroup;
        synchronized (uIGroupImpl) {
            groupNode = uiGroup.getGroupNode();
            if (groupNode == null) {
                return;
            }
        }
        int index = this.getIndex(groupNode);
        if (index == -1) {
            return;
        }
        int selectedIndex = this.getLeadSelectionRow();
        this.children.removeElementAt(index);
        groupNode.setParent(null);
        UIGroupImpl uIGroupImpl2 = uiGroup;
        synchronized (uIGroupImpl2) {
            uiGroup.setGroupNode(null);
        }
        this.fireNodeRemoved(groupNode, index);
        this.refreshSelection(selectedIndex, this.getLeadSelectionRow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupNode sortedAddContactGroup(UIGroupImpl uiGroup) {
        GroupNode groupNode;
        UIGroupImpl uIGroupImpl = uiGroup;
        synchronized (uIGroupImpl) {
            groupNode = new GroupNode(this.treeModel, uiGroup);
            uiGroup.setGroupNode(groupNode);
        }
        if (this.children == null) {
            this.add(groupNode);
            this.fireNodeInserted(0);
        } else {
            int insertionPoint = Collections.binarySearch(this.children, groupNode, nodeComparator);
            insertionPoint = insertionPoint < 0 ? (insertionPoint + 1) * -1 : ++insertionPoint;
            this.insert(groupNode, insertionPoint);
            this.fireNodeInserted(insertionPoint);
        }
        return groupNode;
    }

    public Collection<ContactNode> getContacts() {
        if (this.children != null) {
            return Collections.unmodifiableCollection(this.children);
        }
        return null;
    }

    public UIGroupImpl getGroupDescriptor() {
        return (UIGroupImpl)((Object)this.getUserObject());
    }

    public int getSourceIndex() {
        return this.group.getSourceIndex();
    }

    public void sort(final ContactListTreeModel treeModel) {
        if (this.children != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath selectionPath = GroupNode.this.getLeadSelectionPath();
                    int oldSelectionIndex = GroupNode.this.getLeadSelectionRow();
                    Collections.sort(GroupNode.this.children, nodeComparator);
                    GroupNode.this.fireNodesChanged();
                    treeModel.getParentTree().setSelectionPath(selectionPath);
                    GroupNode.this.refreshSelection(oldSelectionIndex, GroupNode.this.getLeadSelectionRow());
                }
            });
        }
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Object object;
            TreeNode treeNode = this.getChildAt(i);
            if (treeNode instanceof ContactNode) {
                UIContactImpl contact;
                object = contact = ((ContactNode)treeNode).getContactDescriptor();
                synchronized (object) {
                    contact.setContactNode(null);
                    continue;
                }
            }
            if (!(treeNode instanceof GroupNode)) continue;
            UIGroupImpl group = ((GroupNode)treeNode).getGroupDescriptor();
            object = group;
            synchronized (object) {
                group.setGroupNode(null);
            }
            ((GroupNode)treeNode).clear();
        }
        if (this.children != null) {
            this.children.removeAllElements();
        }
    }

    private void fireNodeInserted(int index) {
        this.treeModel.nodesWereInserted(this, new int[]{index});
    }

    private void fireNodeRemoved(ContactListNode node, int index) {
        this.treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
    }

    private void fireNodesChanged() {
        int childCount = this.getChildCount();
        int[] changedIndexes = new int[childCount];
        for (int i = 0; i < childCount; ++i) {
            changedIndexes[i] = i;
        }
        this.treeModel.nodesChanged(this, changedIndexes);
    }

    private int getLeadSelectionRow() {
        JTree tree = this.treeModel.getParentTree();
        int[] rows = tree.getSelectionRows();
        int selectedRow = -1;
        if (rows != null && rows.length != 0) {
            selectedRow = rows[0];
        }
        return selectedRow;
    }

    private TreePath getLeadSelectionPath() {
        return this.treeModel.getParentTree().getSelectionPath();
    }

    private void refreshSelection(int lastSelectedIndex, int newSelectedIndex) {
        JTree tree = this.treeModel.getParentTree();
        TreeUI treeUI = tree.getUI();
        if (treeUI instanceof SIPCommTreeUI) {
            SIPCommTreeUI sipCommTreeUI = (SIPCommTreeUI)treeUI;
            TreePath oldSelectionPath = tree.getPathForRow(lastSelectedIndex);
            TreePath newSelectionPath = tree.getPathForRow(newSelectedIndex);
            sipCommTreeUI.selectionChanged(oldSelectionPath, newSelectionPath);
        }
    }

    static class NodeComparator
    implements Comparator<ContactListNode> {
        NodeComparator() {
        }

        @Override
        public int compare(ContactListNode node1, ContactListNode node2) {
            int index1 = node1.getSourceIndex();
            int index2 = node2.getSourceIndex();
            if (index1 < 0 && index2 < 0) {
                return 0;
            }
            if (index1 < 0) {
                return 1;
            }
            if (index2 < 0) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            if (index1 < index2) {
                return -1;
            }
            return 0;
        }
    }
}

