/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.TitlePanel;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationFormField;

public class ChatRoomConfigurationWindow
extends SIPCommFrame
implements ActionListener {
    protected ChatRoomConfigurationForm configForm;
    protected JScrollPane generalScrollPane = new JScrollPane();
    protected JPanel mainPanel = new TransparentPanel();
    private JButton saveButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.APPLY"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    private TitlePanel titlePanel = new TitlePanel();
    protected Hashtable<String, JComponent> uiFieldsTable = new Hashtable();

    public ChatRoomConfigurationWindow(String chatRoomName, ChatRoomConfigurationForm configForm) {
        super(false);
        this.configForm = configForm;
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_CONFIGURATION", new String[]{chatRoomName}));
        this.titlePanel.setTitleText(GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_OPTIONS"));
        this.generalScrollPane.setPreferredSize(new Dimension(820, 520));
        this.generalScrollPane.setHorizontalScrollBarPolicy(30);
        this.generalScrollPane.setOpaque(false);
        this.generalScrollPane.getViewport().setOpaque(false);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonsPanel.add(this.saveButton);
        this.buttonsPanel.add(this.cancelButton);
        this.generalScrollPane.getViewport().add(this.mainPanel);
        this.getContentPane().add((Component)((Object)this.titlePanel), "North");
        this.getContentPane().add((Component)this.generalScrollPane, "Center");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.titlePanel.setOpaque(false);
        this.buttonsPanel.setOpaque(false);
        this.mainPanel.setOpaque(false);
        this.generalScrollPane.setOpaque(false);
        this.loadConfigurationForm();
    }

    protected void loadConfigurationForm() {
        Iterator configurationSet = this.configForm.getConfigurationSet();
        while (configurationSet.hasNext()) {
            Object value;
            String value2;
            Object field;
            String fieldType;
            ChatRoomConfigurationFormField formField = (ChatRoomConfigurationFormField)configurationSet.next();
            Iterator values = formField.getValues();
            Iterator options = formField.getOptions();
            JLabel label = new JLabel("", 4);
            if (formField.getLabel() != null) {
                label.setText(formField.getLabel() + ": ");
            }
            if ((fieldType = formField.getType()).equals("Boolean")) {
                field = new SIPCommCheckBox(formField.getLabel());
                label.setText("");
                if (values.hasNext()) {
                    ((JCheckBox)field).setSelected((Boolean)values.next());
                }
            } else if (fieldType.equals("FixedText")) {
                field = new JLabel();
                if (values.hasNext()) {
                    value2 = values.next().toString();
                    ((JLabel)field).setText(value2);
                    ((JComponent)field).setFont(new Font(null, 2, 10));
                    ((JComponent)field).setForeground(Color.GRAY);
                }
            } else if (fieldType.equals("ListMultiChoice")) {
                field = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
                ((JComponent)field).setBorder(BorderFactory.createLineBorder(Color.GRAY));
                Hashtable optionCheckBoxes = new Hashtable();
                while (options.hasNext()) {
                    Object option = options.next();
                    SIPCommCheckBox checkBox = new SIPCommCheckBox(option.toString());
                    ((Container)field).add((Component)checkBox);
                    optionCheckBoxes.put(option, checkBox);
                }
                while (values.hasNext()) {
                    value = values.next();
                    ((JCheckBox)optionCheckBoxes.get(value)).setSelected(true);
                }
            } else if (fieldType.equals("ListSingleChoice")) {
                field = new JComboBox();
                while (options.hasNext()) {
                    ((JComboBox)field).addItem(options.next());
                }
                if (values.hasNext()) {
                    ((JComboBox)field).setSelectedItem(values.next());
                }
            } else if (fieldType.equals("MultipleLinesText")) {
                field = new JEditorPane();
                if (values.hasNext()) {
                    value2 = values.next().toString();
                    ((JEditorPane)field).setText(value2);
                }
            } else if (fieldType.equals("SingleLineText") || fieldType.equals("SingleIDChoice")) {
                field = new JTextField();
                if (values.hasNext()) {
                    value2 = values.next().toString();
                    ((JTextField)field).setText(value2);
                }
            } else if (fieldType.equals("PrivateText")) {
                field = new JPasswordField();
                if (values.hasNext()) {
                    value2 = values.next().toString();
                    ((JPasswordField)field).setText(value2);
                }
            } else if (fieldType.equals("MultiIDChoice")) {
                StringBuffer buff = new StringBuffer();
                while (values.hasNext()) {
                    value = values.next().toString();
                    buff.append((String)value);
                    if (!values.hasNext()) continue;
                    buff.append(System.getProperty("line.separator"));
                }
                field = new JTextArea(buff.toString());
            } else {
                if (label.getText() == null) continue;
                field = new JTextField();
                if (values.hasNext()) {
                    value2 = values.next().toString();
                    ((JTextField)field).setText(value2);
                }
            }
            if (!fieldType.equals("FixedText")) {
                this.uiFieldsTable.put(formField.getName(), (JComponent)field);
            }
            TransparentPanel fieldPanel = new TransparentPanel((LayoutManager)new GridLayout(1, 2));
            fieldPanel.setOpaque(false);
            if (!(field instanceof JLabel)) {
                fieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
            } else {
                fieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
            }
            fieldPanel.add(label);
            fieldPanel.add((Component)field);
            this.mainPanel.add((Component)fieldPanel);
        }
    }

    private int computeLabelWidth(ChatRoomConfigurationForm configForm) {
        int labelWidth = 0;
        Iterator configurationSet = configForm.getConfigurationSet();
        while (configurationSet.hasNext()) {
            JLabel label;
            int newLabelWidth;
            ChatRoomConfigurationFormField formField = (ChatRoomConfigurationFormField)configurationSet.next();
            if (formField.getLabel() == null || (newLabelWidth = SwingUtilities.computeStringWidth((label = new JLabel(formField.getLabel())).getFontMetrics(label.getFont()), formField.getLabel())) <= labelWidth) continue;
            labelWidth = newLabelWidth;
        }
        return labelWidth + 10;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        if (button.equals(this.saveButton)) {
            Iterator configurationSet = this.configForm.getConfigurationSet();
            while (configurationSet.hasNext()) {
                Component[] components;
                ChatRoomConfigurationFormField formField = (ChatRoomConfigurationFormField)configurationSet.next();
                if (formField.getType().equals("FixedText")) continue;
                JComponent c = this.uiFieldsTable.get(formField.getName());
                if (c instanceof JTextComponent) {
                    String newValue = ((JTextComponent)c).getText();
                    if (formField.getType().equals("MultiIDChoice")) {
                        StringTokenizer idTokens = new StringTokenizer(newValue, System.getProperty("line.separator"));
                        while (idTokens.hasMoreTokens()) {
                            formField.addValue((Object)idTokens.nextToken());
                        }
                        continue;
                    }
                    formField.addValue((Object)newValue);
                    continue;
                }
                if (c instanceof AbstractButton) {
                    boolean isSelected = ((AbstractButton)c).isSelected();
                    formField.addValue((Object)isSelected);
                    continue;
                }
                if (c instanceof JComboBox) {
                    Object selectedObject = ((JComboBox)c).getSelectedItem();
                    formField.addValue(selectedObject);
                    continue;
                }
                if (!(c instanceof JPanel)) continue;
                for (Component comp : components = c.getComponents()) {
                    if (!(comp instanceof JCheckBox)) continue;
                    JCheckBox checkBox = (JCheckBox)comp;
                    formField.addValue((Object)checkBox.getText());
                }
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        ChatRoomConfigurationWindow.this.configForm.submit();
                    }
                    catch (Exception e) {
                        new ErrorDialog((Frame)((Object)ChatRoomConfigurationWindow.this), GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_CONFIGURATION_SUBMIT_FAILED"), (Throwable)e).showDialog();
                    }
                }
            }.start();
        }
        this.dispose();
    }

    protected void close(boolean isEscaped) {
        this.dispose();
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.setLocationRelativeTo(null);
        }
        super.setVisible(isVisible);
    }
}

