/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.AbstractCallToggleButton;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;

public class DesktopSharingButton
extends AbstractCallToggleButton {
    private boolean desktopSharingAvailable;

    public DesktopSharingButton(Call call) {
        this(call, false);
    }

    public DesktopSharingButton(Call call, boolean selected) {
        super(call, selected, ImageLoader.CALL_DESKTOP_BUTTON, "service.gui.SHARE_DESKTOP_WITH_CONTACT");
        OperationSetDesktopStreaming desktopSharing = (OperationSetDesktopStreaming)call.getProtocolProvider().getOperationSet(OperationSetDesktopStreaming.class);
        if (desktopSharing == null) {
            this.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.NO_DESKTOP_SHARING_FOR_PROTOCOL"));
            this.desktopSharingAvailable = false;
        } else if (!ConfigurationUtils.hasEnabledVideoFormat((ProtocolProviderService)call.getProtocolProvider())) {
            this.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.NO_VIDEO_ENCODINGS"));
            this.desktopSharingAvailable = false;
        } else {
            this.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.SHARE_DESKTOP_WITH_CONTACT"));
            this.desktopSharingAvailable = true;
        }
        super.setEnabled(this.desktopSharingAvailable);
    }

    @Override
    public void buttonPressed() {
        if (this.call != null) {
            if (CallManager.isDesktopSharingEnabled(this.call)) {
                CallManager.enableDesktopSharing(this.call, false);
            } else {
                this.setSelected(false);
                JPopupMenu sharingMenu = this.createDesktopSharingMenu();
                Point location = new Point(this.getX(), this.getY() + this.getHeight());
                SwingUtilities.convertPointToScreen(location, this.getParent());
                sharingMenu.setLocation(location);
                sharingMenu.setVisible(true);
            }
        }
    }

    private JPopupMenu createDesktopSharingMenu() {
        final JPopupMenu popupMenu = new JPopupMenu(GuiActivator.getResources().getI18NString("service.gui.SHARE_DESKTOP"));
        popupMenu.setInvoker((Component)((Object)this));
        popupMenu.setFocusable(true);
        JMenuItem shareFullScreen = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SHARE_FULL_SCREEN"), new ImageIcon(ImageLoader.getImage(ImageLoader.DESKTOP_SHARING)));
        JMenuItem shareRegion = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SHARE_REGION"), new ImageIcon(ImageLoader.getImage(ImageLoader.REGION_DESKTOP_SHARING)));
        popupMenu.add(shareFullScreen);
        popupMenu.add(shareRegion);
        shareFullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.setVisible(false);
                CallManager.enableDesktopSharing(DesktopSharingButton.this.call, true);
            }
        });
        shareRegion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.setVisible(false);
                CallManager.enableRegionDesktopSharing(DesktopSharingButton.this.call, true);
            }
        });
        return popupMenu;
    }

    public void setEnabled(final boolean enable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesktopSharingButton.this.setEnabled(enable);
                }
            });
            return;
        }
        if (this.desktopSharingAvailable) {
            super.setEnabled(enable);
        }
    }
}

